/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kit.listeners;

import io.github.nucleuspowered.nucleus.api.core.event.NucleusFirstJoinEvent;
import io.github.nucleuspowered.nucleus.api.module.kit.data.Kit;
import io.github.nucleuspowered.nucleus.modules.core.events.UserDataLoadedEvent;
import io.github.nucleuspowered.nucleus.modules.kit.KitKeys;
import io.github.nucleuspowered.nucleus.modules.kit.services.KitService;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IUserDataObject;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IStorageManager;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.filter.type.Exclude;
import org.spongepowered.api.event.item.inventory.InteractInventoryEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;

public class KitListener
implements ListenerBase {
    private final KitService handler;
    private final IMessageProviderService messageProviderService;
    private final IStorageManager storageManager;

    @Inject
    public KitListener(INucleusServiceCollection serviceCollection) {
        this.handler = serviceCollection.getServiceUnchecked(KitService.class);
        this.messageProviderService = serviceCollection.messageProvider();
        this.storageManager = serviceCollection.storageManager();
    }

    @Listener
    public void onUserDataLoader(UserDataLoadedEvent event) {
        IUserDataObject dataObject = event.getDataObject();
        if (dataObject.has(KitKeys.LEGACY_KIT_LAST_USED_TIME)) {
            Map data = dataObject.get(KitKeys.LEGACY_KIT_LAST_USED_TIME).orElseGet(HashMap::new);
            Map newData = dataObject.get(KitKeys.REDEEMED_KITS).orElseGet(HashMap::new);
            data.forEach((key, value) -> newData.putIfAbsent(key.toLowerCase(), Instant.ofEpochSecond(value)));
            dataObject.remove(KitKeys.LEGACY_KIT_LAST_USED_TIME);
            dataObject.set(KitKeys.REDEEMED_KITS, newData);
            event.save();
        }
    }

    @Listener
    public void onPlayerFirstJoin(NucleusFirstJoinEvent event, @Getter(value="getTargetEntity") Player player) {
        for (Kit kit : this.handler.getFirstJoinKits()) {
            this.handler.redeemKit(kit, player, true, true, true, true);
        }
    }

    @Listener
    @Exclude(value={InteractInventoryEvent.Open.class})
    public void onPlayerInteractInventory(InteractInventoryEvent event, @Root Player player, @Getter(value="getTargetInventory") Container inventory) {
        this.handler.getCurrentlyOpenInventoryKit(inventory).ifPresent(x -> {
            try {
                ((Kit)x.getFirst()).updateKitInventory((Inventory)x.getSecond());
                this.handler.saveKit((Kit)x.getFirst(), false);
                if (event instanceof InteractInventoryEvent.Close) {
                    this.storageManager.getKitsService().ensureSaved();
                    this.messageProviderService.sendMessageTo((CommandSource)player, "command.kit.edit.success", ((Kit)x.getFirst()).getName());
                    this.handler.removeKitInventoryFromListener(inventory);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.messageProviderService.sendMessageTo((CommandSource)player, "command.kit.edit.error", ((Kit)x.getFirst()).getName());
            }
        });
        if (this.handler.isViewer(inventory)) {
            if (event instanceof InteractInventoryEvent.Close) {
                this.handler.removeViewer(inventory);
            } else {
                event.setCancelled(true);
            }
        }
    }
}

