/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.message.commands;

import io.github.nucleuspowered.nucleus.modules.message.config.MessageConfig;
import io.github.nucleuspowered.nucleus.modules.message.parameter.MessageTargetArgument;
import io.github.nucleuspowered.nucleus.modules.message.services.MessageHandler;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.NotifyIfAFK;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.DisplayNameArgument;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.SelectorArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@EssentialsEquivalent(value={"msg", "tell", "m", "t", "whisper"})
@NonnullByDefault
@NotifyIfAFK(value={"to"})
@Command(aliases={"message", "m", "msg", "whisper", "w", "t"}, basePermission={"nucleus.message.base"}, commandDescriptionKey="message", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.message.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.message.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.message.exempt.cost")}, associatedPermissions={"nucleus.message.colour", "nucleus.message.style", "nucleus.message.url"})
public class MessageCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    static final String TO = "to";
    boolean canMessageSelf = false;

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.onlyOne((CommandElement)GenericArguments.firstParsing((CommandElement[])new CommandElement[]{new MessageTargetArgument(serviceCollection.getServiceUnchecked(MessageHandler.class), (Text)Text.of((String)TO)), new SelectorArgument(new DisplayNameArgument((Text)Text.of((String)TO), DisplayNameArgument.Target.PLAYER_CONSOLE, serviceCollection), Player.class, serviceCollection)})), NucleusParameters.MESSAGE};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        if (context.is(context.requireOne(TO, CommandSource.class)) && !this.canMessageSelf) {
            return context.errorResult("command.message.self", new Object[0]);
        }
        boolean b = context.getServiceCollection().getServiceUnchecked(MessageHandler.class).sendMessage(context.getCommandSource(), context.requireOne(TO, CommandSource.class), context.requireOne("message", String.class));
        return b ? context.successResult() : context.failResult();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.canMessageSelf = serviceCollection.moduleDataProvider().getModuleConfig(MessageConfig.class).isCanMessageSelf();
    }
}

