/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.misc.commands;

import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.data.manipulator.mutable.entity.FoodData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Command(aliases={"feed", "eat"}, basePermission={"nucleus.feed.base"}, commandDescriptionKey="feed", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.feed.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.feed.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.feed.exempt.cost")}, associatedPermissions={"nucleus.feed.others"})
@EssentialsEquivalent(value={"feed", "eat"})
@NonnullByDefault
public class FeedCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.commandElementSupplier().createOnlyOtherUserPermissionElement(true, "nucleus.feed.others")};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Player pl = context.getPlayerFromArgs();
        FoodData foodData = pl.getFoodData();
        Value f = foodData.foodLevel().set(foodData.foodLevel().getDefault());
        Value d = foodData.saturation().set(foodData.saturation().getDefault());
        foodData.set(new BaseValue[]{f, d});
        if (pl.offer((ValueContainer)foodData).isSuccessful()) {
            context.sendMessageTo((MessageReceiver)pl, "command.feed.success.self", new Object[0]);
            if (!context.is(pl)) {
                context.sendMessage("command.feed.success.other", pl.getName());
            }
            return context.successResult();
        }
        return context.errorResult("command.feed.error", new Object[0]);
    }
}

