/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mute.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"checkmuted"}, basePermission={"nucleus.checkmuted.base"}, commandDescriptionKey="checkmuted", async=true)
public class CheckMutedCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        List<UUID> usersInMute = context.getServiceCollection().userCacheService().getMuted();
        if (usersInMute.isEmpty()) {
            context.sendMessage("command.checkmuted.none", new Object[0]);
            return context.successResult();
        }
        Util.getPaginationBuilder(context.getCommandSource()).title(context.getMessage("command.checkmuted.header", new Object[0])).contents((Iterable)usersInMute.stream().map(x -> {
            Text name = context.getServiceCollection().playerDisplayNameService().getDisplayName((UUID)x);
            return name.toBuilder().onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.checkmuted.hover", new Object[0]))).onClick((ClickAction)TextActions.runCommand((String)("/nucleus:checkmute " + x.toString()))).build();
        }).collect(Collectors.toList())).sendTo((MessageReceiver)context.getCommandSource());
        return context.successResult();
    }
}

