/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mute.listeners;

import com.google.common.collect.Sets;
import io.github.nucleuspowered.nucleus.modules.mute.config.MuteConfig;
import io.github.nucleuspowered.nucleus.modules.mute.data.MuteData;
import io.github.nucleuspowered.nucleus.modules.mute.services.MuteHandler;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.command.SendCommandEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;

public class MuteCommandListener
implements ListenerBase.Conditional {
    private final List<String> blockedCommands = new ArrayList<String>();
    private final INucleusServiceCollection serviceCollection;
    private final MuteHandler handler;

    @Inject
    public MuteCommandListener(INucleusServiceCollection serviceCollection) {
        this.serviceCollection = serviceCollection;
        this.handler = serviceCollection.getServiceUnchecked(MuteHandler.class);
    }

    @Listener(order=Order.FIRST)
    public void onPlayerSendCommand(SendCommandEvent event, @Root Player player) {
        if (!this.handler.isMutedCached((User)player)) {
            return;
        }
        String command = event.getCommand().toLowerCase();
        Optional oc = Sponge.getCommandManager().get(command, (CommandSource)player);
        Set cmd = oc.map(commandMapping -> commandMapping.getAllAliases().stream().map(String::toLowerCase).collect(Collectors.toSet())).orElseGet(() -> Sets.newHashSet((Object[])new String[]{command}));
        if (this.blockedCommands.stream().map(String::toLowerCase).anyMatch(cmd::contains)) {
            MuteData muteData = this.handler.getPlayerMuteData((User)player).orElse(null);
            if (muteData == null || muteData.expired()) {
                this.handler.unmutePlayer((User)player);
            } else {
                this.handler.onMute(muteData, player);
                MessageChannel.TO_CONSOLE.send(Text.builder().append(new Text[]{Text.of((String)(player.getName() + " ("))}).append(new Text[]{this.serviceCollection.messageProvider().getMessageFor((CommandSource)player, "standard.muted")}).append(new Text[]{Text.of((String)"): ")}).append(new Text[]{Text.of((String)("/" + event.getCommand() + " " + event.getArguments()))}).build());
                event.setCancelled(true);
            }
        }
    }

    @Override
    public boolean shouldEnable(INucleusServiceCollection serviceCollection) {
        this.blockedCommands.clear();
        this.blockedCommands.addAll(serviceCollection.moduleDataProvider().getModuleConfig(MuteConfig.class).getBlockedCommands());
        return !this.blockedCommands.isEmpty();
    }
}

