/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.serverlist.commands;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.modules.serverlist.config.ServerListConfig;
import io.github.nucleuspowered.nucleus.modules.serverlist.services.ServerListService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.texttemplatefactory.NucleusTextTemplateImpl;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.ArrayList;
import java.util.List;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"serverlist", "sl"}, basePermission={"nucleus.serverlist.base"}, commandDescriptionKey="serverlist", async=true)
public class ServerListCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private ServerListConfig slc = new ServerListConfig();

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"m", "-messages"}).flag(new String[]{"w", "-whitelist"}).buildWith(GenericArguments.none())};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        if (context.hasAny("m")) {
            this.onMessage(context, this.slc.getMessages(), "command.serverlist.head.messages");
            return context.successResult();
        }
        if (context.hasAny("w")) {
            this.onMessage(context, this.slc.getWhitelist(), "command.serverlist.head.whitelist");
            return context.successResult();
        }
        if (this.slc.isModifyServerList()) {
            context.sendMessage("command.serverlist.modify.true", new Object[0]);
            if (!this.slc.getMessages().isEmpty()) {
                context.sendMessageText(context.getMessage("command.serverlist.messages.click", new Object[0]).toBuilder().onClick((ClickAction)TextActions.runCommand((String)"/nucleus:serverlist -m")).toText());
            }
            if (!this.slc.getWhitelist().isEmpty()) {
                context.sendMessageText(context.getMessage("command.serverlist.whitelistmessages.click", new Object[0]).toBuilder().onClick((ClickAction)TextActions.runCommand((String)"/nucleus:serverlist -w")).toText());
            }
        } else if (this.slc.getModifyServerList() == ServerListConfig.ServerListSelection.WHITELIST) {
            context.sendMessage("command.serverlist.modify.whitelist", new Object[0]);
            if (!this.slc.getWhitelist().isEmpty()) {
                context.sendMessageText(context.getMessage("command.serverlist.whitelistmessages.click", new Object[0]).toBuilder().onClick((ClickAction)TextActions.runCommand((String)"/nucleus:serverlist -w")).toText());
            }
        } else {
            context.sendMessage("command.serverlist.modify.false", new Object[0]);
        }
        ServerListService ss = context.getServiceCollection().getServiceUnchecked(ServerListService.class);
        ss.getMessage().ifPresent(t -> {
            context.sendMessageText(Util.SPACE);
            context.sendMessage("command.serverlist.tempheader", new Object[0]);
            context.sendMessageText((Text)t);
            context.sendMessage("command.serverlist.message.expiry", context.getTimeToNowString(ss.getExpiry().get()));
        });
        if (this.slc.isHidePlayerCount()) {
            context.sendMessage("command.serverlist.hideplayers", new Object[0]);
        } else if (this.slc.isHideVanishedPlayers()) {
            context.sendMessage("command.serverlist.hidevanished", new Object[0]);
        }
        return context.successResult();
    }

    private void onMessage(ICommandContext<? extends CommandSource> context, List<NucleusTextTemplateImpl> messages, String key) throws CommandException {
        if (messages.isEmpty()) {
            throw context.createException("command.serverlist.nomessages", new Object[0]);
        }
        CommandSource source = context.getCommandSource();
        ArrayList m = Lists.newArrayList();
        messages.stream().map(x -> x.getForCommandSource(source)).forEach(x -> {
            if (!m.isEmpty()) {
                m.add(Util.SPACE);
            }
            m.add(x);
        });
        Util.getPaginationBuilder(source).contents((Iterable)m).title(context.getMessage(key, new Object[0])).sendTo((MessageReceiver)source);
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.slc = serviceCollection.moduleDataProvider().getModuleConfig(ServerListConfig.class);
    }
}

