/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.serverlist.commands;

import io.github.nucleuspowered.nucleus.modules.serverlist.commands.ServerListCommand;
import io.github.nucleuspowered.nucleus.modules.serverlist.services.ServerListService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.BoundedIntegerArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"message", "m"}, basePermission={"nucleus.serverlist.message.base"}, commandDescriptionKey="serverlist.message", async=true, parentCommand=ServerListCommand.class)
public class TemporaryMessageCommand
implements ICommandExecutor<CommandSource> {
    private final String line = "line";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"r", "-remove"}).valueFlag((CommandElement)new BoundedIntegerArgument((Text)Text.of((String)this.line), 1, 2, serviceCollection), new String[]{"l", "-line"}).valueFlag(NucleusParameters.DURATION.get(serviceCollection), new String[]{"t", "-time"}).buildWith(NucleusParameters.OPTIONAL_MESSAGE)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        ServerListService mod = context.getServiceCollection().getServiceUnchecked(ServerListService.class);
        if (context.hasAny("r")) {
            if (mod.getMessage().isPresent()) {
                mod.clearMessage();
                context.sendMessage("command.serverlist.message.removed", new Object[0]);
                return context.successResult();
            }
            return context.errorResult("command.serverlist.message.noremoved", new Object[0]);
        }
        boolean linetwo = context.getOne(this.line, Integer.class).map(x -> x == 2).orElse(false);
        Optional<String> onMessage = context.getOne("message", String.class);
        if (!onMessage.isPresent()) {
            boolean isValid = mod.getExpiry().map(x -> x.isAfter(Instant.now())).orElse(false);
            if (!isValid) {
                return context.errorResult("command.serverlist.message.isempty", new Object[0]);
            }
            if (linetwo) {
                mod.updateLineTwo(null);
            } else {
                mod.updateLineOne(null);
            }
            Optional<Text> newMessage = mod.getMessage();
            if (newMessage.isPresent()) {
                context.sendMessage("command.serverlist.message.set", new Object[0]);
                context.sendMessageText(newMessage.get());
            } else {
                context.sendMessage("command.serverlist.message.empty", new Object[0]);
            }
            return context.successResult();
        }
        String nMessage = onMessage.get();
        Instant endTime = context.getOne("duration", Long.class).map(x -> Instant.now().plus((long)x, ChronoUnit.SECONDS)).orElseGet(() -> mod.getExpiry().map(x -> x.isBefore(Instant.now()) ? x.plusSeconds(3600L) : x).orElseGet(() -> Instant.now().plusSeconds(3600L)));
        if (linetwo) {
            mod.setMessage(null, nMessage, endTime);
        } else {
            mod.setMessage(nMessage, null, endTime);
        }
        Optional<Text> newMessage = mod.getMessage();
        if (newMessage.isPresent()) {
            context.sendMessage("command.serverlist.message.set", new Object[0]);
            context.sendMessageText(newMessage.get());
            context.sendMessage("command.serverlist.message.expiry", context.getTimeToNowString(endTime));
            return context.successResult();
        }
        return context.errorResult("command.serverlist.message.notset", new Object[0]);
    }
}

