/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warp.data;

import com.flowpowered.math.vector.Vector3d;
import io.github.nucleuspowered.nucleus.api.module.warp.data.Warp;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.storage.WorldProperties;

public class WarpData
implements Warp {
    private final String category;
    private final Double cost;
    private final Text description;
    private final UUID worldPropertiesUUID;
    private final Vector3d position;
    private final Vector3d rotation;
    private final String name;

    public WarpData(String category, double cost, Text description, UUID worldPropertiesUUID, Vector3d position, Vector3d rotation, String name) {
        this.category = category;
        this.cost = cost == 0.0 ? null : Double.valueOf(cost);
        this.description = description;
        this.worldPropertiesUUID = worldPropertiesUUID;
        this.position = position;
        this.rotation = rotation;
        this.name = name;
    }

    @Override
    public Optional<String> getCategory() {
        return Optional.ofNullable(this.category);
    }

    @Override
    public Optional<Double> getCost() {
        return Optional.ofNullable(this.cost);
    }

    @Override
    public Optional<Text> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    public UUID getWorldUUID() {
        return this.worldPropertiesUUID;
    }

    @Override
    public Optional<WorldProperties> getWorldProperties() {
        return Sponge.getServer().getWorldProperties(this.worldPropertiesUUID);
    }

    @Override
    public Vector3d getRotation() {
        return this.rotation;
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public Optional<Location<World>> getLocation() {
        return Sponge.getServer().getWorld(this.worldPropertiesUUID).map(x -> new Location((Extent)x, this.position));
    }

    @Override
    public Optional<Transform<World>> getTransform() {
        return Sponge.getServer().getWorld(this.worldPropertiesUUID).map(x -> new Transform((Extent)x, this.position, this.rotation));
    }

    @Override
    public String getName() {
        return this.name;
    }
}

