/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warp.parameters;

import com.google.common.collect.ImmutableList;
import io.github.nucleuspowered.nucleus.api.module.warp.NucleusWarpService;
import io.github.nucleuspowered.nucleus.modules.warp.WarpPermissions;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public class WarpArgument
extends CommandElement {
    private final NucleusWarpService service;
    private final IMessageProviderService messageProviderService;
    private final IPermissionService permissionService;
    private final boolean permissionCheck;

    public WarpArgument(@Nullable Text key, INucleusServiceCollection serviceCollection, NucleusWarpService warpService, boolean permissionCheck) {
        super(key);
        this.permissionCheck = permissionCheck;
        this.permissionService = serviceCollection.permissionService();
        this.messageProviderService = serviceCollection.messageProvider();
        this.service = warpService;
    }

    @Nullable
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        String warpName = args.next();
        String warp = warpName.toLowerCase();
        if (!this.service.warpExists(warp)) {
            throw args.createError(this.messageProviderService.getMessageFor(source, "args.warps.noexist"));
        }
        if (this.permissionCheck && !this.checkPermission(source, warpName) && !this.checkPermission(source, warpName.toLowerCase())) {
            throw args.createError(this.messageProviderService.getMessageFor(source, "args.warps.noperms"));
        }
        return this.service.getWarp(warpName).orElseThrow(() -> args.createError(this.messageProviderService.getMessageFor(source, "args.warps.notavailable")));
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        try {
            String el = args.peek();
            String name = el.toLowerCase();
            List<String> elements = this.service.getWarpNames().stream().filter(s -> s.startsWith(name)).limit(21L).collect(Collectors.toList());
            if (elements.size() >= 21) {
                this.messageProviderService.sendMessageTo(src, "args.warps.maxselect", el);
                return ImmutableList.of((Object)el);
            }
            if (elements.isEmpty()) {
                return ImmutableList.of();
            }
            if (!this.permissionCheck) {
                return elements;
            }
            Predicate<String> predicate = s -> this.service.getWarp((String)s).get().getLocation().isPresent() && this.checkPermission(src, (String)s);
            return elements.stream().filter(predicate).collect(Collectors.toList());
        }
        catch (ArgumentParseException e) {
            return ImmutableList.of();
        }
    }

    private boolean checkPermission(CommandSource src, String name) {
        return this.permissionService.hasPermission((Subject)src, WarpPermissions.getWarpPermission(name));
    }
}

