/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warp.services;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.api.module.warp.NucleusWarpService;
import io.github.nucleuspowered.nucleus.api.module.warp.data.Warp;
import io.github.nucleuspowered.nucleus.api.module.warp.data.WarpCategory;
import io.github.nucleuspowered.nucleus.modules.warp.WarpKeys;
import io.github.nucleuspowered.nucleus.modules.warp.data.WarpCategoryData;
import io.github.nucleuspowered.nucleus.modules.warp.data.WarpData;
import io.github.nucleuspowered.nucleus.modules.warp.parameters.WarpArgument;
import io.github.nucleuspowered.nucleus.modules.warp.parameters.WarpCategoryArgument;
import io.github.nucleuspowered.nucleus.scaffold.service.ServiceBase;
import io.github.nucleuspowered.nucleus.scaffold.service.annotations.APIService;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IGeneralDataObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@NonnullByDefault
@Singleton
@APIService(value=NucleusWarpService.class)
public class WarpService
implements NucleusWarpService,
ServiceBase {
    public static final String WARP_KEY = "warp";
    public static final String WARP_CATEGORY_KEY = "warp category";
    @Nullable
    private Map<String, Warp> warpCache = null;
    @Nullable
    private Map<String, WarpCategory> warpCategoryCache = null;
    @Nullable
    private List<Warp> uncategorised = null;
    private final Map<String, List<Warp>> categoryCollectionMap = new HashMap<String, List<Warp>>();
    private final INucleusServiceCollection serviceCollection;
    private final WarpArgument warpPermissionArgument;
    private final WarpArgument warpNoPermissionArgument;
    private final WarpCategoryArgument warpCategoryArgument;

    @Inject
    public WarpService(INucleusServiceCollection serviceCollection) {
        this.serviceCollection = serviceCollection;
        this.warpPermissionArgument = new WarpArgument((Text)Text.of((String)WARP_KEY), serviceCollection, this, true);
        this.warpNoPermissionArgument = new WarpArgument((Text)Text.of((String)WARP_KEY), serviceCollection, this, false);
        this.warpCategoryArgument = new WarpCategoryArgument((Text)Text.of((String)WARP_CATEGORY_KEY), serviceCollection, this);
    }

    private Map<String, Warp> getWarpCache() {
        if (this.warpCache == null) {
            this.updateCache();
        }
        return this.warpCache;
    }

    private Map<String, WarpCategory> getWarpCategoryCache() {
        if (this.warpCategoryCache == null) {
            this.updateCache();
        }
        return this.warpCategoryCache;
    }

    private void updateCache() {
        this.categoryCollectionMap.clear();
        this.warpCache = new HashMap<String, Warp>();
        this.warpCategoryCache = new HashMap<String, WarpCategory>();
        this.uncategorised = null;
        IGeneralDataObject dataObject = (IGeneralDataObject)this.serviceCollection.storageManager().getGeneralService().getOrNewOnThread();
        dataObject.get(WarpKeys.WARP_NODES).orElseGet(ImmutableMap::of).forEach((key, value) -> this.warpCache.put(key.toLowerCase(), (Warp)value));
        this.warpCategoryCache.putAll(dataObject.get(WarpKeys.WARP_CATEGORIES).orElseGet(ImmutableMap::of));
    }

    private void saveFromCache() {
        if (this.warpCache == null || this.warpCategoryCache == null) {
            return;
        }
        IGeneralDataObject dataObject = (IGeneralDataObject)this.serviceCollection.storageManager().getGeneralService().getOrNewOnThread();
        dataObject.set(WarpKeys.WARP_NODES, new HashMap<String, Warp>(this.warpCache));
        dataObject.set(WarpKeys.WARP_CATEGORIES, new HashMap<String, WarpCategory>(this.warpCategoryCache));
        this.serviceCollection.storageManager().getGeneralService().save(dataObject);
    }

    public CommandElement warpElement(boolean requirePermission) {
        if (requirePermission) {
            return this.warpPermissionArgument;
        }
        return this.warpNoPermissionArgument;
    }

    public CommandElement warpCategoryElement() {
        return this.warpCategoryArgument;
    }

    @Override
    public Optional<Warp> getWarp(String warpName) {
        return Optional.ofNullable(this.getWarpCache().get(warpName.toLowerCase()));
    }

    @Override
    public boolean removeWarp(String warpName) {
        if (this.getWarpCache().remove(warpName.toLowerCase()) != null) {
            this.saveFromCache();
            return true;
        }
        return false;
    }

    @Override
    public boolean setWarp(String warpName, Location<World> location, Vector3d rotation) {
        String key;
        Map<String, Warp> cache = this.getWarpCache();
        if (!cache.containsKey(key = warpName.toLowerCase())) {
            cache.put(key, new WarpData(null, 0.0, null, ((World)location.getExtent()).getUniqueId(), location.getPosition(), rotation, warpName));
            this.saveFromCache();
            return true;
        }
        return false;
    }

    @Override
    public List<Warp> getAllWarps() {
        return ImmutableList.copyOf(this.getWarpCache().values());
    }

    @Override
    public List<Warp> getUncategorisedWarps() {
        if (this.uncategorised == null) {
            this.uncategorised = Lists.newArrayList((Iterable)this.getAllWarps().stream().filter(x -> !x.getCategory().isPresent()).collect(Collectors.toList()));
        }
        return ImmutableList.copyOf(this.uncategorised);
    }

    @Override
    public List<Warp> getWarpsForCategory(String category) {
        List warps = this.categoryCollectionMap.computeIfAbsent(category.toLowerCase(), c -> Lists.newArrayList((Iterable)this.getAllWarps().stream().filter(x -> x.getCategory().map(cat -> cat.equalsIgnoreCase((String)c)).orElse(false)).collect(Collectors.toList())));
        return ImmutableList.copyOf((Collection)warps);
    }

    @Override
    public Map<WarpCategory, List<Warp>> getWarpsWithCategories() {
        return this.getWarpsWithCategories(t -> true);
    }

    @Override
    public Map<WarpCategory, List<Warp>> getWarpsWithCategories(Predicate<Warp> warpDataPredicate) {
        HashMap<WarpCategory, List<Warp>> map = new HashMap<WarpCategory, List<Warp>>();
        this.getWarpCategoryCache().keySet().forEach(x -> {
            List warps = this.getWarpsForCategory((String)x).stream().filter(warpDataPredicate).collect(Collectors.toList());
            if (!warps.isEmpty()) {
                map.put(this.getWarpCategoryCache().get(x.toLowerCase()), warps);
            }
        });
        return map;
    }

    @Override
    public boolean removeWarpCost(String warpName) {
        Optional<Warp> warp = this.getWarp(warpName);
        if (warp.isPresent()) {
            Warp w = warp.get();
            this.removeWarp(warpName);
            this.getWarpCache().put(w.getName().toLowerCase(), new WarpData(w.getCategory().orElse(null), 0.0, w.getDescription().orElse(null), w.getWorldUUID(), w.getPosition(), w.getRotation(), w.getName()));
            this.saveFromCache();
            return true;
        }
        return false;
    }

    @Override
    public boolean setWarpCost(String warpName, double cost) {
        if (cost < 0.0) {
            return false;
        }
        Optional<Warp> warp = this.getWarp(warpName);
        if (warp.isPresent()) {
            Warp w = warp.get();
            this.removeWarp(warpName);
            this.getWarpCache().put(w.getName().toLowerCase(), new WarpData(w.getCategory().orElse(null), cost, w.getDescription().orElse(null), w.getWorldUUID(), w.getPosition(), w.getRotation(), w.getName()));
            this.saveFromCache();
            return true;
        }
        return false;
    }

    @Override
    public boolean setWarpCategory(String warpName, @Nullable String category) {
        if (category != null) {
            Optional<WarpCategory> c = this.getWarpCategory(category);
            if (!c.isPresent()) {
                WarpCategoryData wc = new WarpCategoryData(category, null, null);
                this.getWarpCategoryCache().put(category.toLowerCase(), wc);
            } else {
                this.categoryCollectionMap.remove(category.toLowerCase());
            }
            category = category.toLowerCase();
        } else {
            this.uncategorised = null;
        }
        Optional<Warp> warp = this.getWarp(warpName);
        if (warp.isPresent()) {
            Warp w = warp.get();
            this.removeWarp(warpName);
            this.getWarpCache().put(w.getName().toLowerCase(), new WarpData(category, w.getCost().orElse(0.0), w.getDescription().orElse(null), w.getWorldUUID(), w.getPosition(), w.getRotation(), w.getName()));
            this.saveFromCache();
            return true;
        }
        return false;
    }

    @Override
    public boolean setWarpDescription(String warpName, @Nullable Text description) {
        Optional<Warp> warp = this.getWarp(warpName);
        if (warp.isPresent()) {
            Warp w = warp.get();
            this.removeWarp(warpName);
            this.getWarpCache().put(w.getName().toLowerCase(), new WarpData(w.getCategory().orElse(null), w.getCost().orElse(0.0), description, w.getWorldUUID(), w.getPosition(), w.getRotation(), w.getName()));
            this.saveFromCache();
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getWarpNames() {
        return this.getWarpCache().keySet();
    }

    @Override
    public Optional<WarpCategory> getWarpCategory(String category) {
        return Optional.ofNullable(this.getWarpCategoryCache().get(category.toLowerCase()));
    }

    @Override
    public boolean setWarpCategoryDisplayName(String category, @Nullable Text displayName) {
        Optional<WarpCategory> c = this.getWarpCategory(category);
        if (c.isPresent()) {
            WarpCategory cat = c.get();
            this.getWarpCategoryCache().remove(category.toLowerCase());
            this.getWarpCategoryCache().put(category.toLowerCase(), new WarpCategoryData(cat.getId(), displayName, cat.getDescription().orElse(null)));
            this.saveFromCache();
            return true;
        }
        return false;
    }

    @Override
    public boolean setWarpCategoryDescription(String category, @Nullable Text description) {
        Optional<WarpCategory> c = this.getWarpCategory(Objects.requireNonNull(category));
        if (c.isPresent()) {
            WarpCategory cat = c.get();
            this.getWarpCategoryCache().remove(category.toLowerCase());
            this.getWarpCategoryCache().put(category.toLowerCase(), new WarpCategoryData(cat.getId(), cat.getDisplayName(), description));
            this.saveFromCache();
            return true;
        }
        return false;
    }
}

