/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands.border;

import io.github.nucleuspowered.nucleus.modules.world.commands.border.BorderCommand;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.PositiveIntegerArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.storage.WorldProperties;

@NonnullByDefault
@Command(aliases={"set"}, basePermission={"nucleus.world.border.set.base"}, commandDescriptionKey="world.border.set", parentCommand=BorderCommand.class)
public class SetBorderCommand
implements ICommandExecutor<CommandSource> {
    private final String xKey = "x";
    private final String zKey = "z";
    private final String diameter = "diameter";
    private final String delayKey = "delay";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.firstParsing((CommandElement[])new CommandElement[]{GenericArguments.seq((CommandElement[])new CommandElement[]{NucleusParameters.OPTIONAL_WORLD_PROPERTIES_ALL.get(serviceCollection), GenericArguments.onlyOne((CommandElement)GenericArguments.integer((Text)Text.of((String)this.xKey))), GenericArguments.onlyOne((CommandElement)GenericArguments.integer((Text)Text.of((String)this.zKey))), GenericArguments.onlyOne((CommandElement)new PositiveIntegerArgument((Text)Text.of((String)this.diameter), serviceCollection)), GenericArguments.onlyOne((CommandElement)GenericArguments.optional((CommandElement)GenericArguments.onlyOne((CommandElement)new PositiveIntegerArgument((Text)Text.of((String)this.delayKey), serviceCollection))))}), GenericArguments.seq((CommandElement[])new CommandElement[]{GenericArguments.onlyOne((CommandElement)new PositiveIntegerArgument((Text)Text.of((String)this.diameter), serviceCollection)), GenericArguments.onlyOne((CommandElement)GenericArguments.optional((CommandElement)GenericArguments.onlyOne((CommandElement)new PositiveIntegerArgument((Text)Text.of((String)this.delayKey), serviceCollection))))})})};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        int z;
        int x;
        WorldProperties wp = context.getWorldPropertiesOrFromSelf("world").orElseThrow(() -> context.createException("command.world.player", new Object[0]));
        int dia = context.requireOne(this.diameter, Integer.class);
        int delay = context.getOne(this.delayKey, Integer.class).orElse(0);
        if (context.is(Locatable.class)) {
            Location lw = ((Locatable)context.getCommandSource()).getLocation();
            if (context.hasAny(this.zKey)) {
                x = context.requireOne(this.xKey, Integer.class);
                z = context.requireOne(this.zKey, Integer.class);
            } else {
                x = lw.getBlockX();
                z = lw.getBlockZ();
            }
        } else {
            x = context.requireOne(this.xKey, Integer.class);
            z = context.requireOne(this.zKey, Integer.class);
        }
        wp.setWorldBorderCenter((double)x, (double)z);
        Optional world = Sponge.getServer().getWorld(wp.getUniqueId());
        world.ifPresent(w -> w.getWorldBorder().setCenter((double)x, (double)z));
        wp.setWorldBorderCenter((double)x, (double)z);
        if (delay == 0) {
            world.ifPresent(w -> w.getWorldBorder().setDiameter((double)dia));
            wp.setWorldBorderDiameter((double)dia);
            context.sendMessage("command.world.setborder.set", wp.getWorldName(), String.valueOf(x), String.valueOf(z), String.valueOf(dia));
        } else {
            world.ifPresent(w -> w.getWorldBorder().setDiameter((double)dia, (long)delay * 1000L));
            wp.setWorldBorderTimeRemaining((long)delay * 1000L);
            wp.setWorldBorderTargetDiameter((double)dia);
            context.sendMessage("command.world.setborder.setdelay", wp.getWorldName(), String.valueOf(x), String.valueOf(z), String.valueOf(dia), String.valueOf(delay));
        }
        return context.successResult();
    }
}

