/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.quickstart.module;

import com.google.common.collect.ImmutableMap;
import io.github.nucleuspowered.nucleus.annotationprocessor.Store;
import io.github.nucleuspowered.nucleus.quickstart.annotation.RequireExistenceOf;
import io.github.nucleuspowered.nucleus.quickstart.annotation.RequiresPlatform;
import io.github.nucleuspowered.nucleus.quickstart.annotation.ServerOnly;
import io.github.nucleuspowered.nucleus.quickstart.annotation.SkipOnError;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandInterceptor;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.scaffold.registry.NucleusRegistryModule;
import io.github.nucleuspowered.nucleus.scaffold.service.ServiceBase;
import io.github.nucleuspowered.nucleus.scaffold.service.annotations.APIService;
import io.github.nucleuspowered.nucleus.scaffold.task.TaskBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.playerinformation.NucleusProvider;
import io.github.nucleuspowered.nucleus.services.interfaces.ICommandMetadataService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.services.interfaces.annotation.PermissionMetadata;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.Module;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.annotations.ModuleData;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.config.AbstractConfigAdapter;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.exceptions.MissingDependencyException;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.holders.DiscoveryModuleHolder;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.placeholder.PlaceholderParser;

@Store(isRoot=true)
public abstract class StandardModule
implements Module {
    private final String moduleId;
    private final String moduleName;
    protected final INucleusServiceCollection serviceCollection;
    private final Supplier<DiscoveryModuleHolder<?, ?>> moduleHolderSupplier;
    private final Logger logger;
    private String packageName;
    @Nullable
    private Map<String, List<String>> objectTypesToClassListMap;

    @Inject
    public StandardModule(Supplier<DiscoveryModuleHolder<?, ?>> moduleHolder, INucleusServiceCollection collection) {
        ModuleData md = this.getClass().getAnnotation(ModuleData.class);
        this.moduleId = md.id();
        this.moduleName = md.name();
        this.serviceCollection = collection;
        this.moduleHolderSupplier = moduleHolder;
        this.logger = collection.logger();
    }

    protected final INucleusServiceCollection getServiceCollection() {
        return this.serviceCollection;
    }

    public void init(Map<String, List<String>> m) {
        this.objectTypesToClassListMap = m;
    }

    @Override
    public final void checkExternalDependencies() throws MissingDependencyException {
        if (this.getClass().isAnnotationPresent(ServerOnly.class) && !this.serviceCollection.platformService().isServer()) {
            throw new MissingDependencyException("This module is server only and will not be loaded.");
        }
    }

    protected Map<String, PlaceholderParser> tokensToRegister() {
        return ImmutableMap.of();
    }

    @Override
    public Optional<AbstractConfigAdapter<?>> getConfigAdapter() {
        return Optional.empty();
    }

    public final void loadServices() throws Exception {
        Set servicesToLoad = this.objectTypesToClassListMap != null ? this.getClassesFromList("service") : this.getStreamForModule(ServiceBase.class).collect(Collectors.toSet());
        for (Class serviceClass : servicesToLoad) {
            this.registerService(serviceClass);
        }
    }

    private void registerReloadable(Object instance) {
        if (instance instanceof IReloadableService.Reloadable) {
            IReloadableService.Reloadable reloadable = (IReloadableService.Reloadable)instance;
            this.serviceCollection.reloadableService().registerReloadable(reloadable);
            reloadable.onReload(this.serviceCollection);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends ServiceBase> void registerService(Class<T> serviceClass) {
        ServiceBase serviceImpl = (ServiceBase)this.getInstance(serviceClass);
        if (serviceImpl == null) {
            String error = "ERROR: Cannot instantiate " + serviceClass.getName();
            this.logger.error(error);
            throw new IllegalStateException(error);
        }
        APIService apiService = serviceClass.getAnnotation(APIService.class);
        if (apiService != null) {
            Class<?> apiInterface = apiService.value();
            if (!apiInterface.isInstance(serviceImpl)) {
                String error = "ERROR: " + apiInterface.getName() + " does not inherit from " + serviceClass.getName();
                this.logger.error(error);
                throw new IllegalStateException(error);
            }
            this.register(apiInterface, serviceClass, serviceImpl);
        } else {
            this.register(serviceClass, serviceImpl);
        }
        this.registerReloadable(serviceImpl);
        if (serviceImpl instanceof IReloadableService.DataLocationReloadable) {
            this.serviceCollection.reloadableService().registerDataFileReloadable((IReloadableService.DataLocationReloadable)((Object)serviceImpl));
        }
        if (!(serviceImpl instanceof ContextCalculator)) return;
        try {
            serviceImpl.getClass().getMethod("matches", Context.class, Subject.class);
            this.serviceCollection.permissionService().registerContextCalculator((ContextCalculator<Subject>)((ContextCalculator)serviceImpl));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void registerCommandInterceptors() {
        Set interceptors = this.objectTypesToClassListMap != null ? this.getClassesFromList("command-interceptor") : this.getStreamForModule(ICommandInterceptor.class).collect(Collectors.toSet());
        if (!interceptors.isEmpty()) {
            for (Class service : interceptors) {
                ICommandInterceptor impl;
                try {
                    impl = (ICommandInterceptor)service.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    String error = "ERROR: Cannot instantiate ICommandInterceptor " + service.getName();
                    this.serviceCollection.logger().error(error);
                    throw new IllegalStateException(error, e);
                }
                this.registerReloadable(impl);
                this.serviceCollection.commandMetadataService().registerInterceptor(impl);
            }
        }
    }

    public final void loadCommands() {
        Set cmds = this.objectTypesToClassListMap != null ? this.getClassesFromList("command") : this.performFilter(this.getStreamForModule(ICommandExecutor.class).map(x -> x)).collect(Collectors.toSet());
        ICommandMetadataService metadataService = this.serviceCollection.commandMetadataService();
        for (Class command : cmds) {
            Command rc = command.getAnnotation(Command.class);
            if (rc == null) continue;
            metadataService.registerCommand(this.moduleId, this.moduleName, rc, command);
        }
    }

    public final void prepareAliasedCommands() {
        this.serviceCollection.commandMetadataService().addMapping((Map<String, String>)this.remapCommand());
    }

    private Stream<Class<? extends ICommandExecutor<?>>> performFilter(Stream<Class<? extends ICommandExecutor<?>>> stream) {
        return stream.filter(x -> x.isAnnotationPresent(Command.class));
    }

    public final void loadEvents() {
        Set listenersToLoad = this.objectTypesToClassListMap != null ? this.getClassesFromList("listener") : this.getStreamForModule(ListenerBase.class).collect(Collectors.toSet());
        listenersToLoad.stream().map(x -> (ListenerBase)this.getInstance((Class)x, true)).filter(Objects::nonNull).forEach(c -> {
            if (c instanceof ListenerBase.Conditional) {
                IReloadableService.Reloadable tae = serviceCollection -> {
                    Sponge.getEventManager().unregisterListeners(c);
                    if (c instanceof IReloadableService.Reloadable) {
                        ((IReloadableService.Reloadable)((Object)c)).onReload(serviceCollection);
                    }
                    if (((ListenerBase.Conditional)c).shouldEnable(serviceCollection)) {
                        Sponge.getEventManager().registerListeners((Object)serviceCollection.pluginContainer(), c);
                    }
                };
                this.serviceCollection.reloadableService().registerReloadable(tae);
                try {
                    tae.onReload(this.serviceCollection);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (c instanceof IReloadableService.Reloadable) {
                this.serviceCollection.reloadableService().registerReloadable((IReloadableService.Reloadable)((Object)c));
                Sponge.getEventManager().registerListeners((Object)this.serviceCollection.pluginContainer(), c);
            } else {
                Sponge.getEventManager().registerListeners((Object)this.serviceCollection.pluginContainer(), c);
            }
        });
    }

    public final void loadRunnables() {
        Set tasksToLoad = this.objectTypesToClassListMap != null ? this.getClassesFromList("runnable") : this.getStreamForModule(TaskBase.class).collect(Collectors.toSet());
        tasksToLoad.stream().map(this::getInstance).filter(Objects::nonNull).forEach(c -> {
            Task.Builder tb = Sponge.getScheduler().createTaskBuilder().interval(c.interval().toMillis(), TimeUnit.MILLISECONDS);
            if (this.serviceCollection.platformService().isServer()) {
                tb.execute((Consumer)c);
            } else {
                tb.execute(t -> {
                    if (Sponge.getGame().isServerAvailable()) {
                        c.accept(t);
                    }
                });
            }
            if (c.isAsync()) {
                tb.async();
            }
            tb.submit((Object)this.serviceCollection.pluginContainer());
            if (c instanceof IReloadableService.Reloadable) {
                this.serviceCollection.reloadableService().registerReloadable((IReloadableService.Reloadable)((Object)c));
                try {
                    ((IReloadableService.Reloadable)((Object)c)).onReload(this.serviceCollection);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public final void loadTokens() {
        Map<String, PlaceholderParser> map = this.tokensToRegister();
        if (!map.isEmpty()) {
            map.forEach((k, t) -> {
                try {
                    this.serviceCollection.placeholderService().registerToken((String)k, (PlaceholderParser)t);
                }
                catch (Exception e) {
                    this.serviceCollection.logger().warn("Could not register nucleus token identifier " + k, (Throwable)e);
                }
            });
        }
    }

    public final void loadRegistries() {
        Set registries = this.objectTypesToClassListMap != null ? this.getClassesFromList("registry") : this.getStreamForModule(NucleusRegistryModule.class).collect(Collectors.toSet());
        for (Class r : registries) {
            NucleusRegistryModule instance = (NucleusRegistryModule)this.getInstance(r);
            try {
                instance.registerDefaults();
            }
            catch (Exception e) {
                this.serviceCollection.logger().error("Could not register registry " + r.getName(), (Throwable)e);
            }
        }
    }

    public final void loadInfoProviders() {
        Set registries = this.objectTypesToClassListMap != null ? this.getClassesFromList("playerinfo") : this.getStreamForModule(NucleusProvider.class).collect(Collectors.toSet());
        for (Class r : registries) {
            NucleusProvider instance = (NucleusProvider)this.getInstance(r);
            this.serviceCollection.playerInformationService().registerProvider(instance);
        }
    }

    private <T> Stream<Class<? extends T>> getStreamForModule(Class<T> assignableClass) {
        return this.moduleHolderSupplier.get().getLoadedClasses().stream().filter(assignableClass::isAssignableFrom).filter(x -> x.getPackage().getName().startsWith(this.packageName)).filter(x -> !Modifier.isAbstract(x.getModifiers()) && !Modifier.isInterface(x.getModifiers())).filter(this::checkPlatform).map(x -> x);
    }

    public void performPreTasks(INucleusServiceCollection serviceCollection) throws Exception {
    }

    public void performEnableTasks(INucleusServiceCollection serviceCollection) throws Exception {
    }

    public void performPostTasks(INucleusServiceCollection serviceCollection) {
    }

    public void configTasks() {
    }

    protected ImmutableMap<String, String> remapCommand() {
        return ImmutableMap.of();
    }

    private <T> T getInstance(Class<T> clazz) {
        return this.getInstance(clazz, false);
    }

    private <T> T getInstance(Class<T> clazz, boolean checkMethods) {
        try {
            RequireExistenceOf[] v = (RequireExistenceOf[])clazz.getAnnotationsByType(RequireExistenceOf.class);
            if (v.length > 0) {
                try {
                    for (RequireExistenceOf r : v) {
                        String toFind = r.value();
                        String[] a = toFind.contains("#") ? toFind.split("#", 2) : new String[]{toFind};
                        Class<?> c = Class.forName(a[0]);
                        if (a.length != 2) continue;
                        Method[] methods = c.getDeclaredMethods();
                        boolean methodFound = false;
                        for (Method m : methods) {
                            if (!m.getName().equals(a[1])) continue;
                            methodFound = true;
                            break;
                        }
                        if (methodFound) continue;
                        if (r.showError()) {
                            throw new RuntimeException();
                        }
                        return null;
                    }
                }
                catch (ClassNotFoundException | NoClassDefFoundError | RuntimeException e) {
                    this.serviceCollection.logger().warn(this.serviceCollection.messageProvider().getMessageString("startup.injectablenotloaded", clazz.getName()));
                    return null;
                }
            }
            if (checkMethods) {
                clazz.getDeclaredMethods();
            }
            return this.construct(clazz);
        }
        catch (Exception | NoClassDefFoundError e) {
            if (clazz.isAnnotationPresent(SkipOnError.class)) {
                this.serviceCollection.logger().warn(this.serviceCollection.messageProvider().getMessageString("startup.injectablenotloaded", clazz.getName()));
                return null;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private <T extends Class<?>> Optional<T> checkPlatformOpt(T clazz) {
        if (this.checkPlatform(clazz)) {
            return Optional.of(clazz);
        }
        return Optional.empty();
    }

    private <T extends Class<?>> boolean checkPlatform(T clazz) {
        if (clazz.isAnnotationPresent(RequiresPlatform.class)) {
            String platformId = Sponge.getPlatform().getContainer(Platform.Component.GAME).getId();
            boolean loadable = Arrays.stream(clazz.getAnnotation(RequiresPlatform.class).value()).anyMatch(platformId::equalsIgnoreCase);
            if (!loadable) {
                this.serviceCollection.logger().warn("Not loading /" + clazz.getSimpleName() + ": platform " + platformId + " is not supported.");
                return false;
            }
        }
        return true;
    }

    protected final <I, S extends I> void register(Class<S> impl) {
        this.register(impl, this.serviceCollection.injector().getInstance(impl));
    }

    protected final <I, S extends I> void register(Class<I> api, Class<S> impl) {
        Object object = this.serviceCollection.injector().getInstance(impl);
        Sponge.getServiceManager().setProvider((Object)this.serviceCollection.pluginContainer(), api, object);
        this.register(api, object);
        this.register(impl, object);
    }

    protected final <I, S extends I> void register(Class<? super S> impl, S object) {
        this.serviceCollection.registerService(impl, object, false);
    }

    protected final <I, S extends I> void register(Class<I> internalApi, Class<S> impl, S object, boolean remap) {
        this.register(impl, object);
        this.serviceCollection.registerService(internalApi, object, remap);
    }

    protected final <I, S extends I> void register(Class<I> api, Class<S> impl, S object) {
        Sponge.getServiceManager().setProvider((Object)this.serviceCollection.pluginContainer(), api, object);
        this.serviceCollection.registerService(api, object, false);
        this.register(impl, object);
    }

    private <T> Set<Class<? extends T>> getClassesFromList(String key) {
        List<String> list = this.objectTypesToClassListMap.get(key);
        if (list == null) {
            return new HashSet<Class<? extends T>>();
        }
        HashSet<Class<? extends T>> classes = new HashSet<Class<? extends T>>();
        for (String s : list) {
            try {
                this.checkPlatformOpt(Class.forName(s)).ifPresent(classes::add);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return classes;
    }

    private <T> T construct(Class<T> cls) throws Exception {
        try {
            Constructor<T> c = cls.getDeclaredConstructor(INucleusServiceCollection.class);
            c.setAccessible(true);
            return c.newInstance(this.serviceCollection);
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor<T> c = cls.getDeclaredConstructor(new Class[0]);
                c.setAccessible(true);
                return c.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException ex) {
                return (T)this.serviceCollection.injector().getInstance(cls);
            }
        }
    }

    public void registerPermissions() {
        IPermissionService permissionService = this.serviceCollection.permissionService();
        for (Class c : this.getClassesFromList("permission")) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.isAnnotationPresent(PermissionMetadata.class) || !String.class.isAssignableFrom(field.getType()) || (field.getModifiers() & 8) != 8) continue;
                try {
                    permissionService.register(field.get(null).toString(), field.getAnnotation(PermissionMetadata.class), this.moduleId);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

