/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.scaffold.command.control;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.control.CommandControl;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandPermissionException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

public class UsageCommand {
    private final CommandControl attachedCommandControl;

    UsageCommand(CommandControl attachedCommandControl) {
        this.attachedCommandControl = attachedCommandControl;
    }

    void process(ICommandContext<? extends CommandSource> commandContext, String command, @Nullable String previous) throws CommandException {
        if (!this.attachedCommandControl.testPermission(commandContext.getCommandSourceUnchecked())) {
            commandContext.sendMessage("command.usage.nopermission", new Object[0]);
            return;
        }
        try {
            List<Text> textMessages = this.usage(commandContext, command, previous);
            Text header = commandContext.getMessage("command.usage.header", command);
            Util.getPaginationBuilder(commandContext.getCommandSource()).title(header).contents(textMessages).sendTo((MessageReceiver)commandContext.getCommandSource());
        }
        catch (CommandPermissionException e) {
            commandContext.sendMessage("command.usage.nopermission", new Object[0]);
        }
    }

    public List<Text> usage(ICommandContext<? extends CommandSource> context, String command, @Nullable String previous) throws CommandPermissionException {
        Text subcommands;
        Optional<Text> ext;
        if (!this.attachedCommandControl.testPermission(context.getCommandSourceUnchecked())) {
            throw new CommandPermissionException();
        }
        ArrayList textMessages = Lists.newArrayList();
        if (previous != null) {
            textMessages.add(context.getMessage("command.usage.noexist", previous));
            textMessages.add(Util.SPACE);
        }
        if (this.attachedCommandControl.getSourceType() == Player.class) {
            textMessages.add(context.getMessage("command.usage.playeronly", new Object[0]));
        }
        textMessages.add(context.getMessage("command.usage.module", this.attachedCommandControl.getMetadata().getModulename(), this.attachedCommandControl.getMetadata().getModuleid()));
        textMessages.add(context.getMessage("command.usage.context", this.attachedCommandControl.getContext().getKey(), this.attachedCommandControl.getContext().getValue()));
        String prefix = command.replaceAll("[\\S]+$", "");
        String result = "/" + this.attachedCommandControl.getAliases().stream().map(x -> {
            if (x.startsWith("#")) {
                return x.substring(1);
            }
            return prefix + x;
        }).collect(Collectors.joining(", /"));
        textMessages.add(context.getMessage("command.usage.aliases", result));
        Optional<Text> desc = this.attachedCommandControl.getShortDescription(context.getCommandSourceUnchecked());
        if (desc.isPresent()) {
            textMessages.add(Util.SPACE);
            textMessages.add(context.getMessage("command.usage.summary", new Object[0]));
            textMessages.add(desc.get());
        }
        if ((ext = this.attachedCommandControl.getExtendedDescription(context.getCommandSourceUnchecked())).isPresent()) {
            textMessages.add(Util.SPACE);
            textMessages.add(context.getMessage("command.usage.description", new Object[0]));
            textMessages.add(ext.get());
        }
        if (this.attachedCommandControl.hasExecutor()) {
            textMessages.add(Util.SPACE);
            textMessages.add(context.getMessage("command.usage.usage", new Object[0]));
            textMessages.add(Text.of((Object[])new Object[]{TextColors.WHITE, this.attachedCommandControl.getUsageText(context.getCommandSourceUnchecked())}));
        }
        if (!(subcommands = this.attachedCommandControl.getSubcommandTexts(context.getCommandSourceUnchecked())).isEmpty()) {
            textMessages.add(Util.SPACE);
            textMessages.add(Text.joinWith((Text)Text.of((String)" "), (Text[])new Text[]{context.getMessage("command.usage.subcommand", new Object[0]), subcommands}));
        }
        return textMessages;
    }
}

