/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.scaffold.command.modifier.impl;

import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.config.CommandModifiersConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.control.CommandControl;
import io.github.nucleuspowered.nucleus.scaffold.command.modifier.ICommandModifier;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IEconomyServiceProvider;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;

public class CostModifier
implements ICommandModifier {
    private static final String COST = "cost";

    public String getId() {
        return "nucleus:has_cost";
    }

    public String getName() {
        return "Cost Modifier";
    }

    @Override
    public void getDefaultNode(ConfigurationNode node, IMessageProviderService messageProviderService) {
        ConfigurationNode n = node.getNode(new Object[]{COST});
        if (n instanceof CommentedConfigurationNode) {
            ((CommentedConfigurationNode)n).setComment(messageProviderService.getMessageString("config.cost", new Object[0]));
        }
        n.setValue((Object)0.0);
    }

    @Override
    public void setDataFromNode(CommandModifiersConfig config, ConfigurationNode node) {
        config.setCost(node.getNode(new Object[]{COST}).getInt(0));
    }

    @Override
    public void setValueFromOther(CommandModifiersConfig from, CommandModifiersConfig to) {
        to.setCost(from.getCost());
    }

    @Override
    public boolean canExecuteModifier(INucleusServiceCollection serviceCollection, CommandSource source) throws CommandException {
        return serviceCollection.economyServiceProvider().serviceExists() && source instanceof Player;
    }

    @Override
    public Optional<Text> testRequirement(ICommandContext.Mutable<? extends CommandSource> source, CommandControl control, INucleusServiceCollection serviceCollection, CommandModifier modifier) throws CommandException {
        if (source.getCost() > 0.0) {
            double cost = source.getCost();
            IEconomyServiceProvider ies = serviceCollection.economyServiceProvider();
            if (!ies.withdrawFromPlayer((Player)source.getCommandSource(), cost, false)) {
                return Optional.of(serviceCollection.messageProvider().getMessageFor((CommandSource)source.getCommandSource(), "cost.nofunds", ies.getCurrencySymbol(source.getCost())));
            }
            source.addFailAction(s -> {
                serviceCollection.economyServiceProvider();
                try {
                    ies.depositInPlayer((User)s.getIfPlayer(), source.getCost(), false);
                }
                catch (CommandException e) {
                    serviceCollection.logger().error("Could not return {} to {}.", (Object)cost, (Object)source.getName());
                }
            });
        }
        return Optional.empty();
    }

    @Override
    public void onFailure(ICommandContext<? extends CommandSource> source, CommandControl control, INucleusServiceCollection serviceCollection, CommandModifier modifier) throws CommandException {
        if (source.getCost() > 0.0) {
            IEconomyServiceProvider ies = serviceCollection.economyServiceProvider();
            ies.depositInPlayer((User)((Player)source.getCommandSource()), source.getCost(), false);
        }
    }
}

