/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.chatmessageformatter;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;
import org.spongepowered.api.text.chat.ChatType;

public abstract class AbstractNucleusChatChannel<T extends Collection<MessageReceiver>>
implements MessageChannel {
    private final MessageChannel messageChannel;
    final T messageReceiverList;

    public AbstractNucleusChatChannel(MessageChannel messageChannel, T receivers) {
        this.messageChannel = messageChannel;
        this.messageReceiverList = receivers;
    }

    public void send(@Nullable Object sender, Text original, ChatType type) {
        this.messageChannel.send(sender, original, type);
    }

    public Collection<MessageReceiver> getMembers() {
        Collection delegated = this.messageChannel.getMembers();
        return this.messageReceiverList.stream().filter(delegated::contains).collect(Collectors.toList());
    }

    MessageChannel getDelegated() {
        return this.messageChannel;
    }

    public static abstract class Mutable<M extends Mutable<M>>
    extends AbstractNucleusChatChannel<Set<MessageReceiver>>
    implements MutableMessageChannel {
        public Mutable(Immutable<?, M> immutable) {
            super(immutable.getDelegated(), new HashSet<MessageReceiver>(immutable.getMembers()));
        }

        public Mutable(MessageChannel messageChannel, Collection<MessageReceiver> messageReceivers) {
            super(messageChannel, new HashSet<MessageReceiver>(messageReceivers));
        }

        public boolean addMember(MessageReceiver member) {
            return ((Set)this.messageReceiverList).add(member);
        }

        public boolean removeMember(MessageReceiver member) {
            return ((Set)this.messageReceiverList).remove(member);
        }

        public void clearMembers() {
            ((Set)this.messageReceiverList).clear();
        }

        public Mutable<M> asMutable() {
            return this;
        }
    }

    public static abstract class Immutable<I extends Immutable<I, M>, M extends Mutable>
    extends AbstractNucleusChatChannel<ImmutableList<MessageReceiver>> {
        private final Function<Immutable<I, M>, M> mutableFactory;

        public Immutable(MessageChannel messageChannel, Collection<MessageReceiver> messageReceivers, Function<Immutable<I, M>, M> mutableFactory) {
            super(messageChannel, ImmutableList.copyOf(messageReceivers));
            this.mutableFactory = mutableFactory;
        }

        public M asMutable() {
            return (M)((Mutable)this.mutableFactory.apply(this));
        }
    }
}

