/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.chatmessageformatter;

import com.google.common.base.Preconditions;
import io.github.nucleuspowered.nucleus.api.util.NoExceptionAutoClosable;
import io.github.nucleuspowered.nucleus.services.interfaces.IChatMessageFormatterService;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.inject.Singleton;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;

@Singleton
public class ChatMessageFormatterService
implements IChatMessageFormatterService {
    private final Map<UUID, IChatMessageFormatterService.Channel> chatChannels = new HashMap<UUID, IChatMessageFormatterService.Channel>();
    private final Map<CommandSource, IChatMessageFormatterService.Channel> sourceChannelMap = new WeakHashMap<CommandSource, IChatMessageFormatterService.Channel>();

    @Override
    public Optional<IChatMessageFormatterService.Channel> getNucleusChannel(CommandSource source) {
        if (source instanceof User) {
            return this.getNucleusChannel(((User)source).getUniqueId());
        }
        return Optional.ofNullable(this.sourceChannelMap.get(source));
    }

    @Override
    public Optional<IChatMessageFormatterService.Channel> getNucleusChannel(UUID uuid) {
        return Optional.ofNullable(this.chatChannels.get(uuid));
    }

    @Override
    public void setPlayerNucleusChannel(UUID uuid, @Nullable IChatMessageFormatterService.Channel channel) {
        if (channel == null) {
            this.chatChannels.remove(uuid);
        } else {
            this.chatChannels.put(uuid, channel);
        }
    }

    @Override
    public NoExceptionAutoClosable setCommandSourceNucleusChannelTemporarily(CommandSource source, IChatMessageFormatterService.Channel channel) {
        if (source instanceof User) {
            return this.setPlayerNucleusChannelTemporarily(((User)source).getUniqueId(), channel);
        }
        Preconditions.checkNotNull((Object)channel);
        this.sourceChannelMap.put(source, channel);
        MessageChannel originalChannel = source.getMessageChannel();
        if (channel instanceof IChatMessageFormatterService.Channel.External) {
            Object newChannel = ((IChatMessageFormatterService.Channel.External)channel).createChannel(originalChannel);
            source.setMessageChannel(newChannel);
        }
        return () -> {
            this.sourceChannelMap.remove(source);
            Sponge.getServer().getConsole().setMessageChannel(originalChannel);
        };
    }

    @Override
    public NoExceptionAutoClosable setPlayerNucleusChannelTemporarily(UUID uuid, IChatMessageFormatterService.Channel channel) {
        Preconditions.checkNotNull((Object)channel);
        IChatMessageFormatterService.Channel original = this.chatChannels.get(uuid);
        Optional player = Sponge.getServer().getPlayer(uuid);
        MessageChannel originalChannel = player.map(MessageReceiver::getMessageChannel).orElse(null);
        this.chatChannels.put(uuid, channel);
        if (channel instanceof IChatMessageFormatterService.Channel.External) {
            Object newChannel = ((IChatMessageFormatterService.Channel.External)channel).createChannel(originalChannel);
            player.ifPresent(x -> x.setMessageChannel(newChannel));
        }
        return () -> {
            this.setPlayerNucleusChannel(uuid, original);
            if (originalChannel != null) {
                player.ifPresent(x -> x.setMessageChannel(originalChannel));
            } else {
                player.ifPresent(x -> x.setMessageChannel(MessageChannel.TO_ALL));
            }
        };
    }
}

