/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.commandmetadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.nucleus.guice.ConfigDirectory;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandInterceptor;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.scaffold.command.control.CommandControl;
import io.github.nucleuspowered.nucleus.scaffold.command.control.CommandMetadata;
import io.github.nucleuspowered.nucleus.scaffold.command.modifier.ICommandModifier;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.ICommandMetadataService;
import io.github.nucleuspowered.nucleus.services.interfaces.IConfigurateHelper;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.util.Action;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandMapping;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.plugin.PluginContainer;

@Singleton
public class CommandMetadataService
implements ICommandMetadataService,
IReloadableService.Reloadable {
    private static final String ROOT_ALIASES = "root level aliases";
    private static final String ENABLED = "enabled";
    private static final TypeToken<Map<String, Boolean>> MAP_TYPE_TOKEN = new TypeToken<Map<String, Boolean>>(){};
    private final Map<String, String> commandremap = new HashMap<String, String>();
    private final Path commandsFile;
    private final PluginContainer pluginContainer;
    private final IConfigurateHelper configurateHelper;
    private final IMessageProviderService messageProviderService;
    private final Map<String, CommandMetadata> commandMetadataMap = new HashMap<String, CommandMetadata>();
    private final Map<CommandControl, List<String>> controlToAliases = new HashMap<CommandControl, List<String>>();
    private final BiMap<Class<? extends ICommandExecutor>, CommandControl> controlToExecutorClass = HashBiMap.create();
    private CommentedConfigurationNode commandsConfConfigNode;
    private boolean registrationComplete = false;
    private List<ICommandInterceptor> interceptors = new ArrayList<ICommandInterceptor>();
    private List<String> registeredAliases = new ArrayList<String>();

    @Inject
    public CommandMetadataService(@ConfigDirectory Path configDirectory, IReloadableService reloadableService, IMessageProviderService messageProviderService, IConfigurateHelper helper, PluginContainer pluginContainer) {
        reloadableService.registerReloadable(this);
        this.configurateHelper = helper;
        this.messageProviderService = messageProviderService;
        this.commandsFile = configDirectory.resolve("commands.conf");
        this.pluginContainer = pluginContainer;
    }

    private String getKey(Command command) {
        return this.getKey(new LinkedHashSet<Class<? extends ICommandExecutor>>(), new StringBuilder(), command).toString().toLowerCase();
    }

    private StringBuilder getKey(LinkedHashSet<Class<? extends ICommandExecutor>> traversed, StringBuilder stringBuilder, Command command) {
        if (command.parentCommand() != ICommandExecutor.class) {
            if (!traversed.add(command.parentCommand())) {
                ArrayList<String> elements = new ArrayList<String>();
                for (Class clazz : traversed) {
                    elements.add(clazz.getName());
                }
                throw new IllegalStateException("Circularity detected: " + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), elements));
            }
            this.getKey(traversed, stringBuilder, command.parentCommand().getAnnotation(Command.class)).append(".");
        }
        return stringBuilder.append(command.aliases()[0]);
    }

    @Override
    public void registerCommand(String id, String name, Command command, Class<? extends ICommandExecutor<?>> associatedContext) {
        Preconditions.checkState((!this.registrationComplete ? 1 : 0) != 0, (Object)"Registration has completed.");
        String key = this.getKey(command);
        this.commandMetadataMap.put(key, new CommandMetadata(id, name, command, associatedContext, key, associatedContext.getAnnotation(EssentialsEquivalent.class)));
    }

    @Override
    public void completeRegistrationPhase(INucleusServiceCollection serviceCollection) {
        Preconditions.checkState((!this.registrationComplete ? 1 : 0) != 0, (Object)"Registration has completed.");
        this.registrationComplete = true;
        this.load();
        Map<Class, String> metadataStringMap = this.commandMetadataMap.entrySet().stream().collect(Collectors.toMap(entry -> ((CommandMetadata)entry.getValue()).getExecutor(), Map.Entry::getKey));
        HashMap<CommandMetadata, CommandControl> commands = new HashMap<CommandMetadata, CommandControl>();
        HashMap<Class<? extends ICommandExecutor>, Map<String, CommandMetadata>> toRegister = new HashMap<Class<? extends ICommandExecutor>, Map<String, CommandMetadata>>();
        toRegister.put(ICommandExecutor.class, new HashMap());
        this.mergeAliases();
        for (CommandMetadata metadata : this.commandMetadataMap.values()) {
            CommentedConfigurationNode commandNode = this.commandsConfConfigNode.getNode(new Object[]{metadata.getCommandKey()});
            if (!commandNode.getNode(new Object[]{ENABLED}).getBoolean(false)) continue;
            try {
                Map m = (Map)commandNode.getNode(new Object[]{ROOT_ALIASES}).getValue(MAP_TYPE_TOKEN);
                if (m != null) {
                    m.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).forEach(x -> toRegister.computeIfAbsent(metadata.getCommandAnnotation().parentCommand(), y -> new HashMap()).put(x, metadata));
                }
            }
            catch (ObjectMappingException e) {
                e.printStackTrace();
            }
            if (metadata.isRoot()) continue;
            String prefix = metadataStringMap.get(metadata.getCommandAnnotation().parentCommand()).replace(".", " ");
            for (String x2 : metadata.getAtLevelAliases()) {
                toRegister.computeIfAbsent(metadata.getCommandAnnotation().parentCommand(), y -> new HashMap()).put(prefix + " " + x2, metadata);
            }
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (Map.Entry<String, String> entry2 : this.commandremap.entrySet()) {
            CommentedConfigurationNode node = this.commandsConfConfigNode.getNode(new Object[]{entry2.getKey()}).getNode(new Object[]{ENABLED});
            if (node.isVirtual()) {
                node.setValue((Object)true).setComment(serviceCollection.messageProvider().getMessageString("config.enabled", new Object[0]));
                continue;
            }
            if (node.getBoolean(true)) continue;
            toRemove.add(entry2.getKey());
        }
        toRemove.forEach(this.commandremap::remove);
        this.register(toRegister, commands, ICommandExecutor.class, null, serviceCollection);
        this.mergeModifierDefaults();
        this.save();
        this.setupData();
    }

    private <T extends ICommandExecutor> void register(Map<Class<? extends ICommandExecutor>, Map<String, CommandMetadata>> toStart, Map<CommandMetadata, CommandControl> commands, Class<T> keyToCheck, @Nullable CommandControl parentControl, INucleusServiceCollection collection) {
        for (Map.Entry<String, CommandMetadata> entry : toStart.get(keyToCheck).entrySet()) {
            CommandControl control = commands.computeIfAbsent(entry.getValue(), mm -> this.construct(parentControl, (CommandMetadata)mm, collection));
            this.controlToExecutorClass.putIfAbsent(entry.getValue().getExecutor(), (Object)control);
            Class<? extends ICommandExecutor<?>> currentKey = entry.getValue().getExecutor();
            boolean hasKey = toStart.containsKey(currentKey);
            if (hasKey) {
                this.register(toStart, commands, entry.getValue().getExecutor(), control, collection);
            }
            if (parentControl == null || !entry.getKey().contains(" ")) {
                this.controlToAliases.computeIfAbsent(control, c -> new ArrayList()).add(entry.getKey());
                continue;
            }
            String key = entry.getKey().substring(entry.getKey().lastIndexOf(" ") + 1);
            parentControl.attach(key, control);
        }
        if (parentControl == null) {
            for (Map.Entry<Object, Object> entry : this.controlToAliases.entrySet()) {
                for (String alias : new HashSet((Collection)entry.getValue())) {
                    try {
                        Sponge.getCommandManager().register((Object)collection.pluginContainer(), (CommandCallable)entry.getKey(), new String[]{alias}).ifPresent(x -> this.registeredAliases.addAll(x.getAllAliases()));
                    }
                    catch (IllegalArgumentException ex) {
                        collection.logger().error("Could not register command {}, alias already in use by another Nucleus command.", (Object)alias);
                    }
                }
            }
            commands.values().forEach(x -> x.completeRegistration(collection));
        }
    }

    private void mergeAliases() {
        CommentedConfigurationNode toMerge = this.configurateHelper.createNode();
        this.commandMetadataMap.values().forEach(metadata -> {
            CommentedConfigurationNode node = toMerge.getNode(new Object[]{metadata.getCommandKey()});
            String messageKey = metadata.getCommandAnnotation().commandDescriptionKey() + ".desc";
            if (this.messageProviderService.hasKey(messageKey)) {
                node.setComment(this.messageProviderService.getMessageString(messageKey, new Object[0]));
            }
            node.getNode(new Object[]{ENABLED}).setComment(this.messageProviderService.getMessageString("config.enabled", new Object[0])).setValue((Object)true);
            CommentedConfigurationNode al = node.getNode(new Object[]{ROOT_ALIASES});
            for (String a : metadata.getRootAliases()) {
                al.getNode(new Object[]{a}).setValue((Object)(!metadata.getDisabledByDefaultRootAliases().contains(a) ? 1 : 0));
            }
            if (!al.isVirtual()) {
                al.setComment(this.messageProviderService.getMessageString("config.rootaliases", new Object[0]));
            }
        });
        this.commandsConfConfigNode.mergeValuesFrom((ConfigurationNode)toMerge);
    }

    private void mergeModifierDefaults() {
        CommentedConfigurationNode toMerge = this.configurateHelper.createNode();
        this.controlToAliases.keySet().forEach(control -> {
            CommentedConfigurationNode node = toMerge.getNode(new Object[]{control.getCommandKey()});
            if (!control.isModifierKeyRedirected()) {
                for (Map.Entry<CommandModifier, ICommandModifier> modifier : control.getCommandModifiers().entrySet()) {
                    if (modifier.getKey().useFrom() != ICommandExecutor.class) continue;
                    modifier.getValue().getDefaultNode((ConfigurationNode)node, this.messageProviderService);
                }
            }
        });
        this.commandsConfConfigNode.mergeValuesFrom((ConfigurationNode)toMerge);
    }

    private void setupData() {
        ArrayList postponeAction = new ArrayList();
        this.controlToAliases.keySet().forEach(control -> {
            CommentedConfigurationNode node = control.isModifierKeyRedirected() ? this.commandsConfConfigNode.getNode(new Object[]{control.getMetadata().getCommandAnnotation().modifierOverride()}) : this.commandsConfConfigNode.getNode(new Object[]{control.getCommandKey()});
            for (Map.Entry<CommandModifier, ICommandModifier> modifier : control.getCommandModifiers().entrySet()) {
                if (modifier.getKey().useFrom() != ICommandExecutor.class) {
                    CommandControl useFromControl = (CommandControl)this.controlToExecutorClass.get(modifier.getKey().useFrom());
                    postponeAction.add(() -> ((ICommandModifier)modifier.getValue()).setValueFromOther(useFromControl.getCommandModifiersConfig(), control.getCommandModifiersConfig()));
                }
                modifier.getValue().setDataFromNode(control.getCommandModifiersConfig(), (ConfigurationNode)node);
            }
        });
        postponeAction.forEach(Action::action);
    }

    private CommandControl construct(@Nullable CommandControl parent, CommandMetadata metadata, INucleusServiceCollection serviceCollection) {
        ICommandExecutor executor = (ICommandExecutor)serviceCollection.injector().getInstance(metadata.getExecutor());
        return new CommandControl(executor, parent, metadata, serviceCollection);
    }

    @Override
    public void addMapping(String newCommand, String remapped) {
        if (this.commandremap.containsKey(newCommand.toLowerCase())) {
            throw new IllegalArgumentException("command already in use");
        }
        this.commandremap.put(newCommand.toLowerCase(), remapped);
    }

    @Override
    public void activate() {
        for (Map.Entry<String, String> entry : this.commandremap.entrySet()) {
            if (Sponge.getCommandManager().get(entry.getKey()).isPresent()) continue;
            Sponge.getCommandManager().get(entry.getValue()).ifPresent(x -> Sponge.getCommandManager().register((Object)this.pluginContainer, x.getCallable(), new String[]{(String)entry.getKey()}));
        }
    }

    @Override
    public void deactivate() {
        for (Map.Entry<String, String> entry : this.commandremap.entrySet()) {
            Optional mappingOptional = Sponge.getCommandManager().get(entry.getKey());
            if (!mappingOptional.isPresent() || !Sponge.getCommandManager().getOwner((CommandMapping)mappingOptional.get()).map(x -> x.getId().equals("nucleus")).orElse(false).booleanValue()) continue;
            Sponge.getCommandManager().removeMapping((CommandMapping)mappingOptional.get());
        }
    }

    @Override
    public boolean isNucleusCommand(String command) {
        return this.registrationComplete && this.registeredAliases.contains(command.toLowerCase());
    }

    @Override
    public Optional<CommandControl> getControl(Class<? extends ICommandExecutor<? extends CommandSource>> executorClass) {
        return Optional.ofNullable(this.controlToExecutorClass.get(executorClass));
    }

    @Override
    public Collection<CommandControl> getCommands() {
        return this.controlToAliases.keySet();
    }

    @Override
    public Collection<CommandControl> getCommandsAndSubcommands() {
        return this.controlToExecutorClass.values();
    }

    @Override
    public void registerInterceptor(ICommandInterceptor impl) {
        this.interceptors.add(impl);
    }

    @Override
    public Collection<ICommandInterceptor> interceptors() {
        return ImmutableList.copyOf(this.interceptors);
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.load();
        this.setupData();
    }

    private void load() {
        try {
            this.commandsConfConfigNode = (CommentedConfigurationNode)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.commandsFile)).build().load();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void save() {
        try {
            ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.commandsFile)).build().save((ConfigurationNode)this.commandsConfConfigNode);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

