/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.storage.persistence;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.nucleuspowered.nucleus.util.ThrownFunction;
import io.github.nucleuspowered.storage.exceptions.DataDeleteException;
import io.github.nucleuspowered.storage.exceptions.DataLoadException;
import io.github.nucleuspowered.storage.exceptions.DataQueryException;
import io.github.nucleuspowered.storage.exceptions.DataSaveException;
import io.github.nucleuspowered.storage.persistence.IStorageRepository;
import io.github.nucleuspowered.storage.queryobjects.IQueryObject;
import io.github.nucleuspowered.storage.util.KeyedObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;

abstract class FlatFileStorageRepository
implements IStorageRepository {
    private final Logger logger;
    private static Gson gson = new GsonBuilder().setPrettyPrinting().create();

    protected FlatFileStorageRepository(Logger logger) {
        this.logger = logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Optional<JsonObject> get(@Nullable Path path) throws DataLoadException {
        if (path == null) return Optional.empty();
        try {
            if (Files.size(path) == 0L) {
                return Optional.empty();
            }
            try (BufferedReader reader = Files.newBufferedReader(path);){
                Optional<JsonObject> optional = Optional.of(new JsonParser().parse(reader.lines().collect(Collectors.joining())).getAsJsonObject());
                return optional;
            }
        }
        catch (Exception e) {
            throw new DataLoadException("Could not load file at " + path.toAbsolutePath().toString(), e);
        }
    }

    synchronized void save(Path file, JsonObject object) throws DataSaveException {
        try {
            if (Files.exists(file, new LinkOption[0])) {
                Files.copy(file, file.resolveSibling(file.getFileName() + ".bak"), StandardCopyOption.REPLACE_EXISTING);
            }
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(file, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                writer.write(gson.toJson((JsonElement)object));
            }
        }
        catch (Exception ex) {
            this.logger.error("Could not save " + file.toString());
            ex.printStackTrace();
            throw new DataSaveException("Could not save " + file.toString(), ex);
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void clearCache() {
    }

    @Override
    public boolean hasCache() {
        return false;
    }

    static class UUIDKeyed<Q extends IQueryObject<UUID, Q>>
    extends FlatFileStorageRepository
    implements IStorageRepository.Keyed<UUID, Q, JsonObject> {
        private final ThrownFunction<Q, Path, DataQueryException> FILENAME_RESOLVER;
        private final Supplier<Path> BASE_PATH;
        private final Function<UUID, Path> UUID_FILENAME_RESOLVER;

        UUIDKeyed(Logger logger, ThrownFunction<Q, Path, DataQueryException> filename_resolver, Function<UUID, Path> uuid_filename_resolver, Supplier<Path> basePath) {
            super(logger);
            this.FILENAME_RESOLVER = filename_resolver;
            this.UUID_FILENAME_RESOLVER = uuid_filename_resolver;
            this.BASE_PATH = basePath;
        }

        @Override
        public void clearCache(Iterable<UUID> keys) {
        }

        @Override
        public boolean exists(Q query) {
            try {
                return this.existsInternal(query) != null;
            }
            catch (DataQueryException e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public Optional<KeyedObject<UUID, JsonObject>> get(Q query) throws DataLoadException {
            Path path;
            try {
                path = this.existsInternal(query);
            }
            catch (Exception e) {
                throw new DataLoadException("Query not valid", e);
            }
            return this.get((Q)path).map(x -> new KeyedObject(query.keys().iterator().next(), (JsonObject)x));
        }

        @Override
        public boolean exists(UUID uuid) {
            return this.existsInternal(uuid) != null;
        }

        @Override
        public Optional<JsonObject> get(UUID uuid) throws DataLoadException {
            return this.get((Q)this.existsInternal(uuid));
        }

        @Override
        public Collection<UUID> getAllKeys() throws DataLoadException {
            return ImmutableSet.copyOf(this.getAllKeysInternal());
        }

        @Override
        public Map<UUID, JsonObject> getAll(Q query) throws DataLoadException, DataQueryException {
            ImmutableMap.Builder j = ImmutableMap.builder();
            for (UUID key : this.getAllKeys(query)) {
                j.put((Object)key, (Object)this.get(key).get());
            }
            return j.build();
        }

        @Override
        public Collection<UUID> getAllKeys(Q query) throws DataLoadException, DataQueryException {
            if (query.restrictedToKeys()) {
                this.getAllKeysInternal().retainAll(query.keys());
            }
            throw new DataQueryException("There must only a key", (IQueryObject)query);
        }

        private Set<UUID> getAllKeysInternal() throws DataLoadException {
            UUIDFileWalker u = new UUIDFileWalker();
            try {
                Files.walkFileTree(this.BASE_PATH.get(), u);
                return u.uuidSet;
            }
            catch (IOException e) {
                throw new DataLoadException("Could not walk the file tree", e);
            }
        }

        @Nullable
        private Path existsInternal(UUID uuid) {
            Path path = this.UUID_FILENAME_RESOLVER.apply(uuid);
            if (Files.exists(this.UUID_FILENAME_RESOLVER.apply(uuid), new LinkOption[0])) {
                return path;
            }
            return null;
        }

        @Override
        public int count(Q query) {
            return this.exists(query) ? 1 : 0;
        }

        @Override
        public void save(UUID key, JsonObject object) throws DataSaveException {
            Path file = this.UUID_FILENAME_RESOLVER.apply(key);
            this.save(file, object);
        }

        @Override
        public void delete(UUID key) throws DataDeleteException {
            Path filename = this.UUID_FILENAME_RESOLVER.apply(key);
            try {
                Files.delete(filename);
            }
            catch (IOException e) {
                throw new DataDeleteException("Could not delete " + filename, e);
            }
        }

        @Nullable
        private Path existsInternal(Q query) throws DataQueryException {
            Path path = this.FILENAME_RESOLVER.apply(query);
            if (Files.exists(this.FILENAME_RESOLVER.apply(query), new LinkOption[0])) {
                return path;
            }
            return null;
        }

        private static class UUIDFileWalker
        extends SimpleFileVisitor<Path> {
            private final Set<UUID> uuidSet = new HashSet<UUID>();

            private UUIDFileWalker() {
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.getFileName().toString().length() == 2) {
                    return super.preVisitDirectory(dir, attrs);
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
                String f;
                if (attr.isRegularFile() && file.endsWith(".json") && (f = file.getFileName().toString()).length() == 41 && f.startsWith(file.getParent().toString().toLowerCase())) {
                    try {
                        this.uuidSet.add(UUID.fromString(f.substring(0, 36)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        }
    }

    static class Single
    extends FlatFileStorageRepository
    implements IStorageRepository.Single<JsonObject> {
        private final Supplier<Path> FILENAME_RESOLVER;

        Single(Logger logger, Supplier<Path> filename_resolver) {
            super(logger);
            this.FILENAME_RESOLVER = filename_resolver;
        }

        @Override
        public Optional<JsonObject> get() throws DataLoadException {
            if (Files.exists(this.FILENAME_RESOLVER.get(), new LinkOption[0])) {
                return this.get(this.FILENAME_RESOLVER.get());
            }
            return Optional.empty();
        }

        @Override
        public void save(JsonObject object) throws DataSaveException {
            this.save(this.FILENAME_RESOLVER.get(), object);
        }
    }
}

