/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.usercache;

import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.nucleus.configurate.datatypes.UserCacheDataNode;
import io.github.nucleuspowered.nucleus.configurate.datatypes.UserCacheVersionNode;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IUserDataObject;
import io.github.nucleuspowered.nucleus.services.impl.storage.queryobjects.IUserQueryObject;
import io.github.nucleuspowered.nucleus.services.impl.storage.queryobjects.UserQueryObject;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.services.interfaces.IStorageManager;
import io.github.nucleuspowered.nucleus.services.interfaces.IUserCacheService;
import io.github.nucleuspowered.storage.services.IStorageService;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.gson.GsonConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.util.Identifiable;

@Singleton
public class UserCacheService
implements IUserCacheService,
IReloadableService.DataLocationReloadable {
    private static final int expectedVersion = new UserCacheVersionNode().getVersion();
    private boolean isWalking = false;
    private final Supplier<Path> dataDirectory;
    private final Object lockingObject = new Object();
    private final IStorageManager storageManager;
    private UserCacheVersionNode data;

    @Inject
    public UserCacheService(INucleusServiceCollection serviceCollection) {
        this.dataDirectory = serviceCollection.dataDir();
        this.storageManager = serviceCollection.storageManager();
        serviceCollection.reloadableService().registerDataFileReloadable(this);
        this.load();
    }

    @Override
    public void load() {
        try {
            this.data = (UserCacheVersionNode)this.configurationLoader().load().getValue(TypeToken.of(UserCacheVersionNode.class), UserCacheVersionNode::new);
        }
        catch (IOException | ObjectMappingException e) {
            e.printStackTrace();
            this.data = new UserCacheVersionNode();
        }
    }

    @Override
    public void save() {
        try {
            GsonConfigurationLoader gsonConfigurationLoader = this.configurationLoader();
            ConfigurationNode node = gsonConfigurationLoader.createEmptyNode();
            node.setValue(TypeToken.of(UserCacheVersionNode.class), (Object)this.data);
            gsonConfigurationLoader.save(node);
        }
        catch (IOException | ObjectMappingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<UUID> getForIp(String ip) {
        this.updateCacheForOnlinePlayers();
        String ipToCheck = ip.replace("/", "");
        return this.data.getNode().entrySet().stream().filter(x -> ((UserCacheDataNode)x.getValue()).getIpAddress().map(y -> y.equals(ipToCheck)).orElse(false)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    public List<UUID> getJailed() {
        this.updateCacheForOnlinePlayers();
        return this.data.getNode().entrySet().stream().filter(x -> ((UserCacheDataNode)x.getValue()).isJailed()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    public List<UUID> getJailedIn(String name) {
        this.updateCacheForOnlinePlayers();
        return this.data.getNode().entrySet().stream().filter(x -> ((UserCacheDataNode)x.getValue()).getJailName().map(y -> y.equalsIgnoreCase(name)).orElse(false)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    public List<UUID> getMuted() {
        this.updateCacheForOnlinePlayers();
        return this.data.getNode().entrySet().stream().filter(x -> ((UserCacheDataNode)x.getValue()).isMuted()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    public void updateCacheForOnlinePlayers() {
        UserQueryObject iuq = new UserQueryObject();
        iuq.addAllKeys(Sponge.getServer().getOnlinePlayers().stream().map(Identifiable::getUniqueId).collect(Collectors.toList()));
        this.storageManager.getUserService().getAll(iuq).thenAccept(result -> result.forEach((uuid, obj) -> this.data.getNode().computeIfAbsent((UUID)uuid, x -> new UserCacheDataNode()).set((IUserDataObject)obj)));
    }

    @Override
    public void updateCacheForPlayer(UUID uuid, IUserDataObject u) {
        this.data.getNode().computeIfAbsent(uuid, x -> new UserCacheDataNode()).set(u);
    }

    @Override
    public void updateCacheForPlayer(UUID uuid) {
        this.storageManager.getUser(uuid).thenAccept(x -> x.ifPresent(u -> this.updateCacheForPlayer(uuid, (IUserDataObject)u)));
    }

    @Override
    public void startFilewalkIfNeeded() {
        if (!(this.isWalking || this.isCorrectVersion() && !this.data.getNode().isEmpty())) {
            this.fileWalk();
        }
    }

    @Override
    public boolean isCorrectVersion() {
        return expectedVersion == this.data.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fileWalk() {
        Object object = this.lockingObject;
        synchronized (object) {
            if (this.isWalking) {
                return false;
            }
            this.isWalking = true;
        }
        try {
            HashMap data = Maps.newHashMap();
            List knownUsers = ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).getAll().stream().map(Identifiable::getUniqueId).collect(Collectors.toList());
            int count = 0;
            IStorageService.Keyed.KeyedData<UUID, IUserQueryObject, IUserDataObject> manager = this.storageManager.getUserService();
            for (UUID user : knownUsers) {
                if (!manager.exists((IUserQueryObject)((Object)user)).join().booleanValue()) continue;
                manager.get((IUserQueryObject)((Object)user)).join().ifPresent(x -> data.put(user, new UserCacheDataNode((IUserDataObject)x)));
                if (++count < 10) continue;
                manager.clearCache();
                count = 0;
            }
            this.data = new UserCacheVersionNode();
            this.data.getNode().putAll(data);
            this.save();
        }
        finally {
            this.isWalking = false;
        }
        return true;
    }

    private GsonConfigurationLoader configurationLoader() {
        return ((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().setPath(this.dataDirectory.get().resolve("usercache.json"))).build();
    }

    @Override
    public void onDataFileLocationChange(INucleusServiceCollection serviceCollection) {
        this.load();
    }
}

