/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.storage.persistence;

import io.github.nucleuspowered.storage.exceptions.DataDeleteException;
import io.github.nucleuspowered.storage.exceptions.DataLoadException;
import io.github.nucleuspowered.storage.exceptions.DataQueryException;
import io.github.nucleuspowered.storage.exceptions.DataSaveException;
import io.github.nucleuspowered.storage.queryobjects.IQueryObject;
import io.github.nucleuspowered.storage.util.KeyedObject;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;

public interface IStorageRepository {
    public void shutdown();

    public void clearCache();

    public boolean hasCache();

    public static interface Keyed<K, Q extends IQueryObject<K, Q>, O>
    extends IStorageRepository {
        public void clearCache(Iterable<K> var1);

        default public boolean supportsNonKeyQueries() {
            return false;
        }

        public boolean exists(Q var1);

        public Optional<KeyedObject<K, O>> get(Q var1) throws DataLoadException, DataQueryException;

        public int count(Q var1);

        public void save(K var1, O var2) throws ObjectMappingException, DataSaveException;

        public void delete(K var1) throws DataDeleteException;

        public boolean exists(K var1);

        public Optional<O> get(K var1) throws DataLoadException, DataQueryException;

        public Collection<K> getAllKeys() throws DataLoadException;

        public Map<K, O> getAll(Q var1) throws DataLoadException, DataQueryException;

        public Collection<K> getAllKeys(Q var1) throws DataLoadException, DataQueryException;
    }

    public static interface Single<O>
    extends IStorageRepository {
        public Optional<O> get() throws DataLoadException, DataQueryException;

        public void save(O var1) throws ObjectMappingException, DataSaveException;
    }
}

