/*
 * Decompiled with CFR 0.152.
 */
package reborncore.api.praescriptum.ingredients.input;

import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.api.praescriptum.ingredients.input.InputIngredient;

public class OreDictionaryInputIngredient
extends InputIngredient<String> {
    public final int amount;
    public final Integer meta;
    private List<ItemStack> equivalents;

    public static OreDictionaryInputIngredient of(String ingredient) {
        return OreDictionaryInputIngredient.of(ingredient, 1);
    }

    public static OreDictionaryInputIngredient of(String ingredient, int amount) {
        return OreDictionaryInputIngredient.of(ingredient, amount, null);
    }

    public static OreDictionaryInputIngredient of(String ingredient, int amount, Integer meta) {
        return new OreDictionaryInputIngredient(ingredient, amount, meta);
    }

    protected OreDictionaryInputIngredient(String ingredient) {
        this(ingredient, 1);
    }

    protected OreDictionaryInputIngredient(String ingredient, int amount) {
        this(ingredient, amount, null);
    }

    protected OreDictionaryInputIngredient(String ingredient, int amount, Integer meta) {
        super(ingredient);
        this.amount = amount;
        this.meta = meta;
    }

    @Override
    public Object getUnspecific() {
        throw new UnsupportedOperationException("Operation not supported for this ingredient.");
    }

    @Override
    public InputIngredient<String> copy() {
        throw new UnsupportedOperationException("Operation not supported for this ingredient.");
    }

    @Override
    public boolean isEmpty() {
        return this.amount <= 0;
    }

    @Override
    public int getCount() {
        return this.amount;
    }

    @Override
    public void shrink(int amount) {
        throw new UnsupportedOperationException("Operation not supported for this ingredient.");
    }

    @Override
    public boolean matches(Object other) {
        if (!(other instanceof ItemStack)) {
            return false;
        }
        List<ItemStack> inputs = this.getEquivalents();
        boolean useOreStackMeta = this.meta == null;
        Item subjectItem = ((ItemStack)other).func_77973_b();
        int subjectMeta = ((ItemStack)other).func_77952_i();
        return inputs.stream().anyMatch(entry -> {
            Item oreItem = entry.func_77973_b();
            int metaRequired = useOreStackMeta ? entry.func_77952_i() : this.meta.intValue();
            return subjectItem == oreItem && (subjectMeta == metaRequired || metaRequired == Short.MAX_VALUE);
        });
    }

    @Override
    public boolean matchesStrict(Object other) {
        return other instanceof String && ((String)this.ingredient).equals(other);
    }

    @Override
    public String toFormattedString() {
        return (String)this.ingredient;
    }

    private List<ItemStack> getEquivalents() {
        if (this.equivalents != null) {
            return this.equivalents;
        }
        NonNullList ret = OreDictionary.getOres((String)((String)this.ingredient));
        if (ret != OreDictionary.EMPTY_LIST) {
            this.equivalents = ret;
        }
        return ret;
    }
}

