/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.tile.IUpgradeable;
import reborncore.common.recipes.RecipeCrafter;

public class InventoryHelper {
    public static void tryInsertStack(IInventory targetInventory, int slot, ItemStack stack, boolean canMerge) {
        if (targetInventory.func_94041_b(slot, stack)) {
            ItemStack targetStack = targetInventory.func_70301_a(slot);
            if (targetStack.func_190926_b()) {
                int space = targetInventory.func_70297_j_();
                int mergeAmount = Math.min(space, stack.func_190916_E());
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(mergeAmount);
                targetInventory.func_70299_a(slot, copy);
                stack.func_190918_g(mergeAmount);
            } else if (canMerge && targetInventory.func_94041_b(slot, stack) && InventoryHelper.areMergeCandidates(stack, targetStack)) {
                int space = Math.min(targetInventory.func_70297_j_(), targetStack.func_77976_d()) - targetStack.func_190916_E();
                int mergeAmount = Math.min(space, stack.func_190916_E());
                ItemStack copy = targetStack.func_77946_l();
                copy.func_190917_f(mergeAmount);
                targetInventory.func_70299_a(slot, copy);
                stack.func_190918_g(mergeAmount);
            }
        }
    }

    protected static boolean areMergeCandidates(ItemStack source, ItemStack target) {
        return source.func_77969_a(target) && ItemStack.func_77970_a((ItemStack)source, (ItemStack)target) && target.func_190916_E() < target.func_77976_d();
    }

    public static void insertItemIntoInventory(IInventory inventory, ItemStack stack) {
        InventoryHelper.insertItemIntoInventory(inventory, stack, null, -1);
    }

    public static void insertItemIntoInventory(IInventory inventory, ItemStack stack, EnumFacing side, int intoSlot) {
        InventoryHelper.insertItemIntoInventory(inventory, stack, side, intoSlot, true);
    }

    public static void insertItemIntoInventory(IInventory inventory, ItemStack stack, EnumFacing side, int intoSlot, boolean doMove) {
        InventoryHelper.insertItemIntoInventory(inventory, stack, side, intoSlot, doMove, true);
    }

    public static void insertItemIntoInventory(IInventory inventory, ItemStack stack, EnumFacing side, int intoSlot, boolean doMove, boolean canStack) {
        if (stack.func_190926_b()) {
            return;
        }
        IInventory targetInventory = inventory;
        if (!doMove) {
            targetInventory = new GenericInventory("temporary.inventory", false, targetInventory.func_70302_i_());
            ((GenericInventory)targetInventory).copyFrom(inventory);
        }
        int i = 0;
        int[] attemptSlots = new int[]{};
        if (inventory instanceof ISidedInventory && side != null) {
            attemptSlots = ((ISidedInventory)inventory).func_180463_a(side);
            if (attemptSlots == null) {
                attemptSlots = new int[]{};
            }
        } else {
            attemptSlots = new int[inventory.func_70302_i_()];
            for (int a = 0; a < inventory.func_70302_i_(); ++a) {
                attemptSlots[a] = a;
            }
        }
        if (intoSlot > -1) {
            HashSet<Integer> x = new HashSet<Integer>();
            for (int attemptedSlot : attemptSlots) {
                x.add(attemptedSlot);
            }
            attemptSlots = x.contains(intoSlot) ? new int[]{intoSlot} : new int[]{};
        }
        while (stack.func_190916_E() > 0 && i < attemptSlots.length) {
            if (side != null && inventory instanceof ISidedInventory && !((ISidedInventory)inventory).func_180462_a(attemptSlots[i], stack, side.func_176734_d())) {
                ++i;
                continue;
            }
            InventoryHelper.tryInsertStack(targetInventory, attemptSlots[i], stack, canStack);
            ++i;
        }
    }

    public static int testInventoryInsertion(IInventory inventory, ItemStack item, EnumFacing side) {
        if (item.func_190926_b() || item.func_190916_E() == 0) {
            return 0;
        }
        item = item.func_77946_l();
        if (inventory == null) {
            return 0;
        }
        inventory.func_70302_i_();
        int itemSizeCounter = item.func_190916_E();
        int[] availableSlots = new int[]{};
        if (inventory instanceof ISidedInventory && side != null) {
            availableSlots = ((ISidedInventory)inventory).func_180463_a(side);
        } else if (inventory instanceof IRecipeCrafterProvider) {
            RecipeCrafter recipeCrafter = ((IRecipeCrafterProvider)inventory).getRecipeCrafter();
            availableSlots = recipeCrafter.inputSlots;
        } else {
            availableSlots = InventoryHelper.buildSlotsForLinearInventory(inventory);
        }
        for (int i : availableSlots) {
            if (itemSizeCounter <= 0) break;
            if (!inventory.func_94041_b(i, item) || side != null && inventory instanceof ISidedInventory && !((ISidedInventory)inventory).func_180462_a(i, item, side.func_176734_d())) continue;
            ItemStack inventorySlot = inventory.func_70301_a(i);
            if (inventorySlot.func_190926_b()) {
                itemSizeCounter -= Math.min(Math.min(itemSizeCounter, inventory.func_70297_j_()), item.func_77976_d());
                continue;
            }
            if (!InventoryHelper.areMergeCandidates(item, inventorySlot)) continue;
            int space = Math.min(inventory.func_70297_j_(), inventorySlot.func_77976_d()) - inventorySlot.func_190916_E();
            itemSizeCounter -= Math.min(itemSizeCounter, space);
        }
        if (itemSizeCounter != item.func_190916_E()) {
            itemSizeCounter = Math.max(itemSizeCounter, 0);
            return item.func_190916_E() - itemSizeCounter;
        }
        return 0;
    }

    public static IInventory getInventory(World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)tileEntity;
            TileEntityChest adjacent = null;
            if (chest.field_145991_k != null) {
                adjacent = chest.field_145991_k;
            }
            if (chest.field_145990_j != null) {
                adjacent = chest.field_145990_j;
            }
            if (chest.field_145992_i != null) {
                adjacent = chest.field_145992_i;
            }
            if (chest.field_145988_l != null) {
                adjacent = chest.field_145988_l;
            }
            if (adjacent != null) {
                return new InventoryLargeChest("", (ILockableContainer)chest, (ILockableContainer)adjacent);
            }
            return chest;
        }
        return tileEntity instanceof IInventory ? (IInventory)tileEntity : null;
    }

    public static IInventory getInventory(World world, int x, int y, int z, EnumFacing direction) {
        if (direction != null) {
            x += direction.func_82601_c();
            y += direction.func_96559_d();
            z += direction.func_82599_e();
        }
        return InventoryHelper.getInventory(world, x, y, z);
    }

    public static IInventory getInventory(IInventory inventory) {
        if (inventory instanceof TileEntityChest) {
            TileEntity te = (TileEntity)inventory;
            return InventoryHelper.getInventory(te.func_145831_w(), te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p());
        }
        return inventory;
    }

    public static int[] buildSlotsForLinearInventory(IInventory inv) {
        int[] slots = new int[inv.func_70302_i_()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public static void dropInventoryItems(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return;
        }
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemStack = inventory.func_70301_a(i);
                if (itemStack.func_190926_b() || itemStack.func_190916_E() > 0 && itemStack.func_77973_b() instanceof ItemBlock && (((ItemBlock)itemStack.func_77973_b()).func_179223_d() instanceof BlockFluidBase || ((ItemBlock)itemStack.func_77973_b()).func_179223_d() instanceof BlockStaticLiquid || ((ItemBlock)itemStack.func_77973_b()).func_179223_d() instanceof BlockDynamicLiquid)) continue;
                net.minecraft.inventory.InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemStack);
            }
        }
        if (tileEntity instanceof IUpgradeable) {
            net.minecraft.inventory.InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IUpgradeable)tileEntity).getUpgradeInventory());
        }
    }

    public static class GenericInventory
    implements IInventory {
        protected String inventoryTitle;
        protected int slotsCount;
        protected ItemStack[] inventoryContents;
        protected boolean isInvNameLocalized;

        public GenericInventory(String name, boolean isInvNameLocalized, int size) {
            this.isInvNameLocalized = isInvNameLocalized;
            this.slotsCount = size;
            this.inventoryTitle = name;
            this.inventoryContents = new ItemStack[size];
        }

        public ItemStack func_70298_a(int par1, int par2) {
            if (!this.inventoryContents[par1].func_190926_b()) {
                if (this.inventoryContents[par1].func_190916_E() <= par2) {
                    ItemStack itemstack = this.inventoryContents[par1];
                    this.inventoryContents[par1] = ItemStack.field_190927_a;
                    return itemstack;
                }
                ItemStack itemstack = this.inventoryContents[par1].func_77979_a(par2);
                if (this.inventoryContents[par1].func_190916_E() == 0) {
                    this.inventoryContents[par1] = ItemStack.field_190927_a;
                }
                return itemstack;
            }
            return ItemStack.field_190927_a;
        }

        public int func_70297_j_() {
            return 64;
        }

        public int func_70302_i_() {
            return this.slotsCount;
        }

        public boolean func_191420_l() {
            for (ItemStack itemstack : this.inventoryContents) {
                if (itemstack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int i) {
            return this.inventoryContents[i];
        }

        public ItemStack getStackInSlot(Enum<?> i) {
            return this.func_70301_a(i.ordinal());
        }

        public ItemStack func_70304_b(int i) {
            if (i >= this.inventoryContents.length) {
                return ItemStack.field_190927_a;
            }
            if (!this.inventoryContents[i].func_190926_b()) {
                ItemStack itemstack = this.inventoryContents[i];
                this.inventoryContents[i] = ItemStack.field_190927_a;
                return itemstack;
            }
            return ItemStack.field_190927_a;
        }

        public boolean isItem(int slot, Item item) {
            return !this.inventoryContents[slot].func_190926_b() && this.inventoryContents[slot].func_77973_b() == item;
        }

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return true;
        }

        public int func_174887_a_(int id) {
            return 0;
        }

        public void func_174885_b(int id, int value) {
        }

        public int func_174890_g() {
            return 0;
        }

        public void func_174888_l() {
        }

        public boolean func_70300_a(EntityPlayer entityplayer) {
            return true;
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
        }

        public void clearAndSetSlotCount(int amount) {
            this.slotsCount = amount;
            this.inventoryContents = new ItemStack[amount];
        }

        public void readFromNBT(NBTTagCompound tag) {
            if (tag.func_74764_b("size")) {
                this.slotsCount = tag.func_74762_e("size");
            }
            NBTTagList nbttaglist = tag.func_150295_c("Items", 10);
            this.inventoryContents = new ItemStack[this.slotsCount];
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound stacktag = nbttaglist.func_150305_b(i);
                byte j = stacktag.func_74771_c("Slot");
                if (j < 0 || j >= this.inventoryContents.length) continue;
                this.inventoryContents[j] = new ItemStack(stacktag);
            }
        }

        public void func_70299_a(int i, ItemStack itemstack) {
            this.inventoryContents[i] = itemstack;
            if (!itemstack.func_190926_b() && itemstack.func_190916_E() > this.func_70297_j_()) {
                itemstack.func_190920_e(this.func_70297_j_());
            }
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("size", this.func_70302_i_());
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.inventoryContents.length; ++i) {
                if (this.inventoryContents[i].func_190926_b()) continue;
                NBTTagCompound stacktag = new NBTTagCompound();
                stacktag.func_74774_a("Slot", (byte)i);
                this.inventoryContents[i].func_77955_b(stacktag);
                nbttaglist.func_74742_a((NBTBase)stacktag);
            }
            tag.func_74782_a("Items", (NBTBase)nbttaglist);
        }

        public void copyFrom(IInventory inventory) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (i >= this.func_70302_i_()) continue;
                ItemStack stack = inventory.func_70301_a(i);
                if (!stack.func_190926_b()) {
                    this.func_70299_a(i, stack.func_77946_l());
                    continue;
                }
                this.func_70299_a(i, ItemStack.field_190927_a);
            }
        }

        public List<ItemStack> contents() {
            return Arrays.asList(this.inventoryContents);
        }

        public void func_70296_d() {
        }

        public String func_70005_c_() {
            return null;
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return null;
        }
    }
}

