/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.items;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import trinsdar.ic2c_extras.IC2CExtras;
import trinsdar.ic2c_extras.fluid.FluidItemStackHandler;
import trinsdar.ic2c_extras.util.Registry;
import trinsdar.ic2c_extras.util.fluidcell.CustomModelLoader;
import trinsdar.ic2c_extras.util.fluidcell.ModelFluidCell;

public class ItemUniversalFluidCell
extends Item {
    private final int size = 1000;
    private final ItemStack empty = new ItemStack((Item)this);
    public ModelResourceLocation[] model = new ModelResourceLocation[2];

    public ItemUniversalFluidCell() {
        this.func_77625_d(64);
        this.setRegistryName("universal_fluid_cell");
        this.func_77655_b("universalFluidCell");
        this.func_77637_a(IC2CExtras.creativeTab);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(ItemUniversalFluidCell.getFluidName(stack));
        if (ItemUniversalFluidCell.isFluidGas(stack).booleanValue()) {
            tooltip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"Gaseous", (Object[])new Object[0]));
        }
        if (ItemUniversalFluidCell.isFluidPlaceable(stack).booleanValue()) {
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"Can be placed in world", (Object[])new Object[0]));
        }
    }

    public static String getFluidName(ItemStack stack) {
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
        if (fluid != null) {
            return fluid.amount + "mB of " + fluid.getLocalizedName();
        }
        return "Empty";
    }

    public static Boolean isFluidPlaceable(ItemStack stack) {
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
        return fluid != null && fluid.getFluid().canBePlacedInWorld();
    }

    public static Boolean isFluidGas(ItemStack stack) {
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
        return fluid != null && fluid.getFluid().isGaseous();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidItemStackHandler(stack, stack, 1000);
    }

    public void func_150895_a(@Nullable CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)this.empty);
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                subItems.add((Object)this.getFilledCell(fluid.getName(), 1));
            }
        }
    }

    public ItemStack getFilledCell(String name, int count) {
        FluidStack fluid = FluidRegistry.getFluidStack((String)name, (int)1000);
        ItemStack stack = this.empty.func_77946_l();
        IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        handler.fill(fluid, true);
        stack.func_190920_e(count);
        return stack;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemstack);
        if (fluidStack == null) {
            return this.tryPickUpFluid(world, player, hand, itemstack, fluidStack);
        }
        return this.tryPlaceFluid(world, player, hand, itemstack, fluidStack);
    }

    public ActionResult<ItemStack> tryPickUpFluid(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, ItemStack itemstack, FluidStack fluidStack) {
        FluidActionResult result;
        RayTraceResult mop = this.func_77621_a(world, player, true);
        ActionResult ret = ForgeEventFactory.onBucketUse((EntityPlayer)player, (World)world, (ItemStack)itemstack, (RayTraceResult)mop);
        if (ret != null) {
            return ret;
        }
        if (mop == null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemstack);
        }
        BlockPos clickPos = mop.func_178782_a();
        if (world.func_175660_a(player, clickPos) && (result = FluidUtil.tryPickUpFluid((ItemStack)itemstack, (EntityPlayer)player, (World)world, (BlockPos)clickPos, (EnumFacing)mop.field_178784_b)).isSuccess()) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)result.getResult());
            itemstack.func_190918_g(1);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemstack);
    }

    public ActionResult<ItemStack> tryPlaceFluid(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, ItemStack itemstack, FluidStack fluidStack) {
        FluidActionResult result;
        BlockPos targetPos;
        RayTraceResult mop = this.func_77621_a(world, player, false);
        ActionResult ret = ForgeEventFactory.onBucketUse((EntityPlayer)player, (World)world, (ItemStack)itemstack, (RayTraceResult)mop);
        if (ret != null) {
            return ret;
        }
        if (mop == null || mop.field_72313_a != RayTraceResult.Type.BLOCK) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemstack);
        }
        BlockPos clickPos = mop.func_178782_a();
        if (world.func_175660_a(player, clickPos) && player.func_175151_a(targetPos = clickPos.func_177972_a(mop.field_178784_b), mop.field_178784_b, itemstack) && (result = FluidUtil.tryPlaceFluid((EntityPlayer)player, (World)world, (BlockPos)targetPos, (ItemStack)itemstack, (FluidStack)fluidStack)).isSuccess() && !player.field_71075_bZ.field_75098_d) {
            player.func_71029_a(StatList.func_188057_b((Item)this));
            itemstack.func_190918_g(1);
            ItemStack emptyStack = new ItemStack((Item)Registry.universalFluidCell);
            if (itemstack.func_190926_b()) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)emptyStack);
            }
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)emptyStack);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        CustomModelLoader.register("universal_fluid_cell", new ModelFluidCell());
    }
}

