/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.util.fluidcell;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import trinsdar.ic2c_extras.util.fluidcell.BakedFluidCell;
import trinsdar.ic2c_extras.util.fluidcell.ModelFluidCell;
import trinsdar.ic2c_extras.util.fluidcell.ModelUtils;

public class ItemOverrideFluidCell
extends ItemOverrideList {
    private static HashMap<String, IBakedModel> CACHE = new HashMap();

    public ItemOverrideFluidCell() {
        super((List)ImmutableList.of());
    }

    public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
        if (fluidStack == null) {
            return originalModel;
        }
        IBakedModel baked = CACHE.get(fluidStack.getFluid().getName());
        if (baked == null) {
            BakedFluidCell bakedCell = (BakedFluidCell)originalModel;
            ModelFluidCell model = new ModelFluidCell(fluidStack.getFluid());
            baked = model.bake((IModelState)TRSRTransformation.identity(), bakedCell.format, ModelUtils.getTextureGetter());
            CACHE.put(fluidStack.getFluid().getName(), baked);
        }
        return baked;
    }
}

