/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.util.recipelists;

import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.recipe.ICannerEnrichRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.MachineRecipe;
import ic2.api.recipe.MachineRecipeResult;
import ic2.api.recipe.RecipeOutput;
import ic2.core.block.machine.recipes.managers.RecipeManager;
import ic2.core.util.helpers.CompareableStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import trinsdar.ic2c_extras.IC2CExtras;
import trinsdar.ic2c_extras.util.FluidMachineOutput;

public class FluidCanningRecipeList
implements ICannerEnrichRecipeManager {
    public static final FluidCanningRecipe INVALID_RECIPE = new FluidCanningRecipe(null, null, new FluidMachineOutput(null, null, new ArrayList<ItemStack>()), true, "Invalid");
    protected List<FluidCanningRecipe> recipes = new ArrayList<FluidCanningRecipe>();
    protected Map<String, FluidCanningRecipe> recipeMap = new LinkedHashMap<String, FluidCanningRecipe>();
    protected Map<CompareableStack, IRecipeInput> validInputs = new LinkedHashMap<CompareableStack, IRecipeInput>();
    String category;

    public FluidCanningRecipeList(String category) {
        this.category = category;
    }

    public void addEnrichingRecipe(IRecipeInput input, FluidStack inputFluid, MachineOutput output, String id) {
        id = FluidCanningRecipeList.getRecipeID(this.recipeMap.keySet(), id, 0);
        if (this.recipeMap.containsKey(id) || !RecipeManager.register((String)this.category, (String)id)) {
            return;
        }
        if (input == null || inputFluid == null) {
            IC2CExtras.logger.info("Recipe[" + id + "] has a invalid input for machine " + this.category);
            return;
        }
        if (this.isListInvalid(output.getAllOutputs()) || output instanceof FluidMachineOutput && ((FluidMachineOutput)output).getFluid() == null) {
            IC2CExtras.logger.info("Recipe[" + id + "] has a invalid output for machine " + this.category);
            IC2CExtras.logger.info("Recipe[" + input + "," + inputFluid + "] as input " + this.category);
            return;
        }
        FluidCanningRecipe recipe = new FluidCanningRecipe(input, inputFluid, output, true, id);
        this.recipes.add(recipe);
        this.recipeMap.put(id, recipe);
        for (ItemStack stack : input.getInputs()) {
            this.validInputs.put(new CompareableStack(stack), input);
        }
    }

    public void addEmptyingRecipe(IRecipeInput input, MachineOutput output, String id) {
        id = FluidCanningRecipeList.getRecipeID(this.recipeMap.keySet(), id, 0);
        if (this.recipeMap.containsKey(id) || !RecipeManager.register((String)this.category, (String)id)) {
            return;
        }
        if (input == null) {
            IC2CExtras.logger.info("Recipe[" + id + "] has a invalid input for machine " + this.category);
            return;
        }
        if (this.isListInvalid(output.getAllOutputs()) || output instanceof FluidMachineOutput && ((FluidMachineOutput)output).getFluid() == null) {
            IC2CExtras.logger.info("Recipe[" + id + "] has a invalid output for machine " + this.category);
            IC2CExtras.logger.info("Recipe[" + input + "] as input " + this.category);
            return;
        }
        FluidCanningRecipe recipe = new FluidCanningRecipe(input, output, true, id);
        this.recipes.add(recipe);
        this.recipeMap.put(id, recipe);
        for (ItemStack stack : input.getInputs()) {
            this.validInputs.put(new CompareableStack(stack), input);
        }
    }

    public void addFillingRecipe(IRecipeInput input, FluidStack inputFluid, MachineOutput output, String id) {
        id = FluidCanningRecipeList.getRecipeID(this.recipeMap.keySet(), id, 0);
        if (this.recipeMap.containsKey(id) || !RecipeManager.register((String)this.category, (String)id)) {
            return;
        }
        if (input == null || inputFluid == null) {
            IC2CExtras.logger.info("Recipe[" + id + "] has a invalid input for machine " + this.category);
            return;
        }
        if (this.isListInvalid(output.getAllOutputs())) {
            IC2CExtras.logger.info("Recipe[" + id + "] has a invalid output for machine " + this.category);
            IC2CExtras.logger.info("Recipe[" + input + "," + inputFluid + "] as input " + this.category);
            return;
        }
        FluidCanningRecipe recipe = new FluidCanningRecipe(input, inputFluid, output, true, id);
        this.recipes.add(recipe);
        this.recipeMap.put(id, recipe);
        for (ItemStack stack : input.getInputs()) {
            this.validInputs.put(new CompareableStack(stack), input);
        }
    }

    public void addEnrichingRecipe(IRecipeInput input, FluidStack inputFluid, FluidStack outputFluid, NBTTagCompound nbt, String id) {
        id = FluidCanningRecipeList.getRecipeID(this.recipeMap.keySet(), id, 0);
        if (this.recipeMap.containsKey(id) || !RecipeManager.register((String)this.category, (String)id)) {
            return;
        }
        if (input == null || inputFluid == null) {
            IC2CExtras.logger.info("Recipe[" + id + "] has a invalid input for machine " + this.category);
            return;
        }
        if (outputFluid == null) {
            IC2CExtras.logger.info("Recipe[" + id + "] has a invalid output for machine " + this.category);
            IC2CExtras.logger.info("Recipe[" + input + "," + inputFluid + "] as input " + this.category);
            return;
        }
        FluidCanningRecipe recipe = new FluidCanningRecipe(input, inputFluid, new FluidMachineOutput(nbt, outputFluid, new ItemStack[0]), false, id);
        this.recipes.add(recipe);
        this.recipeMap.put(id, recipe);
        for (ItemStack stack : input.getInputs()) {
            this.validInputs.put(new CompareableStack(stack), input);
        }
    }

    public static String getRecipeID(Set<String> ids, String base, int index) {
        String newString = base;
        if (index > 0) {
            newString = newString + "_" + index;
        }
        if (ids.contains(newString)) {
            return FluidCanningRecipeList.getRecipeID(ids, base, index + 1);
        }
        return newString;
    }

    public boolean isValidRecipeInput(ItemStack stack) {
        IRecipeInput input = this.validInputs.get(new CompareableStack(stack));
        if (input == null) {
            return false;
        }
        return input.matches(stack);
    }

    public FluidCanningRecipe getRecipe(Predicate<FluidCanningRecipe> checker) {
        for (FluidCanningRecipe recipe : this.recipes) {
            if (!checker.test(recipe)) continue;
            return recipe;
        }
        return INVALID_RECIPE;
    }

    public FluidCanningRecipe getFromID(String id) {
        return this.recipeMap.get(id);
    }

    private boolean isListInvalid(List<ItemStack> list) {
        if (list.isEmpty()) {
            return true;
        }
        for (ItemStack stack : list) {
            if (!stack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public void addRecipe(FluidStack fluidStack, IRecipeInput iRecipeInput, FluidStack fluidStack1) {
        this.addEnrichingRecipe(iRecipeInput, fluidStack, fluidStack1, null, fluidStack1.getUnlocalizedName());
    }

    public RecipeOutput getOutputFor(FluidStack fluidStack, ItemStack itemStack, boolean b, boolean b1) {
        return null;
    }

    public boolean addRecipe(ICannerEnrichRecipeManager.Input input, FluidStack fluidStack, NBTTagCompound nbtTagCompound, boolean b) {
        this.addEnrichingRecipe(input.additive, input.fluid, fluidStack, nbtTagCompound, fluidStack.getUnlocalizedName());
        return true;
    }

    public MachineRecipeResult<ICannerEnrichRecipeManager.Input, FluidStack, ICannerEnrichRecipeManager.RawInput> apply(ICannerEnrichRecipeManager.RawInput rawInput, boolean b) {
        return null;
    }

    public Iterable<? extends MachineRecipe<ICannerEnrichRecipeManager.Input, FluidStack>> getRecipes() {
        return null;
    }

    public boolean isIterable() {
        return false;
    }

    public Collection<FluidCanningRecipe> getRecipeList() {
        return new ArrayList<FluidCanningRecipe>(this.recipes);
    }

    public static class FluidCanningRecipe {
        IRecipeInput input;
        FluidStack inputFluid;
        MachineOutput outputs;
        String id;
        boolean itemOutput;
        boolean fluidInput;
        boolean fluidOutput;

        public FluidCanningRecipe(IRecipeInput input, FluidStack inputFluid, MachineOutput outputs, boolean itemOutput, String id) {
            this.input = input;
            this.inputFluid = inputFluid;
            this.outputs = outputs;
            this.id = id;
            this.itemOutput = itemOutput;
            this.fluidInput = true;
            this.fluidOutput = outputs instanceof FluidMachineOutput;
        }

        public FluidCanningRecipe(IRecipeInput input, MachineOutput outputs, boolean itemOutput, String id) {
            this.input = input;
            this.outputs = outputs;
            this.id = id;
            this.fluidInput = false;
            this.itemOutput = itemOutput;
            this.fluidOutput = outputs instanceof FluidMachineOutput;
        }

        public String getRecipeID() {
            return this.id;
        }

        public IRecipeInput getInput() {
            return this.input;
        }

        public FluidStack getInputFluid() {
            return this.inputFluid;
        }

        public FluidStack getOutputFluid() {
            return this.outputs instanceof FluidMachineOutput ? ((FluidMachineOutput)this.outputs).getFluid() : null;
        }

        public boolean matches(ItemStack stack) {
            return this.input == null ? stack.func_190926_b() : this.input.matches(stack) && this.input.getAmount() <= stack.func_190916_E();
        }

        public boolean hasFluidInput() {
            return this.fluidInput;
        }

        public boolean hasFluidOutput() {
            return this.fluidOutput;
        }

        public boolean hasItemOutput() {
            return this.itemOutput;
        }

        public MachineOutput getOutputs() {
            return this.outputs;
        }
    }
}

