/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import flaxbeard.immersivepetroleum.client.model.ModelSpeedboat;
import flaxbeard.immersivepetroleum.common.entity.EntitySpeedboat;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderSpeedboat
extends Render<EntitySpeedboat> {
    private static String texture = "immersivepetroleum:textures/models/boat_motor.png";
    private static String textureArmor = "immersivepetroleum:textures/models/boat_motor_armor.png";
    protected ModelSpeedboat modelBoat = new ModelSpeedboat();

    public RenderSpeedboat(RenderManager renderManagerIn) {
        super(renderManagerIn);
        this.field_76989_e = 0.5f;
    }

    public void doRender(EntitySpeedboat entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179094_E();
        this.setupTranslation(x, y, z);
        this.setupRotation(entity, entityYaw, partialTicks);
        ClientUtils.bindTexture((String)(entity.isFireproof ? textureArmor : texture));
        if (entity.inLava) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.24375f, (float)0.0f);
        }
        if (this.field_188301_f) {
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c((Entity)entity));
        }
        this.modelBoat.func_78088_a((Entity)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        if (entity.hasIcebreaker) {
            ClientUtils.bindTexture((String)textureArmor);
            this.modelBoat.renderIcebreaker((Entity)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        }
        if (entity.hasRudders) {
            ClientUtils.bindTexture((String)textureArmor);
            this.modelBoat.renderRudders((Entity)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        }
        if (entity.hasTank) {
            ClientUtils.bindTexture((String)textureArmor);
            this.modelBoat.renderTank((Entity)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        }
        if (entity.hasPaddles) {
            ClientUtils.bindTexture((String)texture);
            this.modelBoat.renderPaddles((Entity)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        }
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.func_179119_h();
        }
        GlStateManager.func_179121_F();
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    public void setupRotation(EntitySpeedboat boat, float p_188311_2_, float p_188311_3_) {
        GlStateManager.func_179114_b((float)(180.0f - p_188311_2_), (float)0.0f, (float)1.0f, (float)0.0f);
        float f = (float)boat.func_70268_h() - p_188311_3_;
        float f1 = boat.func_70271_g() - p_188311_3_;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)f) * f * f1 / 10.0f * (float)boat.func_70267_i()), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (boat.isBoosting) {
            GlStateManager.func_179114_b((float)3.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
    }

    public void setupTranslation(double p_188309_1_, double p_188309_3_, double p_188309_5_) {
        GlStateManager.func_179109_b((float)((float)p_188309_1_), (float)((float)p_188309_3_ + 0.375f), (float)((float)p_188309_5_));
    }

    public boolean func_188295_H_() {
        return true;
    }

    public void renderMultipass(EntitySpeedboat p_188300_1_, double p_188300_2_, double p_188300_4_, double p_188300_6_, float p_188300_8_, float p_188300_9_) {
        GlStateManager.func_179094_E();
        this.setupTranslation(p_188300_2_, p_188300_4_, p_188300_6_);
        this.setupRotation(p_188300_1_, p_188300_8_, p_188300_9_);
        ClientUtils.bindTexture((String)texture);
        this.modelBoat.func_187054_b((Entity)p_188300_1_, p_188300_9_, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation getEntityTexture(EntitySpeedboat entity) {
        return new ResourceLocation(texture);
    }
}

