/*
 * Decompiled with CFR 0.152.
 */
package com.sosnitzka.taiga.traits;

import com.sosnitzka.taiga.traits.TraitProgressiveStats;
import com.sosnitzka.taiga.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class TraitSuperHeavy
extends TraitProgressiveStats {
    protected static int TICK_PER_STAT = 50;
    protected static float blockcount = 500.0f;

    public TraitSuperHeavy() {
        super(TraitSuperHeavy.class.getSimpleName().toLowerCase().substring(5), TextFormatting.DARK_GRAY);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
        NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
        Utils.GeneralNBTData data = Utils.GeneralNBTData.read(tag);
        if (data.brokenblocks == 0) {
            return;
        }
        event.setNewSpeed(Math.max(event.getNewSpeed() - (float)data.brokenblocks * event.getOriginalSpeed() / blockcount, 0.35f));
    }

    public void afterBlockBreak(ItemStack tool, World world, IBlockState state, BlockPos pos, EntityLivingBase player, boolean wasEffective) {
        NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
        Utils.GeneralNBTData data = Utils.GeneralNBTData.read(tag);
        ++data.brokenblocks;
        data.write(tag);
        TagUtil.setExtraTag((ItemStack)tool, (NBTTagCompound)tag);
    }

    public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity.field_70173_aa % TICK_PER_STAT > 0) {
            return;
        }
        if (this.playerIsBreakingBlock(entity)) {
            return;
        }
        NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
        Utils.GeneralNBTData data = Utils.GeneralNBTData.read(tag);
        if (data.brokenblocks > 0) {
            --data.brokenblocks;
        }
        data.write(tag);
        TagUtil.setExtraTag((ItemStack)tool, (NBTTagCompound)tag);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent e) {
        ItemStack tool = e.getItemStack();
        if (TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)tool), (String)this.identifier)) {
            NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
            Utils.GeneralNBTData data = Utils.GeneralNBTData.read(tag);
            e.getToolTip().add(TextFormatting.RED + "Broken Blocks: " + TextFormatting.WHITE + data.brokenblocks);
        }
    }
}

