/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load;

import alexiil.mc.mod.load.CLSLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class Tips {
    private static final List<String> tips = new ArrayList<String>();
    private static boolean anyTips = false;

    public static void load() {
        File f = new File("config/customloadingscreen_tips.txt");
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException io) {
                io.printStackTrace();
            }
        }
        try (BufferedReader br = new BufferedReader(new FileReader(f));){
            Tips.load(Tips.parseTips(br));
        }
        catch (FileNotFoundException e) {
            CLSLog.info("No tip file found at " + f);
        }
        catch (IOException e) {
            CLSLog.warn("Failed to load the tips file: " + f, e);
        }
    }

    public static void load(List<String> from) {
        tips.clear();
        tips.addAll(from);
        Collections.shuffle(tips);
        if (tips.isEmpty()) {
            tips.add("Tips file was empty!");
            anyTips = false;
        } else {
            anyTips = true;
        }
    }

    public static void parseTips(BufferedReader from, List<String> to) throws IOException {
        String line;
        while ((line = from.readLine()) != null) {
            if (line.isEmpty() || line.startsWith("#")) continue;
            to.add(line);
        }
    }

    public static List<String> parseTips(BufferedReader from) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        Tips.parseTips(from, list);
        return list;
    }

    public static String getFirstTip() {
        return tips.get(0);
    }

    public static boolean hasAnyTips() {
        return anyTips;
    }

    public static int getTipCount() {
        return tips.size();
    }

    @Nullable
    public static String getTipAt(int index) {
        if (index < 0 || index >= tips.size()) {
            return null;
        }
        return tips.get(index);
    }

    public static String getTip(int index) {
        int count = tips.size();
        if (index < 0) {
            index = index % count + count;
        }
        if (index >= count) {
            index %= count;
        }
        return tips.get(index);
    }

    public static String getTip(long index) {
        return Tips.getTip((int)index);
    }

    static {
        tips.add("Tips haven't been loaded yet!");
    }
}

