/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.condition;

import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.ExpressionDebugManager;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IConstantNode;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IDependancyVisitor;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IDependantNode;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IExpressionNode;

public class NodeConditionalObject<T>
implements IExpressionNode.INodeObject<T>,
IDependantNode {
    private final IExpressionNode.INodeBoolean condition;
    private final IExpressionNode.INodeObject<T> ifTrue;
    private final IExpressionNode.INodeObject<T> ifFalse;

    public NodeConditionalObject(IExpressionNode.INodeBoolean condition, IExpressionNode.INodeObject<T> ifTrue, IExpressionNode.INodeObject<T> ifFalse) {
        this.condition = condition;
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
    }

    @Override
    public Class<T> getType() {
        return this.ifTrue.getType();
    }

    @Override
    public T evaluate() {
        return this.condition.evaluate() ? this.ifTrue.evaluate() : this.ifFalse.evaluate();
    }

    @Override
    public IExpressionNode.INodeObject<T> inline() {
        ExpressionDebugManager.debugStart("Inlining " + this);
        IExpressionNode.INodeBoolean c = this.condition.inline();
        IExpressionNode t = this.ifTrue.inline();
        IExpressionNode f = this.ifFalse.inline();
        if (c instanceof IConstantNode) {
            IExpressionNode val = c.evaluate() ? t : f;
            ExpressionDebugManager.debugEnd("Fully inlined to " + val);
            return val;
        }
        if (c != this.condition || t != this.ifTrue || f != this.ifFalse) {
            NodeConditionalObject<T> val = new NodeConditionalObject<T>(c, t, f);
            ExpressionDebugManager.debugEnd("Partially inlined to " + val);
            return val;
        }
        ExpressionDebugManager.debugEnd("Unable to inline at all!");
        return this;
    }

    @Override
    public void visitDependants(IDependancyVisitor visitor) {
        visitor.dependOn(this.condition, this.ifTrue, this.ifFalse);
    }

    public String toString() {
        return "(" + this.condition + ") ? (" + this.ifTrue + ") : (" + this.ifFalse + ")";
    }
}

