/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.malisis.core.client.gui.ClipArea;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.IClipable;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.BasicContainer;
import net.malisis.core.client.gui.component.control.UIScrollBar;
import net.malisis.core.client.gui.component.control.UISlimScrollbar;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.util.MathUtil;
import net.malisis.core.util.MouseButton;
import net.malisis.core.util.TriFunction;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BasicList<T>
extends BasicContainer<BasicList<T>> {
    private final UIScrollBar scrollbar;
    private boolean canDeselect;
    private boolean canInternalClick;
    private boolean isDirty;
    private boolean readOnly;
    private float scrollStep = 0.25f;
    private float extraScrollStep = 0.125f;
    private int itemSpacing = 0;
    private List<T> items = new ArrayList<T>();
    private TriFunction<MalisisGui, BasicList<T>, T, ? extends ItemComponent<?>> itemComponentFactory = DefaultItemComponent::new;
    @Nullable
    private T selectedItem;
    @Nullable
    private Consumer<T> onSelectConsumer;

    public BasicList(MalisisGui gui, int width, int height) {
        super(gui, width, height);
        this.scrollbar = new UISlimScrollbar(gui, this, UIScrollBar.Type.VERTICAL);
        this.scrollbar.setAutoHide(true);
        this.setBackgroundAlpha(0);
    }

    public int getSize() {
        return this.getItems().size();
    }

    public List<T> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public BasicList<T> setItems(@Nullable Collection<T> items) {
        this.items.clear();
        if (items != null) {
            this.items.addAll(items);
        }
        this.isDirty = true;
        this.fireEvent(new ItemsChangedEvent(this));
        return this;
    }

    @Nullable
    public T getItem(int index) {
        return this.items.get(index);
    }

    public boolean addItem(T item) {
        boolean result = this.items.add(item);
        if (result) {
            this.isDirty = true;
            this.fireEvent(new ItemsChangedEvent(this));
        }
        return result;
    }

    public boolean addItems(Collection<T> items) {
        boolean result = this.items.addAll(items);
        if (result) {
            this.isDirty = true;
            this.fireEvent(new ItemsChangedEvent(this));
        }
        return result;
    }

    public void addItem(int index, T item) {
        this.items.add(index, item);
        this.isDirty = true;
        this.fireEvent(new ItemsChangedEvent(this));
    }

    public boolean removeItem(T item) {
        boolean result = this.items.remove(item);
        this.isDirty = true;
        this.fireEvent(new ItemsChangedEvent(this));
        return result;
    }

    public BasicList<T> removeItem(int index) {
        this.items.remove(index);
        this.isDirty = true;
        this.fireEvent(new ItemsChangedEvent(this));
        return this;
    }

    public boolean removeItems(Collection<T> items) {
        boolean result = this.items.removeAll(items);
        this.isDirty = true;
        this.fireEvent(new ItemsChangedEvent(this));
        return result;
    }

    public BasicList<T> clearItems() {
        this.items.clear();
        this.setSelectedItem(null);
        this.isDirty = true;
        this.fireEvent(new ItemsChangedEvent(this));
        return this;
    }

    @Nullable
    public T getSelectedItem() {
        return this.selectedItem;
    }

    public BasicList<T> setSelectedItem(@Nullable T item) {
        return this.setSelectedItem(item, true);
    }

    public BasicList<T> setSelectedItem(@Nullable T item, boolean markDirty) {
        if (!this.readOnly && this.fireEvent(new SelectEvent<T>(this, this.selectedItem, item))) {
            this.selectedItem = item;
            this.isDirty = markDirty;
            if (this.onSelectConsumer != null) {
                this.onSelectConsumer.accept(item);
            }
        }
        return this;
    }

    public int getItemComponentSpacing() {
        return this.itemSpacing;
    }

    public BasicList<T> setItemComponentSpacing(int spacing) {
        this.itemSpacing = spacing;
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public BasicList<T> setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public boolean canDeselect() {
        return this.canDeselect;
    }

    public BasicList<T> setCanDeselect(boolean canDeselect) {
        this.canDeselect = canDeselect;
        return this;
    }

    public boolean canInternalClick() {
        return this.canInternalClick;
    }

    public BasicList<T> setCanInternalClick(boolean canInternalClick) {
        this.canInternalClick = canInternalClick;
        return this;
    }

    public TriFunction<MalisisGui, BasicList<T>, T, ? extends ItemComponent<?>> getItemComponentFactory() {
        return this.itemComponentFactory;
    }

    public BasicList<T> setItemComponentFactory(TriFunction<MalisisGui, BasicList<T>, T, ? extends ItemComponent<?>> factory) {
        this.itemComponentFactory = factory;
        return this;
    }

    @Nullable
    public Consumer<T> getSelectConsumer() {
        return this.onSelectConsumer;
    }

    public BasicList<T> setSelectConsumer(Consumer<T> onSelectConsumer) {
        this.onSelectConsumer = onSelectConsumer;
        return this;
    }

    public UIScrollBar getScrollBar() {
        return this.scrollbar;
    }

    public void markDirty() {
        this.isDirty = true;
    }

    private void createItemComponents() {
        float step;
        float scrollPoint = this.getScrollBar().getOffset();
        Integer focusedX = MalisisGui.getFocusedComponent() == null ? null : Integer.valueOf(MalisisGui.getFocusedComponent().screenX());
        Integer focusedY = MalisisGui.getFocusedComponent() == null ? null : Integer.valueOf(MalisisGui.getFocusedComponent().screenY());
        boolean wasItemFocused = focusedX != null && focusedY != null && this.getComponentAt(focusedX, focusedY) != null;
        this.removeAll();
        int startY = 0;
        for (T item : this.items) {
            ItemComponent<?> component = this.itemComponentFactory.apply(this.getGui(), this, (BasicList)item);
            component.attachData(item);
            component.setPosition(0, startY);
            if (wasItemFocused && component.screenX() == focusedX.intValue() && component.screenY() == focusedY.intValue()) {
                component.setFocused(true);
            }
            this.add(component);
            startY += component.getHeight() + this.itemSpacing;
        }
        this.getScrollBar().scrollTo(scrollPoint);
        this.isDirty = false;
        this.scrollStep = step = MathUtil.scalef(1.0f, 0.0f, this.items.size(), 0.0f, 1.0f);
        this.extraScrollStep = step * 10.0f;
    }

    @Override
    public ClipArea getClipArea() {
        return new ClipArea((IClipable)this, this, true);
    }

    @Override
    public void setClipContent(boolean clipContent) {
    }

    @Override
    public boolean shouldClipContent() {
        return true;
    }

    @Override
    public float getScrollStep() {
        return GuiScreen.func_146271_m() ? this.extraScrollStep : this.scrollStep;
    }

    @Override
    public void draw(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.isDirty) {
            this.createItemComponents();
        }
        super.draw(renderer, mouseX, mouseY, partialTick);
    }

    public static class SelectEvent<T>
    extends ComponentEvent.ValueChange<BasicList<T>, T> {
        public SelectEvent(BasicList<T> component, @Nullable T oldValue, @Nullable T newValue) {
            super(component, oldValue, newValue);
        }
    }

    public static class ItemsChangedEvent<T>
    extends ComponentEvent<BasicList<T>> {
        public ItemsChangedEvent(BasicList<T> component) {
            super(component);
        }
    }

    public static class DefaultItemComponent<T>
    extends ItemComponent<T> {
        DefaultItemComponent(MalisisGui gui, BasicList<T> parent, T item) {
            super(gui, parent, item);
        }

        @Override
        public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
            renderer.drawText(TextFormatting.WHITE + this.item.toString(), 2.0f, 3.0f, 0.0f);
        }
    }

    public static class ItemComponent<T>
    extends BasicContainer<ItemComponent<T>> {
        private static final int BORDER_COLOR = 0x808080;
        private static final int INNER_COLOR = 0;
        private static final int INNER_HOVER_COLOR = 0x282828;
        private static final int INNER_SELECTED_COLOR = 0x414141;
        protected T item;
        @Nullable
        private Consumer<T> onDoubleClick;

        public ItemComponent(MalisisGui gui, BasicList<T> parent, T item) {
            this(gui, parent, item, null);
        }

        public ItemComponent(MalisisGui gui, BasicList<T> parent, T item, @Nullable Consumer<T> onDoubleClick) {
            super(gui);
            this.setParent(parent);
            this.item = item;
            this.onDoubleClick = onDoubleClick;
            this.setPadding(3, 3);
            this.setColor(0);
            this.setBorder(0x808080, 1, 255);
            this.setSize(0, 15);
            this.construct(gui);
        }

        private static boolean hasParent(UIComponent parent, UIComponent component) {
            UIComponent<?> componentParent = component.getParent();
            if (componentParent == null) {
                return false;
            }
            if (componentParent == parent) {
                return true;
            }
            if (componentParent.getParent() != null) {
                return ItemComponent.hasParent(parent, componentParent.getParent());
            }
            return false;
        }

        protected void construct(MalisisGui gui) {
        }

        @Override
        public boolean onClick(int x, int y) {
            UIComponent<?> component = this.getComponentAt(x, y);
            BasicList parent = (BasicList)this.parent;
            if (this.equals(component) || !this.equals(component) && !parent.canInternalClick && ItemComponent.hasParent(this, component)) {
                if (parent.isReadOnly()) {
                    return false;
                }
                if (parent.canDeselect()) {
                    parent.setSelectedItem(parent.getSelectedItem() == this.item ? null : (Object)this.item, false);
                } else {
                    parent.setSelectedItem(this.item, false);
                }
            }
            return true;
        }

        @Override
        public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
            if (this.parent instanceof BasicList) {
                BasicList parent = (BasicList)this.parent;
                int width = parent.getWidth() - parent.getLeftPadding() - parent.getRightPadding() - (parent.getScrollBar().isEnabled() ? parent.getScrollBar().getRawWidth() + 5 : 0);
                this.setSize(width, this.getHeight());
                UIComponent<?> componentAt = this.getComponentAt(mouseX, mouseY);
                if (parent.getSelectedItem() == this.item) {
                    this.setColor(0x414141);
                } else if (componentAt != null && componentAt.getGui() == MalisisGui.currentGui() && (this.equals(componentAt) || this.equals(componentAt.getParent()))) {
                    this.setColor(0x282828);
                } else {
                    this.setColor(0);
                }
                super.drawBackground(renderer, mouseX, mouseY, partialTick);
            }
        }

        @Override
        public boolean onDoubleClick(int x, int y, MouseButton button) {
            UIComponent<?> parentComponentAt;
            if (button != MouseButton.LEFT) {
                return super.onDoubleClick(x, y, button);
            }
            UIComponent<?> componentAt = this.getComponentAt(x, y);
            UIComponent<?> uIComponent = parentComponentAt = componentAt == null ? null : componentAt.getParent();
            if (!(componentAt instanceof ItemComponent) && !(parentComponentAt instanceof ItemComponent)) {
                return super.onDoubleClick(x, y, button);
            }
            if (this.onDoubleClick != null) {
                this.onDoubleClick.accept(this.item);
            }
            return true;
        }

        public void setOnDoubleClickConsumer(@Nullable Consumer<T> onDoubleClick) {
            this.onDoubleClick = onDoubleClick;
        }
    }
}

