/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse;

import de.maxhenkel.corpse.Death;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;

public class DeathManager {
    public static void addDeath(EntityPlayerMP player, Death death) {
        try {
            File deathFile = DeathManager.getDeathFile(player, death.getId());
            deathFile.getParentFile().mkdirs();
            CompressedStreamTools.func_74795_b((NBTTagCompound)death.toNBT(), (File)deathFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static Death getDeath(EntityPlayerMP player, UUID id) {
        try {
            return Death.fromNBT(CompressedStreamTools.func_74797_a((File)DeathManager.getDeathFile(player, id)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Death> getDeaths(EntityPlayerMP player) {
        return DeathManager.getDeaths(player);
    }

    public static List<Death> getDeaths(EntityPlayerMP context, EntityPlayerMP player) {
        return DeathManager.getDeaths(context, player);
    }

    public static List<Death> getDeaths(EntityPlayerMP context, UUID playerUUID) {
        File playerDeathFolder = DeathManager.getPlayerDeathFolder(context, playerUUID);
        if (!playerDeathFolder.exists()) {
            return Collections.emptyList();
        }
        File[] deaths = playerDeathFolder.listFiles((dir, name) -> {
            String[] split = name.split("\\.");
            if (split.length != 2) {
                return false;
            }
            if (split[1].equals("dat")) {
                try {
                    UUID.fromString(split[0]);
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        });
        return Arrays.stream(deaths).map(f -> {
            try {
                return Death.fromNBT(CompressedStreamTools.func_74797_a((File)f));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }).filter(d -> d != null).sorted(Comparator.comparingLong(Death::getTimestamp).reversed()).collect(Collectors.toList());
    }

    public static File getDeathFile(EntityPlayerMP player, UUID id) {
        return new File(DeathManager.getPlayerDeathFolder(player), id.toString() + ".dat");
    }

    public static File getPlayerDeathFolder(EntityPlayerMP player) {
        return DeathManager.getPlayerDeathFolder(player, player.func_110124_au());
    }

    public static File getPlayerDeathFolder(EntityPlayerMP context, UUID uuid) {
        return new File(DeathManager.getDeathFolder(context.func_71121_q()), uuid.toString());
    }

    public static File getDeathFolder(WorldServer world) {
        return new File(world.func_72860_G().func_75765_b(), "deaths");
    }
}

