/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.commands;

import com.gmail.trentech.pjc.help.Help;
import com.gmail.trentech.pjw.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.gen.WorldGeneratorModifier;
import org.spongepowered.api.world.storage.WorldProperties;

public class CommandProperties
implements CommandCallable {
    private final Help help = (Help)Help.get((String)"world properties").get();

    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        if (arguments.equalsIgnoreCase("properties")) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        if (arguments.equalsIgnoreCase("--help")) {
            this.help.execute(source);
            return CommandResult.success();
        }
        Optional optionalProperties = Sponge.getServer().getWorldProperties(arguments);
        if (!optionalProperties.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, arguments, " does not exist"}), false);
        }
        WorldProperties properties = (WorldProperties)optionalProperties.get();
        ArrayList<Text> list = new ArrayList<Text>();
        Optional optionalWorld = Sponge.getServer().getWorld(properties.getUniqueId());
        if (optionalWorld.isPresent()) {
            list.add(Text.of((Object[])new Object[]{TextColors.GREEN, "Name: ", TextColors.WHITE, properties.getWorldName(), TextColors.GREEN, ", DimId: ", TextColors.WHITE, (int)((Integer)((DataView)properties.getAdditionalProperties().getView(DataQuery.of((String[])new String[]{"SpongeData"})).get()).get(DataQuery.of((String[])new String[]{"dimensionId"})).get()), TextColors.GREEN, ", Loaded: ", TextColors.WHITE, "true", TextColors.GREEN, ", Enabled: ", TextColors.WHITE, properties.isEnabled()}));
        } else {
            list.add(Text.of((Object[])new Object[]{TextColors.GREEN, "Name: ", TextColors.WHITE, properties.getWorldName(), TextColors.GREEN, ", Loaded: ", TextColors.WHITE, "false", TextColors.GREEN, ", Enabled: ", TextColors.WHITE, properties.isEnabled()}));
        }
        list.add(Text.of((Object[])new Object[]{TextColors.GREEN, "Generator: ", TextColors.WHITE, properties.getGeneratorType().getName().toLowerCase(), TextColors.GREEN, ", Dimension: ", TextColors.WHITE, properties.getDimensionType().getName().toLowerCase()}));
        Collection modifiers = properties.getGeneratorModifiers();
        if (!modifiers.isEmpty()) {
            list.add(Text.of((Object[])new Object[]{TextColors.GREEN, "Generator Modifiers: "}));
        }
        for (WorldGeneratorModifier modifier : modifiers) {
            list.add(Text.of((Object[])new Object[]{TextColors.GREEN, "  - ", TextColors.WHITE, modifier.getId()}));
        }
        list.add(Text.of((Object[])new Object[]{TextColors.GREEN, "GameMode: ", TextColors.WHITE, properties.getGameMode().getTranslation().get().toLowerCase(), TextColors.GREEN, ", Difficulty: ", TextColors.WHITE, properties.getDifficulty().getTranslation().get().toLowerCase(), TextColors.GREEN, ", PVP: ", TextColors.WHITE, properties.isPVPEnabled()}));
        list.add(Text.of((Object[])new Object[]{TextColors.GREEN, "Keep Spawn Loaded: ", TextColors.WHITE, properties.doesKeepSpawnLoaded(), TextColors.GREEN, ", Load on Startup: ", TextColors.WHITE, properties.loadOnStartup()}));
        list.add(Text.of((Object[])new Object[]{TextColors.GREEN, "Bonus Chest: ", TextColors.WHITE, properties.doesGenerateBonusChest(), TextColors.GREEN, " Map Features: ", TextColors.WHITE, properties.usesMapFeatures()}));
        if (optionalWorld.isPresent()) {
            list.add(Text.of((Object[])new Object[]{TextColors.GREEN, "Time: ", TextColors.WHITE, Utils.getTime(properties.getWorldTime()), TextColors.GREEN, ", Ticks: ", TextColors.WHITE, properties.getWorldTime() % 24000L, TextColors.GREEN, ", Weather: ", TextColors.WHITE, ((World)optionalWorld.get()).getWeather().getName()}));
        } else {
            list.add(Text.of((Object[])new Object[]{TextColors.GREEN, "Time: ", TextColors.WHITE, Utils.getTime(properties.getWorldTime()), TextColors.GREEN, ", Ticks: ", TextColors.WHITE, properties.getWorldTime() % 24000L}));
        }
        list.add(Text.of((Object[])new Object[]{TextColors.GREEN, "UUID: ", TextColors.WHITE, properties.getUniqueId().toString()}));
        list.add(Text.of((Object[])new Object[]{TextColors.GREEN, "Seed: ", TextColors.WHITE, properties.getSeed()}));
        if (source instanceof Player) {
            PaginationList.Builder pages = PaginationList.builder();
            pages.title(Text.builder().color(TextColors.DARK_GREEN).append(new Text[]{Text.of((Object[])new Object[]{TextColors.GREEN, "Settings"})}).build());
            pages.contents(list);
            pages.sendTo((MessageReceiver)source);
        } else {
            for (Text text : list) {
                source.sendMessage(text);
            }
        }
        return CommandResult.success();
    }

    public List<String> getSuggestions(CommandSource source, String arguments, Location<World> targetPosition) throws CommandException {
        ArrayList<String> list = new ArrayList<String>();
        if (arguments.equalsIgnoreCase("properties")) {
            return list;
        }
        for (WorldProperties world : Sponge.getServer().getAllWorldProperties()) {
            if (world.getWorldName().equalsIgnoreCase(arguments)) {
                return list;
            }
            if (!world.getWorldName().toLowerCase().startsWith(arguments.toLowerCase())) continue;
            list.add(world.getWorldName());
        }
        return list;
    }

    public boolean testPermission(CommandSource source) {
        Optional permission = this.getHelp().getPermission();
        if (permission.isPresent()) {
            return source.hasPermission((String)permission.get());
        }
        return true;
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Optional<Text> getHelp(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Text getUsage(CommandSource source) {
        return this.getHelp().getUsageText();
    }

    public Help getHelp() {
        return this.help;
    }
}

