/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.listeners;

import com.gmail.trentech.pjc.core.ConfigManager;
import com.gmail.trentech.pjc.core.TeleportManager;
import com.gmail.trentech.pjw.Main;
import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.RespawnPlayerEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.event.world.ChangeWorldWeatherEvent;
import org.spongepowered.api.event.world.LoadWorldEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.PortalAgent;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.gen.WorldGeneratorModifier;
import org.spongepowered.api.world.storage.WorldProperties;

public class EventManager {
    @Listener(order=Order.LAST)
    public void onClientConnectionEventJoin(ClientConnectionEvent.Join event) {
        boolean firstJoin;
        Player player = event.getTargetEntity();
        CommentedConfigurationNode node = ConfigManager.get((PluginContainer)Main.getPlugin()).getConfig().getNode(new Object[]{"options"});
        String defaultWorld = ((WorldProperties)Sponge.getServer().getDefaultWorld().get()).getWorldName();
        boolean lobbyMode = node.getNode(new Object[]{"lobby_mode"}).getBoolean();
        boolean bl = firstJoin = !new File(defaultWorld + File.separator + "playerdata", player.getUniqueId().toString() + ".dat").exists();
        if (!firstJoin && !lobbyMode) {
            World world;
            if (!player.hasPermission("pjw.override.gamemode") && ((String)(world = player.getWorld()).getGameRule("forceGamemode").get()).equalsIgnoreCase("true")) {
                player.offer(Keys.GAME_MODE, (Object)player.getWorld().getProperties().getGameMode());
            }
            return;
        }
        String worldName = node.getNode(new Object[]{"first_join", "world"}).getString();
        Optional optionalWorld = Sponge.getServer().getWorld(worldName);
        if (!optionalWorld.isPresent()) {
            return;
        }
        World world = (World)optionalWorld.get();
        player.setLocationSafely(world.getSpawnLocation());
        if (!player.hasPermission("pjw.override.gamemode") && ((String)world.getGameRule("forceGamemode").get()).equalsIgnoreCase("true")) {
            player.offer(Keys.GAME_MODE, (Object)world.getProperties().getGameMode());
        }
    }

    @Listener
    public void onLoadWorldEvent(LoadWorldEvent event) {
        World world = event.getTargetWorld();
        WorldProperties properties = world.getProperties();
        ArrayList<Object> modifiers = new ArrayList<Object>();
        boolean b = false;
        if (!properties.getGeneratorModifiers().isEmpty()) {
            for (WorldGeneratorModifier modifier : properties.getGeneratorModifiers()) {
                if (modifier.getId().equals("pjw:void")) {
                    modifiers.add(Sponge.getRegistry().getType(WorldGeneratorModifier.class, "sponge:void").get());
                    b = true;
                    continue;
                }
                modifiers.add(modifier);
            }
        }
        if (b) {
            properties.setGeneratorModifiers(modifiers);
        }
        if (!properties.getGameRule("spawnOnDeath").isPresent()) {
            properties.setGameRule("spawnOnDeath", "default");
        }
        if (!properties.getGameRule("doWeatherCycle").isPresent()) {
            properties.setGameRule("doWeatherCycle", "true");
        }
        if (!properties.getGameRule("netherPortal").isPresent()) {
            properties.setGameRule("netherPortal", "default");
        }
        if (!properties.getGameRule("endPortal").isPresent()) {
            properties.setGameRule("endPortal", "default");
        }
        if (!properties.getGameRule("forceGamemode").isPresent()) {
            properties.setGameRule("forceGamemode", "false");
        }
    }

    @Listener
    public void onDamageEntityEvent(DamageEntityEvent event, @Root EntityDamageSource damageSource) {
        if (!(event.getTargetEntity() instanceof Player)) {
            return;
        }
        Player victim = (Player)event.getTargetEntity();
        if (!this.isValidPlayer(damageSource)) {
            return;
        }
        World world = victim.getWorld();
        WorldProperties properties = world.getProperties();
        if (!properties.isPVPEnabled() || victim.hasPermission("pjw.override.pvp")) {
            event.setCancelled(true);
        }
    }

    private boolean isValidPlayer(EntityDamageSource src) {
        if (src instanceof Player) {
            return true;
        }
        if (src instanceof Projectile) {
            Projectile projectile = (Projectile)src;
            Optional optionalUUID = projectile.getCreator();
            if (!optionalUUID.isPresent()) {
                return false;
            }
            Optional optionalPlayer = Sponge.getServer().getPlayer((UUID)optionalUUID.get());
            return optionalPlayer.isPresent();
        }
        return false;
    }

    @Listener
    public void onChangeWorldWeatherEvent(ChangeWorldWeatherEvent event) {
        World world = event.getTargetWorld();
        WorldProperties properties = world.getProperties();
        if (((String)properties.getGameRule("doWeatherCycle").get()).equalsIgnoreCase("false")) {
            event.setCancelled(true);
        }
    }

    @Listener
    public void onRespawnPlayerEvent(RespawnPlayerEvent event) {
        World world = (World)event.getFromTransform().getExtent();
        WorldProperties properties = world.getProperties();
        String worldName = (String)properties.getGameRule("spawnOnDeath").get();
        Optional optionalSpawnWorld = Sponge.getServer().getWorld(worldName);
        if (!optionalSpawnWorld.isPresent()) {
            return;
        }
        World spawnWorld = (World)optionalSpawnWorld.get();
        Transform transform = event.getToTransform().setLocation(spawnWorld.getSpawnLocation());
        event.setToTransform(transform);
    }

    @Listener(order=Order.LAST)
    public void onRespawnPlayerEvent2(RespawnPlayerEvent event) {
        Player player = event.getTargetEntity();
        if (player.hasPermission("pjw.override.gamemode")) {
            return;
        }
        World from = (World)event.getFromTransform().getExtent();
        World to = (World)event.getToTransform().getExtent();
        WorldProperties properties = to.getProperties();
        if (!from.equals(to) && ((String)properties.getGameRule("forceGamemode").get()).equalsIgnoreCase("true") && !properties.getGameMode().equals(player.gameMode().get())) {
            player.offer(Keys.GAME_MODE, (Object)properties.getGameMode());
        }
    }

    @Listener
    public void onMoveEntityEventEventTeleport(MoveEntityEvent.Teleport event, @Getter(value="getTargetEntity") Player player) {
        if (player.hasPermission("pjw.override.gamemode")) {
            return;
        }
        World from = (World)event.getFromTransform().getExtent();
        World to = (World)event.getToTransform().getExtent();
        WorldProperties properties = to.getProperties();
        if (!from.equals(to)) {
            if (!player.hasPermission("pjw.worlds." + properties.getWorldName())) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You do not have permission to travel to ", properties.getWorldName()}));
                event.setCancelled(true);
                return;
            }
            if (((String)properties.getGameRule("forceGamemode").get()).equalsIgnoreCase("true") && !properties.getGameMode().equals(player.gameMode().get())) {
                player.offer(Keys.GAME_MODE, (Object)properties.getGameMode());
            }
        }
    }

    @Listener
    public void onMoveEntityEventPortal(MoveEntityEvent.Teleport.Portal event, @Getter(value="getTargetEntity") Player player) {
        Optional optionalWorld;
        String toName;
        World from = (World)event.getFromTransform().getExtent();
        World to = (World)event.getToTransform().getExtent();
        if (to.getName().equals("DIM-1")) {
            toName = (String)from.getGameRule("netherPortal").get();
            if (toName.equals("DIM-1") || toName.equalsIgnoreCase("default")) {
                return;
            }
        } else if (to.getName().equals("DIM1")) {
            toName = (String)from.getGameRule("endPortal").get();
            if (toName.equals("DIM1") || toName.equalsIgnoreCase("default")) {
                return;
            }
        } else {
            return;
        }
        if (!(optionalWorld = Sponge.getServer().getWorld(toName)).isPresent()) {
            return;
        }
        World world = (World)optionalWorld.get();
        Optional optionalLocation = TeleportManager.getRandomLocation((World)world, (int)2000);
        Location location = !optionalLocation.isPresent() ? world.getSpawnLocation() : (Location)optionalLocation.get();
        PortalAgent portalAgent = event.getPortalAgent();
        optionalLocation = portalAgent.findPortal(location);
        if (!optionalLocation.isPresent() && !(optionalLocation = portalAgent.createPortal(location)).isPresent()) {
            event.setCancelled(true);
            return;
        }
        location = (Location)optionalLocation.get();
        Transform transform = new Transform(location.getExtent(), location.getPosition());
        event.setToTransform(transform);
        event.setUsePortalAgent(true);
    }
}

