/*
 * Decompiled with CFR 0.152.
 */
package net.obnoxint.xnbt;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.obnoxint.xnbt.XNBT;
import net.obnoxint.xnbt.types.NBTTag;

public class NBTOutputStream
extends DataOutputStream {
    public NBTOutputStream(OutputStream out) {
        super(out);
    }

    public void writeTag(NBTTag tag) throws IOException {
        byte type = tag.getHeader().getType();
        this.writeByte(type);
        if (type == NBTTag.BaseType.END.Id()) {
            return;
        }
        if (type < NBTTag.BaseType.values().length && tag.getPayload() == null) {
            throw new IOException("null payload in base tag " + tag.getHeader().getName() + " (" + NBTTag.BaseType.byId(type).name() + ")");
        }
        this.writeUTF(tag.getHeader().getName());
        XNBT.getWriter(type).write(tag.getPayload(), this);
    }
}

