/*
 * Decompiled with CFR 0.152.
 */
package nc.block.fluid;

import java.util.Random;
import nc.block.fluid.NCBlockFluid;
import nc.fluid.FluidLiquid;
import nc.util.DamageSources;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockFluidLiquid
extends NCBlockFluid {
    public BlockFluidLiquid(FluidLiquid fluid) {
        super(fluid, Material.field_151586_h);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        int temp = this.getFluid().getTemperature();
        if (temp < 250) {
            entityIn.func_70097_a(DamageSources.HYPOTHERMIA, 0.024f * (float)(250 - temp));
        } else if (temp > 350) {
            entityIn.func_70097_a(DamageSources.FLUID_BURN, Math.min(6.0f, (float)Math.log10(temp - 350)));
        }
    }

    @Override
    protected boolean canMixWithFluids(World world, BlockPos pos, IBlockState state) {
        return false;
    }

    @Override
    protected boolean shouldMixWithAdjacentFluid(World world, BlockPos pos, IBlockState state, IBlockState otherState) {
        return false;
    }

    @Override
    protected IBlockState getSourceMixingState(World world, BlockPos pos, IBlockState state) {
        return Blocks.field_150343_Z.func_176223_P();
    }

    @Override
    protected IBlockState getFlowingMixingState(World world, BlockPos pos, IBlockState state) {
        return Blocks.field_150347_e.func_176223_P();
    }

    @Override
    protected boolean canSetFireToSurroundings(World world, BlockPos pos, IBlockState state, Random rand) {
        return false;
    }

    @Override
    protected IBlockState getFlowingIntoWaterState(World world, BlockPos pos, IBlockState state, Random rand) {
        return null;
    }
}

