/*
 * Decompiled with CFR 0.152.
 */
package nc.handler;

import nc.capability.radiation.entity.IEntityRads;
import nc.config.NCConfig;
import nc.init.NCSounds;
import nc.radiation.RadSources;
import nc.radiation.RadiationHelper;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemUseHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onFoodEaten(LivingEntityUseItemEvent.Finish event) {
        if (event.isCanceled()) {
            return;
        }
        ItemStack stack = event.getItem();
        if (stack.func_190926_b()) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        if (NCConfig.radiation_enabled_public && stack.func_77973_b() instanceof ItemFood) {
            int packed = RecipeItemHelper.func_194113_b((ItemStack)stack);
            if (!RadSources.FOOD_RAD_MAP.containsKey(packed)) {
                return;
            }
            IEntityRads entityRads = RadiationHelper.getEntityRadiation(entity);
            if (entityRads == null) {
                return;
            }
            double rads = RadSources.FOOD_RAD_MAP.get(packed);
            double resistance = RadSources.FOOD_RESISTANCE_MAP.get(packed);
            if (rads > 0.0) {
                entityRads.setPoisonBuffer(entityRads.getPoisonBuffer() + rads);
                entityRads.setRecentPoisonAddition(rads);
                entity.func_184185_a(NCSounds.rad_poisoning, (float)((1.0 - Math.pow(10.0, -Math.sqrt(rads) / 10.0)) * NCConfig.radiation_sound_volumes[3]), 1.0f);
            } else {
                entityRads.setRadawayBuffer(false, entityRads.getRadawayBuffer(false) - rads);
                entityRads.setRecentRadawayAddition(-rads);
                entity.func_184185_a(NCSounds.radaway, (float)((1.0 - Math.pow(10.0, -Math.sqrt(-rads) / 10.0)) * NCConfig.radiation_sound_volumes[3]), 1.0f);
            }
            if (entityRads.getRadXCooldown() <= 0.0) {
                entityRads.setInternalRadiationResistance(entityRads.getInternalRadiationResistance() + resistance);
                entityRads.setRecentRadXAddition(Math.abs(resistance));
                if (resistance > 0.0) {
                    entity.func_184185_a(NCSounds.rad_x, (float)((1.0 - Math.pow(10.0, -5.0 * Math.sqrt(resistance) / NCConfig.radiation_rad_x_amount)) * NCConfig.radiation_sound_volumes[3]), 1.0f);
                } else {
                    entity.func_184185_a(NCSounds.chems_wear_off, (float)((1.0 - Math.pow(10.0, -5.0 * Math.sqrt(-resistance) / NCConfig.radiation_rad_x_amount)) * NCConfig.radiation_sound_volumes[3]), 1.0f);
                }
            }
        }
    }
}

