/*
 * Decompiled with CFR 0.152.
 */
package nc.handler;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import nc.util.IOHelper;
import nc.util.NCUtil;
import nc.util.StringHelper;
import org.apache.commons.io.FileUtils;

public class ScriptAddonHandler {
    public static final ObjectSet<File> SCRIPT_ADDON_DIRS = new ObjectOpenHashSet();
    public static final String[] NC_ASSETS = new String[]{"advancements", "blockstates", "loot_tables", "models", "patchouli_books", "textures"};
    public static final String[] ADDON_ASSETS = new String[]{"advancements", "blockstates", "contenttweaker", "lang", "loot_tables", "models", "modularmachinery", "patchouli_books", "scripts", "textures"};
    public static final String[] IGNORE_SUFFIX = new String[]{".ignore", ".ignored", ".disable", ".disabled"};
    public static final Object2BooleanMap<String> LANG_REFRESH_MAP = new Object2BooleanOpenHashMap();

    public static void init() throws IOException {
        NCUtil.getLogger().info("Constructing NuclearCraft Script Addons...");
        for (String s : new String[]{"addons", "advancements", "blockstates", "lang", "loot_tables", "models/block", "models/item", "patchouli_books/guide", "textures/blocks", "textures/items"}) {
            new File("resources/nuclearcraft/" + s).mkdirs();
        }
        File scripts = new File("scripts/nc_script_addons");
        if (scripts.exists()) {
            FileUtils.deleteDirectory((File)scripts);
        }
        scripts.mkdirs();
        new File("scripts/nc_script_addons/DONT_PUT_YOUR_SCRIPTS_IN_HERE").createNewFile();
        File oldWarning = new File("scripts/nuclearcraft/DONT_PUT_YOUR_SCRIPTS_IN_HERE");
        if (oldWarning.exists()) {
            oldWarning.delete();
        }
        File cot = new File("resources/contenttweaker");
        File cotBackup = new File("resources/.contenttweaker");
        if (cot.exists()) {
            FileUtils.copyDirectory((File)cot, (File)cotBackup);
        }
        File temp = new File("resources/nuclearcraft/addons/.temp");
        temp.mkdirs();
        File addons = new File("resources/nuclearcraft/addons");
        ScriptAddonHandler.extractAddons(addons);
        ScriptAddonHandler.copyAddons(addons);
        if (temp.exists()) {
            FileUtils.deleteDirectory((File)temp);
        }
        for (File f : SCRIPT_ADDON_DIRS) {
            NCUtil.getLogger().info("Constructed \"" + f.getName() + "\" Script Addon!");
        }
        if (cotBackup.exists()) {
            FileUtils.copyDirectory((File)cotBackup, (File)cot);
            FileUtils.deleteDirectory((File)cotBackup);
        }
    }

    public static String removeVersionSuffix(String name) {
        int hyphen = name.lastIndexOf(45);
        if (hyphen > 0) {
            name = name.substring(0, hyphen);
        }
        return name;
    }

    public static void extractAddons(File dir) throws IOException {
        block0: for (File f : dir.listFiles()) {
            if (!f.isFile() || !IOHelper.isZip(f)) continue;
            String fileName = f.getName();
            String fileNameLowerCase = fileName.toLowerCase(Locale.ROOT);
            for (String suffix : IGNORE_SUFFIX) {
                if (fileNameLowerCase.endsWith(suffix)) continue block0;
            }
            if (fileName.endsWith(".zip") || fileName.endsWith(".jar")) {
                fileName = StringHelper.removeSuffix(fileName, 4);
                fileName = ScriptAddonHandler.removeVersionSuffix(fileName);
            }
            IOHelper.unzip(f, "resources/nuclearcraft/addons/.temp/" + fileName);
        }
    }

    public static void copyAddons(File dir) throws IOException {
        if (!dir.isDirectory()) {
            return;
        }
        String dirName = dir.getName();
        if (dirName.equals("__MACOSX")) {
            return;
        }
        String dirNameLowerCase = dirName.toLowerCase();
        for (String suffix : IGNORE_SUFFIX) {
            if (!dirNameLowerCase.endsWith(suffix)) continue;
            return;
        }
        for (File f : dir.listFiles()) {
            if (!f.isDirectory()) continue;
            for (String s : NC_ASSETS) {
                if (!f.getName().equals(s)) continue;
                FileUtils.copyDirectory((File)f, (File)new File("resources/nuclearcraft/" + s));
                SCRIPT_ADDON_DIRS.add((Object)dir);
                break;
            }
            if (f.getName().equals("lang")) {
                ScriptAddonHandler.copyLangs(dir, f);
                SCRIPT_ADDON_DIRS.add((Object)dir);
                continue;
            }
            if (f.getName().equals("scripts")) {
                File legacy = new File("scripts/nuclearcraft/" + dirName);
                if (legacy.exists()) {
                    FileUtils.deleteDirectory((File)legacy);
                }
                FileUtils.copyDirectory((File)f, (File)new File("scripts/nc_script_addons/" + ScriptAddonHandler.removeVersionSuffix(dirName)));
                SCRIPT_ADDON_DIRS.add((Object)dir);
                continue;
            }
            if (f.getName().equals("contenttweaker")) {
                FileUtils.copyDirectory((File)f, (File)new File("resources/contenttweaker"));
                SCRIPT_ADDON_DIRS.add((Object)dir);
                continue;
            }
            if (f.getName().equals("modularmachinery")) {
                FileUtils.copyDirectory((File)f, (File)new File("config/modularmachinery/machinery"));
                SCRIPT_ADDON_DIRS.add((Object)dir);
                continue;
            }
            boolean a = false;
            for (File d : f.listFiles()) {
                if (!d.isDirectory()) continue;
                boolean b = false;
                for (String s : ADDON_ASSETS) {
                    if (!d.getName().equals(s)) continue;
                    if (!a) {
                        ScriptAddonHandler.copyAddons(f);
                        a = true;
                    }
                    b = true;
                }
                if (b) continue;
                ScriptAddonHandler.copyAddons(d);
            }
        }
    }

    public static void copyLangs(File addonDir, File langDir) throws IOException {
        for (File f : langDir.listFiles()) {
            String name = f.getName().toLowerCase();
            if (!f.isFile() || !name.endsWith(".lang")) continue;
            String type = StringHelper.removeSuffix(name, 5);
            File lang = new File("resources/nuclearcraft/lang/" + type + ".lang");
            boolean refreshed = LANG_REFRESH_MAP.getBoolean((Object)type);
            if (!refreshed) {
                LANG_REFRESH_MAP.put((Object)type, true);
                File original = new File("resources/nuclearcraft/lang/" + type + ".original");
                if (original.exists()) {
                    FileUtils.copyFile((File)original, (File)lang);
                } else {
                    if (!lang.exists()) {
                        lang.createNewFile();
                    }
                    FileUtils.copyFile((File)lang, (File)original);
                }
            }
            if (!lang.exists()) continue;
            String s = IOHelper.NEW_LINE;
            IOHelper.appendFile(lang, f, (lang.length() == 0L ? "" : s + s) + "# " + addonDir.getName() + s + s);
        }
    }
}

