/*
 * Decompiled with CFR 0.152.
 */
package nc.handler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import nc.NCInfo;
import nc.capability.radiation.resistance.IRadiationResistance;
import nc.capability.radiation.source.IRadiationSource;
import nc.config.NCConfig;
import nc.multiblock.fission.FissionPlacement;
import nc.multiblock.turbine.TurbinePlacement;
import nc.radiation.RadSources;
import nc.radiation.RadiationHelper;
import nc.recipe.BasicRecipe;
import nc.recipe.NCRecipes;
import nc.recipe.RecipeInfo;
import nc.tile.internal.fluid.Tank;
import nc.util.ArmorHelper;
import nc.util.FontRenderHelper;
import nc.util.InfoHelper;
import nc.util.Lang;
import nc.util.NBTHelper;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TooltipHandler {
    private static final String RADIATION = Lang.localise("item.nuclearcraft.rads");
    private static final String RADIATION_RESISTANCE = Lang.localise("item.nuclearcraft.rad_resist");
    private static final String FOOD_RADIATION = Lang.localise("item.nuclearcraft.food_rads");

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void addAdditionalTooltips(ItemTooltipEvent event) {
        List tooltip = event.getToolTip();
        ItemStack stack = event.getItemStack();
        TooltipHandler.addPlacementRuleTooltip(tooltip, stack);
        TooltipHandler.addRecipeTooltip(tooltip, stack);
        if (NCConfig.radiation_enabled_public) {
            TooltipHandler.addArmorRadiationTooltip(tooltip, stack);
            TooltipHandler.addRadiationTooltip(tooltip, stack);
            TooltipHandler.addFoodRadiationTooltip(tooltip, stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void addPlacementRuleTooltip(List<String> tooltip, ItemStack stack) {
        String rule;
        BasicRecipe recipe;
        RecipeInfo recipeInfo = FissionPlacement.recipe_handler.getRecipeInfoFromInputs(Lists.newArrayList((Object[])new ItemStack[]{stack}), new ArrayList<Tank>());
        BasicRecipe basicRecipe = recipe = recipeInfo == null ? null : (BasicRecipe)recipeInfo.getRecipe();
        if (recipe != null && (rule = (String)FissionPlacement.TOOLTIP_MAP.get((Object)recipe.getPlacementRuleID())) != null) {
            InfoHelper.infoFull(tooltip, TextFormatting.AQUA, FontRenderHelper.wrapString(rule, 225));
        }
        BasicRecipe basicRecipe2 = recipe = (recipeInfo = TurbinePlacement.recipe_handler.getRecipeInfoFromInputs(Lists.newArrayList((Object[])new ItemStack[]{stack}), new ArrayList<Tank>())) == null ? null : (BasicRecipe)recipeInfo.getRecipe();
        if (recipe != null && (rule = (String)TurbinePlacement.TOOLTIP_MAP.get((Object)recipe.getPlacementRuleID())) != null) {
            InfoHelper.infoFull(tooltip, TextFormatting.AQUA, FontRenderHelper.wrapString(rule, 225));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void addRecipeTooltip(List<String> tooltip, ItemStack stack) {
        BasicRecipe recipe;
        RecipeInfo recipeInfo = NCRecipes.pebble_fission.getRecipeInfoFromInputs(Lists.newArrayList((Object[])new ItemStack[]{stack}), new ArrayList<Tank>());
        BasicRecipe basicRecipe = recipe = recipeInfo == null ? null : (BasicRecipe)recipeInfo.getRecipe();
        if (recipe != null) {
            InfoHelper.infoFull(tooltip, new TextFormatting[]{TextFormatting.UNDERLINE, TextFormatting.GREEN, TextFormatting.YELLOW, TextFormatting.LIGHT_PURPLE, TextFormatting.RED, TextFormatting.GRAY, TextFormatting.DARK_AQUA}, NCInfo.fissionFuelInfo(recipe));
        }
        BasicRecipe basicRecipe2 = recipe = (recipeInfo = NCRecipes.solid_fission.getRecipeInfoFromInputs(Lists.newArrayList((Object[])new ItemStack[]{stack}), new ArrayList<Tank>())) == null ? null : (BasicRecipe)recipeInfo.getRecipe();
        if (recipe != null) {
            InfoHelper.infoFull(tooltip, new TextFormatting[]{TextFormatting.UNDERLINE, TextFormatting.GREEN, TextFormatting.YELLOW, TextFormatting.LIGHT_PURPLE, TextFormatting.RED, TextFormatting.GRAY, TextFormatting.DARK_AQUA}, NCInfo.fissionFuelInfo(recipe));
        }
        BasicRecipe basicRecipe3 = recipe = (recipeInfo = NCRecipes.fission_moderator.getRecipeInfoFromInputs(Lists.newArrayList((Object[])new ItemStack[]{stack}), new ArrayList<Tank>())) == null ? null : (BasicRecipe)recipeInfo.getRecipe();
        if (recipe != null) {
            InfoHelper.infoFull(tooltip, new TextFormatting[]{TextFormatting.UNDERLINE, TextFormatting.GREEN, TextFormatting.LIGHT_PURPLE}, NCInfo.fissionModeratorFixedInfo(recipe), TextFormatting.AQUA, NCInfo.fissionModeratorInfo());
        }
        BasicRecipe basicRecipe4 = recipe = (recipeInfo = NCRecipes.fission_reflector.getRecipeInfoFromInputs(Lists.newArrayList((Object[])new ItemStack[]{stack}), new ArrayList<Tank>())) == null ? null : (BasicRecipe)recipeInfo.getRecipe();
        if (recipe != null) {
            InfoHelper.infoFull(tooltip, new TextFormatting[]{TextFormatting.UNDERLINE, TextFormatting.WHITE, TextFormatting.LIGHT_PURPLE}, NCInfo.fissionReflectorFixedInfo(recipe), TextFormatting.AQUA, NCInfo.fissionReflectorInfo());
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void addArmorRadiationTooltip(List<String> tooltip, ItemStack stack) {
        boolean hasRadResistanceNBT;
        if (stack.func_190926_b() || !ArmorHelper.isArmor(stack.func_77973_b(), NCConfig.radiation_horse_armor_public)) {
            return;
        }
        IRadiationResistance armorResistance = RadiationHelper.getRadiationResistance((ICapabilityProvider)stack);
        NBTTagCompound nbt = NBTHelper.getStackNBT(stack);
        boolean bl = hasRadResistanceNBT = stack.func_77942_o() && nbt.func_74764_b("ncRadiationResistance");
        if (armorResistance == null && !hasRadResistanceNBT) {
            return;
        }
        double resistance = 0.0;
        if (armorResistance != null) {
            resistance += armorResistance.getTotalRadResistance();
        }
        if (hasRadResistanceNBT) {
            resistance += nbt.func_74769_h("ncRadiationResistance");
        }
        if (resistance > 0.0) {
            tooltip.add(TextFormatting.AQUA + RADIATION_RESISTANCE + " " + RadiationHelper.resistanceSigFigs(resistance));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void addRadiationTooltip(List<String> tooltip, ItemStack stack) {
        IRadiationSource stackRadiation = RadiationHelper.getRadiationSource((ICapabilityProvider)stack);
        if (stackRadiation == null || stackRadiation.getRadiationLevel() * (double)stack.func_190916_E() <= NCConfig.radiation_lowest_rate) {
            return;
        }
        tooltip.add(RadiationHelper.getRadiationTextColor(stackRadiation.getRadiationLevel() * (double)stack.func_190916_E()) + RADIATION + " " + RadiationHelper.radsPrefix(stackRadiation.getRadiationLevel() * (double)stack.func_190916_E(), true));
    }

    @SideOnly(value=Side.CLIENT)
    private static void addFoodRadiationTooltip(List<String> tooltip, ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemFood)) {
            return;
        }
        int packed = RecipeItemHelper.func_194113_b((ItemStack)stack);
        if (!RadSources.FOOD_RAD_MAP.containsKey(packed)) {
            return;
        }
        double rads = RadSources.FOOD_RAD_MAP.get(packed);
        double resistance = RadSources.FOOD_RESISTANCE_MAP.get(packed);
        if (rads != 0.0 || resistance != 0.0) {
            tooltip.add(TextFormatting.UNDERLINE + FOOD_RADIATION);
        }
        if (rads != 0.0) {
            tooltip.add(RadiationHelper.getFoodRadiationTextColor(rads) + RADIATION + " " + RadiationHelper.radsPrefix(rads, false));
        }
        if (resistance != 0.0) {
            tooltip.add(RadiationHelper.getFoodResistanceTextColor(resistance) + RADIATION_RESISTANCE + " " + RadiationHelper.resistanceSigFigs(resistance));
        }
    }
}

