/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientOr;
import crafttweaker.api.item.IngredientStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.ArrayList;
import nc.integration.crafttweaker.ingredient.CTChanceFluidIngredient;
import nc.integration.crafttweaker.ingredient.CTChanceItemIngredient;
import nc.recipe.RecipeHelper;
import nc.recipe.ingredient.ChanceFluidIngredient;
import nc.recipe.ingredient.ChanceItemIngredient;
import nc.recipe.ingredient.EmptyFluidIngredient;
import nc.recipe.ingredient.EmptyItemIngredient;
import nc.recipe.ingredient.FluidIngredient;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.OreIngredient;
import nc.util.StackHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CTHelper {
    public static ItemStack getItemStack(IItemStack item) {
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        Object internal = item.getInternal();
        if (!(internal instanceof ItemStack)) {
            CraftTweakerAPI.logError((String)("Not a valid item stack: " + item));
        }
        return ((ItemStack)internal).func_77946_l();
    }

    public static FluidStack getFluidStack(ILiquidStack stack) {
        if (stack == null) {
            return null;
        }
        return (FluidStack)stack.getInternal();
    }

    public static IItemIngredient buildAdditionItemIngredient(IIngredient ingredient) {
        if (ingredient == null) {
            return new EmptyItemIngredient();
        }
        if (ingredient instanceof CTChanceItemIngredient) {
            CTChanceItemIngredient chanceIngredient = (CTChanceItemIngredient)ingredient;
            return new ChanceItemIngredient(CTHelper.buildAdditionItemIngredient(chanceIngredient.getInternalIngredient()), chanceIngredient.getChancePercent(), chanceIngredient.getMinStackSize());
        }
        if (ingredient instanceof IItemStack) {
            return RecipeHelper.buildItemIngredient(CTHelper.getItemStack((IItemStack)ingredient));
        }
        if (ingredient instanceof IOreDictEntry) {
            return new OreIngredient(((IOreDictEntry)ingredient).getName(), ((IOreDictEntry)ingredient).getAmount());
        }
        if (ingredient instanceof IngredientStack) {
            return CTHelper.buildOreIngredientArray(ingredient, true);
        }
        if (ingredient instanceof IngredientOr) {
            return CTHelper.buildAdditionItemIngredientArray((IngredientOr)ingredient);
        }
        CraftTweakerAPI.logError((String)String.format("NuclearCraft: Invalid ingredient: %s, %s", ingredient.getClass().getName(), ingredient));
        return null;
    }

    public static IFluidIngredient buildAdditionFluidIngredient(IIngredient ingredient) {
        if (ingredient == null) {
            return new EmptyFluidIngredient();
        }
        if (ingredient instanceof CTChanceFluidIngredient) {
            CTChanceFluidIngredient chanceIngredient = (CTChanceFluidIngredient)ingredient;
            return new ChanceFluidIngredient(CTHelper.buildAdditionFluidIngredient(chanceIngredient.getInternalIngredient()), chanceIngredient.getChancePercent(), chanceIngredient.getStackDiff(), chanceIngredient.getMinStackSize());
        }
        if (ingredient instanceof ILiquidStack) {
            return RecipeHelper.buildFluidIngredient(CTHelper.getFluidStack((ILiquidStack)ingredient));
        }
        if (ingredient instanceof IngredientOr) {
            return CTHelper.buildAdditionFluidIngredientArray((IngredientOr)ingredient);
        }
        CraftTweakerAPI.logError((String)String.format("NuclearCraft: Invalid ingredient: %s, %s", ingredient.getClass().getName(), ingredient));
        return null;
    }

    public static IItemIngredient buildRemovalItemIngredient(IIngredient ingredient) {
        if (ingredient == null) {
            return new EmptyItemIngredient();
        }
        if (ingredient instanceof IItemStack) {
            return RecipeHelper.buildItemIngredient(CTHelper.getItemStack((IItemStack)ingredient));
        }
        if (ingredient instanceof IOreDictEntry) {
            return new OreIngredient(((IOreDictEntry)ingredient).getName(), ((IOreDictEntry)ingredient).getAmount());
        }
        if (ingredient instanceof IngredientStack) {
            return CTHelper.buildOreIngredientArray(ingredient, false);
        }
        if (ingredient instanceof IngredientOr) {
            return CTHelper.buildRemovalItemIngredientArray((IngredientOr)ingredient);
        }
        CraftTweakerAPI.logError((String)String.format("NuclearCraft: Invalid ingredient: %s, %s", ingredient.getClass().getName(), ingredient));
        return null;
    }

    public static IFluidIngredient buildRemovalFluidIngredient(IIngredient ingredient) {
        if (ingredient == null) {
            return new EmptyFluidIngredient();
        }
        if (ingredient instanceof ILiquidStack) {
            return new FluidIngredient(((ILiquidStack)ingredient).getName(), ((ILiquidStack)ingredient).getAmount());
        }
        if (ingredient instanceof IngredientOr) {
            return CTHelper.buildRemovalFluidIngredientArray((IngredientOr)ingredient);
        }
        CraftTweakerAPI.logError((String)String.format("NuclearCraft: Invalid ingredient: %s, %s", ingredient.getClass().getName(), ingredient));
        return null;
    }

    public static IItemIngredient buildAdditionItemIngredientArray(IngredientOr ingredient) {
        if (!(ingredient.getInternal() instanceof IIngredient[])) {
            CraftTweakerAPI.logError((String)String.format("NuclearCraft: Invalid ingredient: %s, %s", ingredient.getClass().getName(), ingredient));
            return null;
        }
        ArrayList<IItemIngredient> ingredientList = new ArrayList<IItemIngredient>();
        for (IIngredient ctIngredient : (IIngredient[])ingredient.getInternal()) {
            ingredientList.add(CTHelper.buildAdditionItemIngredient(ctIngredient));
        }
        return RecipeHelper.buildItemIngredient(ingredientList);
    }

    public static IItemIngredient buildRemovalItemIngredientArray(IngredientOr ingredient) {
        if (!(ingredient.getInternal() instanceof IIngredient[])) {
            CraftTweakerAPI.logError((String)String.format("NuclearCraft: Invalid ingredient: %s, %s", ingredient.getClass().getName(), ingredient));
            return null;
        }
        ArrayList<IItemIngredient> ingredientList = new ArrayList<IItemIngredient>();
        for (IIngredient ctIngredient : (IIngredient[])ingredient.getInternal()) {
            ingredientList.add(CTHelper.buildRemovalItemIngredient(ctIngredient));
        }
        return RecipeHelper.buildItemIngredient(ingredientList);
    }

    public static IItemIngredient buildOreIngredientArray(IIngredient stack, boolean addition) {
        OreIngredient oreStack;
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        stack.getItems().forEach(item -> stackList.add(StackHelper.changeStackSize(CTHelper.getItemStack(item), stack.getAmount())));
        if (addition && (oreStack = RecipeHelper.getOreStackFromItems(stackList, stack.getAmount())) != null) {
            return oreStack;
        }
        return RecipeHelper.buildItemIngredient(stackList);
    }

    public static IFluidIngredient buildAdditionFluidIngredientArray(IngredientOr ingredient) {
        if (!(ingredient.getInternal() instanceof IIngredient[])) {
            CraftTweakerAPI.logError((String)String.format("NuclearCraft: Invalid ingredient: %s, %s", ingredient.getClass().getName(), ingredient));
            return null;
        }
        ArrayList<IFluidIngredient> ingredientList = new ArrayList<IFluidIngredient>();
        for (IIngredient ctIngredient : (IIngredient[])ingredient.getInternal()) {
            ingredientList.add(CTHelper.buildAdditionFluidIngredient(ctIngredient));
        }
        return RecipeHelper.buildFluidIngredient(ingredientList);
    }

    public static IFluidIngredient buildRemovalFluidIngredientArray(IngredientOr ingredient) {
        if (!(ingredient.getInternal() instanceof IIngredient[])) {
            CraftTweakerAPI.logError((String)String.format("NuclearCraft: Invalid ingredient: %s, %s", ingredient.getClass().getName(), ingredient));
            return null;
        }
        ArrayList<IFluidIngredient> ingredientList = new ArrayList<IFluidIngredient>();
        for (IIngredient ctIngredient : (IIngredient[])ingredient.getInternal()) {
            ingredientList.add(CTHelper.buildRemovalFluidIngredient(ctIngredient));
        }
        return RecipeHelper.buildFluidIngredient(ingredientList);
    }
}

