/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.block;

import javax.annotation.Nullable;
import nc.block.property.BlockProperties;
import nc.block.tile.IActivatable;
import nc.multiblock.fission.block.BlockFissionPart;
import nc.multiblock.fission.tile.TileFissionSource;
import nc.render.BlockHighlightTracker;
import nc.util.BlockHelper;
import nc.util.Lang;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockFissionSource
extends BlockFissionPart
implements IActivatable {
    public BlockFissionSource() {
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)BlockProperties.FACING_ALL, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockProperties.FACING_ALL, BlockProperties.ACTIVE});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)(meta & 7));
        return this.func_176223_P().func_177226_a((IProperty)BlockProperties.FACING_ALL, (Comparable)enumfacing).func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)BlockProperties.FACING_ALL)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)BlockProperties.ACTIVE)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)BlockProperties.FACING_ALL, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        BlockHelper.setDefaultFacing(world, pos, state, (PropertyEnum<EnumFacing>)BlockProperties.FACING_ALL);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFissionSource) {
            TileFissionSource source = (TileFissionSource)tile;
            source.facing = (EnumFacing)state.func_177229_b((IProperty)BlockProperties.FACING_ALL);
            world.func_180501_a(pos, state.func_177226_a((IProperty)BlockProperties.FACING_ALL, (Comparable)source.facing).func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(source.getIsRedstonePowered())), 2);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player == null || hand != EnumHand.MAIN_HAND || player.func_70093_af()) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileFissionSource) {
            TileFissionSource source = (TileFissionSource)tile;
            if (!world.field_72995_K) {
                TileFissionSource.PrimingTargetInfo targetInfo = source.getPrimingTarget(true);
                if (targetInfo == null) {
                    player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("nuclearcraft.multiblock.fission_reactor_source.no_target")));
                } else {
                    BlockPos p = targetInfo.fuelComponent.getTilePos();
                    BlockHighlightTracker.sendPacket((EntityPlayerMP)player, p, 5000L);
                    player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("nuclearcraft.multiblock.fission_reactor_source.target", p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), world.func_180495_p(p).func_177230_c().func_149732_F())));
                }
            }
            return true;
        }
        return this.rightClickOnPart(world, pos, player, hand, facing);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return side != null;
    }
}

