/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.solid.tile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.capability.radiation.source.IRadiationSource;
import nc.config.NCConfig;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.fission.FissionCluster;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.tile.IFissionComponent;
import nc.multiblock.fission.tile.IFissionFluxSink;
import nc.multiblock.fission.tile.IFissionFuelComponent;
import nc.multiblock.fission.tile.TileFissionPart;
import nc.multiblock.fission.tile.port.IFissionPortTarget;
import nc.multiblock.fission.tile.port.TileFissionCellPort;
import nc.network.multiblock.SolidFissionCellUpdatePacket;
import nc.radiation.RadiationHelper;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.BasicRecipe;
import nc.recipe.NCRecipes;
import nc.recipe.RecipeInfo;
import nc.recipe.ingredient.IItemIngredient;
import nc.tile.ITileGui;
import nc.tile.generator.IItemGenerator;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.inventory.InventoryConnection;
import nc.tile.internal.inventory.ItemOutputSetting;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileFilteredInventory;
import nc.tile.inventory.ITileInventory;
import nc.util.NBTHelper;
import nc.util.NCMath;
import nc.util.PosHelper;
import nc.util.StackHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileSolidFissionCell
extends TileFissionPart
implements ITileFilteredInventory,
ITileGui<SolidFissionCellUpdatePacket>,
IItemGenerator,
IFissionFuelComponent,
IFissionPortTarget<TileFissionCellPort, TileSolidFissionCell> {
    @Nonnull
    protected final String inventoryName = "nuclearcraft.container.fission_cell";
    @Nonnull
    protected final NonNullList<ItemStack> inventoryStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    @Nonnull
    protected final NonNullList<ItemStack> filterStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    @Nonnull
    protected final NonNullList<ItemStack> consumedStacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    @Nonnull
    protected InventoryConnection[] inventoryConnections = ITileInventory.inventoryConnectionAll(Lists.newArrayList((Object[])new ItemSorption[]{ItemSorption.NON, ItemSorption.NON}));
    protected final int itemInputSize = 1;
    protected final int itemOutputSize = 1;
    protected final int otherSlotsSize = 0;
    public double baseProcessTime = 1.0;
    public double baseProcessEfficiency = 0.0;
    public double baseProcessDecayFactor = 0.0;
    public double baseProcessRadiation = 0.0;
    public int baseProcessHeat = 0;
    public int baseProcessCriticality = 1;
    protected boolean selfPriming = false;
    public double time;
    public boolean isProcessing;
    public boolean hasConsumed;
    public boolean canProcessInputs;
    public double decayProcessHeat = 0.0;
    public double decayHeatFraction = 0.0;
    public double iodineFraction = 0.0;
    public double poisonFraction = 0.0;
    protected RecipeInfo<BasicRecipe> recipeInfo;
    protected Set<EntityPlayer> updatePacketListeners;
    protected FissionCluster cluster = null;
    protected long heat = 0L;
    public long clusterHeatStored;
    public long clusterHeatCapacity;
    protected boolean primed = false;
    protected boolean fluxSearched = false;
    protected long flux = 0L;
    public int heatMult = 0;
    protected double undercoolingLifetimeFactor = 1.0;
    protected Double sourceEfficiency = null;
    protected long[] moderatorLineFluxes = new long[]{0L, 0L, 0L, 0L, 0L, 0L};
    protected Double[] moderatorLineEfficiencies = new Double[]{null, null, null, null, null, null};
    protected IFissionFluxSink[] adjacentFluxSinks = new IFissionFluxSink[]{null, null, null, null, null, null};
    protected final LongSet[] passiveModeratorCaches = new LongSet[]{new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet()};
    protected final LongSet[] activeModeratorCaches = new LongSet[]{new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet()};
    protected final IFissionFuelComponent.ModeratorLine[] moderatorLineCaches = new IFissionFuelComponent.ModeratorLine[]{null, null, null, null, null, null};
    protected final LongSet[] passiveReflectorModeratorCaches = new LongSet[]{new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet()};
    protected final LongSet[] activeReflectorModeratorCaches = new LongSet[]{new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet()};
    protected final LongSet activeReflectorCache = new LongOpenHashSet();
    protected BlockPos masterPortPos = PosHelper.DEFAULT_NON;
    protected TileFissionCellPort masterPort = null;

    public TileSolidFissionCell() {
        super(CuboidalPartPositionType.INTERIOR);
        this.updatePacketListeners = new ObjectOpenHashSet();
    }

    @Override
    public void onMachineAssembled(FissionReactor controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    @Override
    @Nullable
    public FissionCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void setClusterInternal(@Nullable FissionCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public boolean isValidHeatConductor(Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        return this.isProcessing || this.getDecayHeating() > 0;
    }

    @Override
    public boolean isFunctional() {
        return this.isProcessing || this.getDecayHeating() > 0;
    }

    @Override
    public void resetStats() {
        this.fluxSearched = false;
        this.heatMult = 0;
        this.flux = 0;
        this.undercoolingLifetimeFactor = 1.0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            this.moderatorLineFluxes[dir.func_176745_a()] = 0L;
            this.moderatorLineEfficiencies[dir.func_176745_a()] = null;
            this.adjacentFluxSinks[dir.func_176745_a()] = null;
            this.passiveModeratorCaches[dir.func_176745_a()].clear();
            this.activeModeratorCaches[dir.func_176745_a()].clear();
            this.moderatorLineCaches[dir.func_176745_a()] = null;
            this.passiveReflectorModeratorCaches[dir.func_176745_a()].clear();
            this.activeReflectorModeratorCaches[dir.func_176745_a()].clear();
        }
        this.activeReflectorCache.clear();
        this.refreshRecipe();
        this.refreshActivity();
        this.refreshIsProcessing(true);
    }

    @Override
    public boolean isClusterRoot() {
        return true;
    }

    @Override
    public void clusterSearch(Integer id, Object2IntMap<IFissionComponent> clusterSearchCache, Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        this.refreshRecipe();
        this.refreshActivity();
        this.refreshIsProcessing(false);
        IFissionFuelComponent.super.clusterSearch(id, clusterSearchCache, componentFailCache, assumedValidCache);
    }

    @Override
    public boolean isProducingFlux() {
        return this.isPrimed() || this.isProcessing;
    }

    @Override
    public void tryPriming(FissionReactor sourceReactor, boolean fromSource) {
        if (this.getMultiblock() != sourceReactor) {
            return;
        }
        if (this.canProcessInputs) {
            this.primed = true;
        }
    }

    @Override
    public boolean isPrimed() {
        return this.primed;
    }

    @Override
    public void addToPrimedCache(ObjectSet<IFissionFuelComponent> primedCache) {
        primedCache.add((Object)this);
    }

    @Override
    public void unprime() {
        this.primed = false;
    }

    @Override
    public boolean isAcceptingFlux(EnumFacing side) {
        return this.canProcessInputs;
    }

    @Override
    public void refreshIsProcessing(boolean checkCluster) {
        this.isProcessing = this.isProcessing(checkCluster);
        this.hasConsumed = this.hasConsumed();
    }

    @Override
    public boolean isFluxSearched() {
        return this.fluxSearched;
    }

    @Override
    public void setFluxSearched(boolean fluxSearched) {
        this.fluxSearched = fluxSearched;
    }

    @Override
    public void incrementHeatMultiplier() {
        ++this.heatMult;
    }

    @Override
    public double getSourceEfficiency() {
        return this.sourceEfficiency == null ? 1.0 : this.sourceEfficiency;
    }

    @Override
    public void setSourceEfficiency(double sourceEfficiency, boolean maximize) {
        this.sourceEfficiency = this.sourceEfficiency != null && maximize ? Math.max(this.sourceEfficiency, sourceEfficiency) : sourceEfficiency;
    }

    @Override
    public long getFlux() {
        return this.flux;
    }

    @Override
    public void addFlux(long addedFlux) {
        this.flux += addedFlux;
    }

    @Override
    public long[] getModeratorLineFluxes() {
        return this.moderatorLineFluxes;
    }

    @Override
    public Double[] getModeratorLineEfficiencies() {
        return this.moderatorLineEfficiencies;
    }

    @Override
    public IFissionFluxSink[] getAdjacentFluxSinks() {
        return this.adjacentFluxSinks;
    }

    @Override
    public LongSet[] getPassiveModeratorCaches() {
        return this.passiveModeratorCaches;
    }

    @Override
    public LongSet[] getActiveModeratorCaches() {
        return this.activeModeratorCaches;
    }

    @Override
    public IFissionFuelComponent.ModeratorLine[] getModeratorLineCaches() {
        return this.moderatorLineCaches;
    }

    @Override
    public LongSet[] getPassiveReflectorModeratorCaches() {
        return this.passiveReflectorModeratorCaches;
    }

    @Override
    public LongSet[] getActiveReflectorModeratorCaches() {
        return this.activeReflectorModeratorCaches;
    }

    @Override
    public LongSet getActiveReflectorCache() {
        return this.activeReflectorCache;
    }

    @Override
    public long getRawHeating() {
        return this.isProcessing ? (long)(this.baseProcessHeat * this.heatMult) : 0L;
    }

    @Override
    public long getRawHeatingIgnoreCoolingPenalty() {
        return this.isProcessing ? 0L : (long)this.getDecayHeating();
    }

    @Override
    public double getEffectiveHeating() {
        return this.isProcessing ? (double)this.baseProcessHeat * this.getEfficiency() : 0.0;
    }

    @Override
    public double getEffectiveHeatingIgnoreCoolingPenalty() {
        return this.isProcessing ? 0.0 : this.getFloatingPointDecayHeating();
    }

    @Override
    public long getHeatMultiplier() {
        return this.heatMult;
    }

    @Override
    public double getFluxEfficiencyFactor() {
        return (1.0 + Math.exp(-2.0 * this.getFloatingPointCriticality())) / (1.0 + Math.exp(2.0 * ((double)this.flux - 2.0 * this.getFloatingPointCriticality())));
    }

    @Override
    public double getEfficiency() {
        return this.isProcessing ? (double)this.heatMult * this.baseProcessEfficiency * this.getSourceEfficiency() * this.getModeratorEfficiencyFactor() * this.getFluxEfficiencyFactor() : 0.0;
    }

    @Override
    public double getEfficiencyIgnoreCoolingPenalty() {
        return this.isProcessing ? 0.0 : 1.0;
    }

    @Override
    public void setUndercoolingLifetimeFactor(double undercoolingLifetimeFactor) {
        this.undercoolingLifetimeFactor = undercoolingLifetimeFactor;
    }

    @Override
    public long getCriticality() {
        return NCConfig.fission_decay_mechanics ? (long)NCMath.toInt(this.getFloatingPointCriticality()) : (long)this.baseProcessCriticality;
    }

    @Override
    public double getFloatingPointCriticality() {
        return NCConfig.fission_decay_mechanics ? (double)this.baseProcessCriticality * (1.0 - this.baseProcessDecayFactor + this.poisonFraction) : (double)this.baseProcessCriticality;
    }

    @Override
    public boolean isSelfPriming() {
        return this.selfPriming;
    }

    @Override
    public void defaultRefreshModerators(Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        if (this.isProcessing) {
            this.defaultRefreshAdjacentActiveModerators(componentFailCache, assumedValidCache);
        } else if (this.getDecayHeating() > 0) {
            this.defaultForceAdjacentActiveModerators(componentFailCache, assumedValidCache);
        }
    }

    @Override
    public void onClusterMeltdown(Iterator<IFissionComponent> componentIterator) {
        IRadiationSource chunkSource = RadiationHelper.getRadiationSource((ICapabilityProvider)this.field_145850_b.func_175726_f(this.field_174879_c));
        if (chunkSource != null) {
            RadiationHelper.addToSourceRadiation(chunkSource, 8.0 * this.baseProcessRadiation * this.getSpeedMultiplier() * NCConfig.fission_meltdown_radiation_multiplier);
        }
        componentIterator.remove();
        this.field_145850_b.func_175713_t(this.field_174879_c);
        IBlockState corium = FluidRegistry.getFluid((String)"corium").getBlock().func_176223_P();
        this.field_145850_b.func_175656_a(this.field_174879_c, corium);
        if (this.getMultiblock() != null) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                BlockPos offPos = this.field_174879_c.func_177972_a(dir);
                if (!(((FissionReactor)this.getMultiblock()).rand.nextDouble() < 0.75)) continue;
                this.field_145850_b.func_175713_t(offPos);
                this.field_145850_b.func_175656_a(offPos, corium);
            }
        }
    }

    @Override
    public long getHeatStored() {
        return this.heat;
    }

    @Override
    public void setHeatStored(long heat) {
        this.heat = heat;
    }

    @Override
    public BlockPos getMasterPortPos() {
        return this.masterPortPos;
    }

    @Override
    public void setMasterPortPos(BlockPos pos) {
        this.masterPortPos = pos;
    }

    @Override
    public void clearMasterPort() {
        this.masterPort = null;
        this.masterPortPos = PosHelper.DEFAULT_NON;
    }

    @Override
    public void refreshMasterPort() {
        TileFissionCellPort tileFissionCellPort = this.masterPort = this.getMultiblock() == null ? null : (TileFissionCellPort)((FissionReactor)this.getMultiblock()).getPartMap(TileFissionCellPort.class).get(this.masterPortPos.func_177986_g());
        if (this.masterPort == null) {
            this.masterPortPos = PosHelper.DEFAULT_NON;
        }
    }

    @Override
    public boolean onPortRefresh() {
        this.refreshRecipe();
        this.refreshActivity();
        this.refreshIsProcessing(true);
        return this.isMultiblockAssembled() && ((FissionReactor)this.getMultiblock()).isReactorOn && !this.isProcessing && this.isProcessing(false);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.field_145850_b.field_72995_K) {
            this.refreshMasterPort();
            this.refreshRecipe();
            this.refreshActivity();
            this.refreshIsProcessing(true);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean shouldUpdate;
            boolean wasProcessing = this.isProcessing;
            this.isProcessing = this.isProcessing(true);
            boolean shouldRefresh = this.isMultiblockAssembled() && ((FissionReactor)this.getMultiblock()).isReactorOn && !this.isProcessing && this.isProcessing(false);
            boolean bl = shouldUpdate = wasProcessing != this.isProcessing;
            if (this.isProcessing) {
                this.process();
            } else {
                this.getRadiationSource().setRadiationLevel(0.0);
            }
            this.updateDecayFractions();
            if (shouldRefresh) {
                ((FissionReactor)this.getMultiblock()).refreshFlag = true;
            }
            this.sendTileUpdatePacketToListeners();
            if (shouldUpdate) {
                this.func_70296_d();
            }
        }
    }

    public void updateDecayFractions() {
        if (!NCConfig.fission_decay_mechanics) {
            this.poisonFraction = 0.0;
            this.iodineFraction = 0.0;
            this.decayHeatFraction = 0.0;
            return;
        }
        long oldCriticality = this.getCriticality();
        boolean oldHasEnoughFlux = this.hasEnoughFlux();
        int oldDecayHeating = this.getDecayHeating();
        boolean decayHeatReduce = true;
        boolean iodineReduce = true;
        boolean poisonReduce = true;
        double decayHeatEquilibrium = NCConfig.fission_decay_equilibrium_factors[0] * this.baseProcessDecayFactor;
        double iodineEquilibrium = NCConfig.fission_decay_equilibrium_factors[1] * this.baseProcessDecayFactor;
        double poisonEquilibrium = NCConfig.fission_decay_equilibrium_factors[2] * this.baseProcessDecayFactor;
        if (this.isProcessing) {
            if (this.decayHeatFraction <= decayHeatEquilibrium) {
                this.decayHeatFraction = MathHelper.func_151237_a((double)(this.decayHeatFraction + (NCConfig.fission_decay_term_multipliers[0] * (decayHeatEquilibrium - this.decayHeatFraction) + NCConfig.fission_decay_term_multipliers[1] * decayHeatEquilibrium) / NCConfig.fission_decay_build_up_times[0]), (double)0.0, (double)decayHeatEquilibrium);
                decayHeatReduce = false;
            }
            if (this.iodineFraction <= iodineEquilibrium) {
                this.iodineFraction = MathHelper.func_151237_a((double)(this.iodineFraction + (NCConfig.fission_decay_term_multipliers[0] * (iodineEquilibrium - this.iodineFraction) + NCConfig.fission_decay_term_multipliers[1] * iodineEquilibrium) / NCConfig.fission_decay_build_up_times[1]), (double)0.0, (double)iodineEquilibrium);
                iodineReduce = false;
            }
            if (this.poisonFraction <= poisonEquilibrium) {
                this.poisonFraction = MathHelper.func_151237_a((double)(this.poisonFraction + (NCConfig.fission_decay_term_multipliers[0] * (poisonEquilibrium - this.poisonFraction) + NCConfig.fission_decay_term_multipliers[1] * poisonEquilibrium) / NCConfig.fission_decay_build_up_times[2]), (double)0.0, (double)poisonEquilibrium);
                poisonReduce = false;
            }
        }
        double decayHeatFractionReduction = 0.0;
        if (decayHeatReduce) {
            decayHeatFractionReduction = Math.min(this.decayHeatFraction, (NCConfig.fission_decay_term_multipliers[0] * this.decayHeatFraction + NCConfig.fission_decay_term_multipliers[1] * decayHeatEquilibrium) / NCConfig.fission_decay_lifetimes[0]);
            this.decayHeatFraction = Math.max(0.0, this.decayHeatFraction - decayHeatFractionReduction);
        }
        double poisonParentFractionReduction = 0.0;
        if (iodineReduce) {
            poisonParentFractionReduction = Math.min(this.iodineFraction, (NCConfig.fission_decay_term_multipliers[0] * this.iodineFraction + NCConfig.fission_decay_term_multipliers[1] * iodineEquilibrium) / NCConfig.fission_decay_lifetimes[1]);
            this.iodineFraction = Math.max(0.0, this.iodineFraction - poisonParentFractionReduction + NCConfig.fission_decay_daughter_multipliers[0] * decayHeatFractionReduction);
        }
        double poisonFractionReduction = 0.0;
        if (poisonReduce) {
            poisonFractionReduction = Math.min(this.poisonFraction, (NCConfig.fission_decay_term_multipliers[0] * this.poisonFraction + NCConfig.fission_decay_term_multipliers[1] * poisonEquilibrium) / NCConfig.fission_decay_lifetimes[2]);
            this.poisonFraction = Math.max(0.0, this.poisonFraction - poisonFractionReduction + NCConfig.fission_decay_daughter_multipliers[1] * poisonParentFractionReduction);
        }
        boolean refreshReactor = false;
        boolean refreshCluster = false;
        if (oldCriticality != this.getCriticality()) {
            if (this.isProcessing) {
                if (oldHasEnoughFlux && !this.hasEnoughFlux()) {
                    refreshReactor = true;
                } else {
                    refreshCluster = true;
                }
            } else if (oldCriticality > (long)this.baseProcessCriticality && this.getCriticality() <= (long)this.baseProcessCriticality) {
                refreshReactor = true;
            }
        }
        if (!this.isProcessing && oldDecayHeating != this.getDecayHeating()) {
            if (this.getDecayHeating() == 0) {
                refreshReactor = true;
            } else {
                refreshCluster = true;
            }
        }
        if (refreshReactor) {
            ((FissionReactor)this.getMultiblock()).refreshFlag = true;
        } else if (refreshCluster) {
            ((FissionReactor)this.getMultiblock()).addClusterToRefresh(this.cluster);
        }
    }

    public int getDecayHeating() {
        return NCConfig.fission_decay_mechanics ? NCMath.toInt(this.getFloatingPointDecayHeating()) : 0;
    }

    public double getFloatingPointDecayHeating() {
        return NCConfig.fission_decay_mechanics ? this.decayProcessHeat * this.decayHeatFraction : 0.0;
    }

    @Override
    public void refreshRecipe() {
        this.recipeInfo = NCRecipes.solid_fission.getRecipeInfoFromInputs(this.getItemInputs(this.hasConsumed), new ArrayList<Tank>());
        this.consumeInputs();
    }

    @Override
    public void refreshActivity() {
        boolean wasReady = this.readyToProcess(false);
        this.canProcessInputs = this.canProcessInputs();
        if (this.getMultiblock() != null && !wasReady && this.readyToProcess(false)) {
            ((FissionReactor)this.getMultiblock()).refreshFlag = true;
        }
    }

    @Override
    public void refreshActivityOnProduction() {
        this.canProcessInputs = this.canProcessInputs();
    }

    public double getSpeedMultiplier() {
        return 1.0 / this.undercoolingLifetimeFactor;
    }

    public boolean setRecipeStats() {
        if (this.recipeInfo == null) {
            this.baseProcessTime = 1.0;
            this.baseProcessHeat = 0;
            this.baseProcessEfficiency = 0.0;
            this.baseProcessCriticality = 1;
            this.selfPriming = false;
            this.baseProcessRadiation = 0.0;
            return false;
        }
        BasicRecipe recipe = this.recipeInfo.getRecipe();
        this.baseProcessTime = recipe.getFissionFuelTime();
        this.baseProcessHeat = recipe.getFissionFuelHeat();
        this.decayProcessHeat = this.baseProcessHeat;
        this.baseProcessEfficiency = recipe.getFissionFuelEfficiency();
        this.baseProcessCriticality = recipe.getFissionFuelCriticality();
        this.baseProcessDecayFactor = recipe.getFissionFuelDecayFactor();
        this.selfPriming = recipe.getFissionFuelSelfPriming();
        this.baseProcessRadiation = recipe.getFissionFuelRadiation();
        return true;
    }

    public boolean isProcessing(boolean checkCluster) {
        return this.readyToProcess(checkCluster) && this.hasEnoughFlux();
    }

    public boolean readyToProcess(boolean checkCluster) {
        return this.canProcessInputs && this.hasConsumed && this.isMultiblockAssembled() && (!checkCluster || this.cluster != null);
    }

    public boolean hasEnoughFlux() {
        return this.flux >= this.getCriticality();
    }

    public boolean hasConsumed() {
        if (this.field_145850_b.field_72995_K) {
            return this.hasConsumed;
        }
        for (int i = 0; i < 1; ++i) {
            if (((ItemStack)this.consumedStacks.get(i)).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public boolean canProcessInputs() {
        boolean canProcess;
        boolean validRecipe = this.setRecipeStats();
        boolean bl = canProcess = validRecipe && this.canProduceProducts();
        if (this.hasConsumed && !validRecipe) {
            for (int i = 0; i < 1; ++i) {
                this.getItemInputs(true).set(i, ItemStack.field_190927_a);
            }
            this.hasConsumed = false;
        }
        if (!canProcess) {
            this.time = MathHelper.func_151237_a((double)this.time, (double)0.0, (double)(this.baseProcessTime - 1.0));
        }
        return canProcess;
    }

    public boolean canProduceProducts() {
        for (int j = 0; j < 1; ++j) {
            IItemIngredient itemProduct = this.getItemProducts().get(j);
            if (itemProduct.getMaxStackSize(0) <= 0) continue;
            if (itemProduct.getStack() == null || ((ItemStack)itemProduct.getStack()).func_190926_b()) {
                return false;
            }
            if (((ItemStack)this.getInventoryStacks().get(j + 1)).func_190926_b()) continue;
            if (!((ItemStack)this.getInventoryStacks().get(j + 1)).func_77969_a((ItemStack)itemProduct.getStack())) {
                return false;
            }
            if (((ItemStack)this.getInventoryStacks().get(j + 1)).func_190916_E() + itemProduct.getMaxStackSize(0) <= ((ItemStack)this.getInventoryStacks().get(j + 1)).func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public void consumeInputs() {
        int i;
        if (this.hasConsumed || this.recipeInfo == null) {
            return;
        }
        IntList itemInputOrder = this.recipeInfo.getItemInputOrder();
        if (itemInputOrder == AbstractRecipeHandler.INVALID) {
            return;
        }
        for (i = 0; i < 1; ++i) {
            if (((ItemStack)this.consumedStacks.get(i)).func_190926_b()) continue;
            this.consumedStacks.set(i, (Object)ItemStack.field_190927_a);
        }
        for (i = 0; i < 1; ++i) {
            int maxStackSize = this.getItemIngredients().get((Integer)itemInputOrder.get(i)).getMaxStackSize((Integer)this.recipeInfo.getItemIngredientNumbers().get(i));
            if (maxStackSize > 0) {
                this.consumedStacks.set(i, (Object)new ItemStack(((ItemStack)this.getInventoryStacks().get(i)).func_77973_b(), maxStackSize, StackHelper.getMetadata((ItemStack)this.getInventoryStacks().get(i))));
                ((ItemStack)this.getInventoryStacks().get(i)).func_190918_g(maxStackSize);
            }
            if (((ItemStack)this.getInventoryStacks().get(i)).func_190916_E() > 0) continue;
            this.getInventoryStacks().set(i, (Object)ItemStack.field_190927_a);
        }
        this.hasConsumed = true;
    }

    public void process() {
        this.time += this.getSpeedMultiplier();
        this.getRadiationSource().setRadiationLevel(this.baseProcessRadiation * this.getSpeedMultiplier());
        while (this.time >= this.baseProcessTime) {
            this.finishProcess();
        }
    }

    public void finishProcess() {
        double oldProcessTime = this.baseProcessTime;
        double oldProcessEfficiency = this.baseProcessEfficiency;
        double oldProcessDecayFactor = this.baseProcessDecayFactor;
        int oldProcessHeat = this.baseProcessHeat;
        long oldCriticality = this.getCriticality();
        this.produceProducts();
        this.refreshRecipe();
        this.time = Math.max(0.0, this.time - oldProcessTime);
        this.refreshActivityOnProduction();
        if (!this.canProcessInputs) {
            this.time = 0.0;
        }
        if (this.getMultiblock() != null) {
            if (this.canProcessInputs) {
                if (oldProcessHeat != this.baseProcessHeat || oldProcessEfficiency != this.baseProcessEfficiency || oldProcessDecayFactor != this.baseProcessDecayFactor || oldCriticality != this.getCriticality()) {
                    if (!this.hasEnoughFlux()) {
                        ((FissionReactor)this.getMultiblock()).refreshFlag = true;
                    } else {
                        ((FissionReactor)this.getMultiblock()).addClusterToRefresh(this.cluster);
                    }
                }
            } else {
                this.sourceEfficiency = null;
                ((FissionReactor)this.getMultiblock()).refreshFlag = true;
            }
        }
    }

    public void produceProducts() {
        for (int i = 0; i < 1; ++i) {
            this.consumedStacks.set(i, (Object)ItemStack.field_190927_a);
        }
        if (!this.hasConsumed || this.recipeInfo == null) {
            return;
        }
        for (int j = 0; j < 1; ++j) {
            IItemIngredient itemProduct = this.getItemProducts().get(j);
            if (itemProduct.getNextStackSize(0) <= 0) continue;
            if (((ItemStack)this.getInventoryStacks().get(j + 1)).func_190926_b()) {
                this.getInventoryStacks().set(j + 1, (Object)itemProduct.getNextStack(0));
                continue;
            }
            if (!((ItemStack)this.getInventoryStacks().get(j + 1)).func_77969_a((ItemStack)itemProduct.getStack())) continue;
            int count = Math.min(this.func_70297_j_(), ((ItemStack)this.getInventoryStacks().get(j + 1)).func_190916_E() + itemProduct.getNextStackSize(0));
            ((ItemStack)this.getInventoryStacks().get(j + 1)).func_190920_e(count);
        }
        this.hasConsumed = false;
    }

    @Override
    public int getItemInputSize() {
        return 1;
    }

    @Override
    public int getItemOutputSize() {
        return 1;
    }

    @Override
    public int getOtherSlotsSize() {
        return 0;
    }

    @Override
    public List<ItemStack> getItemInputs(boolean consumed) {
        return consumed ? this.consumedStacks : this.getInventoryStacks().subList(0, 1);
    }

    @Override
    public List<IItemIngredient> getItemIngredients() {
        return this.recipeInfo.getRecipe().getItemIngredients();
    }

    @Override
    public List<IItemIngredient> getItemProducts() {
        return this.recipeInfo.getRecipe().getItemProducts();
    }

    @Override
    public String func_70005_c_() {
        return "nuclearcraft.container.fission_cell";
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getInventoryStacks() {
        return !PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ? this.masterPort.getInventoryStacks() : this.inventoryStacks;
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getInventoryStacksInternal() {
        return this.inventoryStacks;
    }

    @Nonnull
    public NonNullList<ItemStack> getConsumedStacksInternal() {
        return this.consumedStacks;
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = ITileFilteredInventory.super.func_70298_a(slot, amount);
        if (!this.field_145850_b.field_72995_K) {
            if (slot < 1) {
                this.refreshRecipe();
                this.refreshActivity();
            } else if (slot < 2) {
                this.refreshActivity();
            }
        }
        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        ITileFilteredInventory.super.func_70299_a(slot, stack);
        if (!this.field_145850_b.field_72995_K) {
            if (slot < 1) {
                this.refreshRecipe();
                this.refreshActivity();
            } else if (slot < 2) {
                this.refreshActivity();
            }
        }
    }

    @Override
    public void func_70296_d() {
        this.refreshRecipe();
        this.refreshActivity();
        super.func_70296_d();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack.func_190926_b() || slot >= 1) {
            return false;
        }
        ItemStack filter = (ItemStack)this.getFilterStacks().get(slot);
        if (!filter.func_190926_b() && !stack.func_77969_a(filter)) {
            return false;
        }
        return this.isItemValidForSlotInternal(slot, stack);
    }

    @Override
    public boolean isItemValidForSlotInternal(int slot, ItemStack stack) {
        if (stack.func_190926_b() || slot >= 1) {
            return false;
        }
        return NCConfig.smart_processor_input ? NCRecipes.solid_fission.isValidItemInput(slot, stack, this.recipeInfo, this.getItemInputs(false), this.inputItemStacksExcludingSlot(slot)) : NCRecipes.solid_fission.isValidItemInput(slot, stack);
    }

    public List<ItemStack> inputItemStacksExcludingSlot(int slot) {
        ArrayList<ItemStack> inputItemsExcludingSlot = new ArrayList<ItemStack>(this.getItemInputs(false));
        inputItemsExcludingSlot.remove(slot);
        return inputItemsExcludingSlot;
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return ITileFilteredInventory.super.func_180462_a(slot, stack, side) && this.func_94041_b(slot, stack);
    }

    @Override
    public boolean hasConfigurableInventoryConnections() {
        return false;
    }

    @Override
    public void clearAllSlots() {
        ITileFilteredInventory.super.clearAllSlots();
        for (int i = 0; i < this.consumedStacks.size(); ++i) {
            this.consumedStacks.set(i, (Object)ItemStack.field_190927_a);
        }
        this.hasConsumed = false;
        this.refreshRecipe();
        this.refreshActivity();
        this.refreshIsProcessing(true);
    }

    @Override
    @Nonnull
    public InventoryConnection[] getInventoryConnections() {
        return this.inventoryConnections;
    }

    @Override
    public void setInventoryConnections(@Nonnull InventoryConnection[] connections) {
        this.inventoryConnections = connections;
    }

    @Override
    public ItemOutputSetting getItemOutputSetting(int slot) {
        return ItemOutputSetting.DEFAULT;
    }

    @Override
    public void setItemOutputSetting(int slot, ItemOutputSetting setting) {
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getFilterStacks() {
        return !PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ? this.masterPort.getFilterStacks() : this.filterStacks;
    }

    @Override
    public boolean canModifyFilter(int slot) {
        return this.getMultiblock() != null ? !((FissionReactor)this.getMultiblock()).isAssembled() : true;
    }

    @Override
    public void onFilterChanged(int slot) {
        this.func_70296_d();
    }

    @Override
    public Object getFilterKey() {
        return ((ItemStack)this.getFilterStacks().get(0)).func_190926_b() ? 0 : RecipeItemHelper.func_194113_b((ItemStack)((ItemStack)this.getFilterStacks().get(0)));
    }

    @Override
    public int getGuiID() {
        return 201;
    }

    @Override
    public Set<EntityPlayer> getTileUpdatePacketListeners() {
        return this.updatePacketListeners;
    }

    @Override
    public SolidFissionCellUpdatePacket getTileUpdatePacket() {
        return new SolidFissionCellUpdatePacket(this.field_174879_c, this.masterPortPos, this.getFilterStacks(), this.cluster, this.isProcessing, this.time, this.baseProcessTime);
    }

    @Override
    public void onTileUpdatePacket(SolidFissionCellUpdatePacket message) {
        this.masterPortPos = message.masterPortPos;
        if (PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ^ this.masterPort == null) {
            this.refreshMasterPort();
        }
        this.getFilterStacks().set(0, (Object)message.filterStack);
        this.clusterHeatStored = message.clusterHeatStored;
        this.clusterHeatCapacity = message.clusterHeatCapacity;
        this.isProcessing = message.isProcessing;
        this.time = message.time;
        this.baseProcessTime = message.baseProcessTime;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeInventory(nbt);
        this.writeInventoryConnections(nbt);
        nbt.func_74780_a("baseProcessTime", this.baseProcessTime);
        nbt.func_74768_a("baseProcessHeat", this.baseProcessHeat);
        nbt.func_74780_a("baseProcessEfficiency", this.baseProcessEfficiency);
        nbt.func_74768_a("baseProcessCriticality", this.baseProcessCriticality);
        nbt.func_74780_a("baseProcessDecayFactor", this.baseProcessDecayFactor);
        nbt.func_74757_a("selfPriming", this.selfPriming);
        nbt.func_74780_a("time", this.time);
        nbt.func_74757_a("isProcessing", this.isProcessing);
        nbt.func_74757_a("hasConsumed", this.hasConsumed);
        nbt.func_74757_a("canProcessInputs", this.canProcessInputs);
        nbt.func_74780_a("decayProcessHeat", this.decayProcessHeat);
        nbt.func_74780_a("decayHeatFraction", this.decayHeatFraction);
        nbt.func_74780_a("iodineFraction", this.iodineFraction);
        nbt.func_74780_a("poisonFraction", this.poisonFraction);
        nbt.func_74772_a("flux", this.flux);
        nbt.func_74772_a("clusterHeat", this.heat);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readInventory(nbt);
        this.readInventoryConnections(nbt);
        this.baseProcessTime = nbt.func_74769_h("baseProcessTime");
        this.baseProcessHeat = nbt.func_74762_e("baseProcessHeat");
        this.baseProcessEfficiency = nbt.func_74769_h("baseProcessEfficiency");
        this.baseProcessCriticality = nbt.func_74762_e("baseProcessCriticality");
        this.baseProcessDecayFactor = nbt.func_74769_h("baseProcessDecayFactor");
        this.selfPriming = nbt.func_74767_n("selfPriming");
        this.time = nbt.func_74769_h("time");
        this.isProcessing = nbt.func_74767_n("isProcessing");
        this.hasConsumed = nbt.func_74767_n("hasConsumed");
        this.canProcessInputs = nbt.func_74767_n("canProcessInputs");
        this.decayProcessHeat = nbt.func_74769_h("decayProcessHeat");
        this.decayHeatFraction = nbt.func_74769_h("decayHeatFraction");
        this.iodineFraction = nbt.func_74769_h("iodineFraction");
        this.poisonFraction = nbt.func_74769_h("poisonFraction");
        this.flux = nbt.func_74763_f("flux");
        this.heat = nbt.func_74763_f("clusterHeat");
    }

    @Override
    public NBTTagCompound writeInventory(NBTTagCompound nbt) {
        NBTHelper.writeAllItems(nbt, new List[]{this.inventoryStacks, this.filterStacks, this.consumedStacks});
        return nbt;
    }

    @Override
    public void readInventory(NBTTagCompound nbt) {
        NBTHelper.readAllItems(nbt, new List[]{this.inventoryStacks, this.filterStacks, this.consumedStacks});
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return !this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (!this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side)) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getItemHandler(side));
            }
            return null;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public IItemHandler getItemHandler(@Nullable EnumFacing side) {
        return ITileFilteredInventory.super.getItemHandler(side);
    }
}

