/*
 * Decompiled with CFR 0.152.
 */
package nc.network.multiblock;

import io.netty.buffer.ByteBuf;
import nc.multiblock.heatExchanger.HeatExchanger;
import nc.multiblock.heatExchanger.tile.IHeatExchangerPart;
import nc.multiblock.heatExchanger.tile.TileHeatExchangerController;
import nc.network.multiblock.MultiblockUpdatePacket;
import net.minecraft.util.math.BlockPos;

public class HeatExchangerUpdatePacket
extends MultiblockUpdatePacket {
    public boolean isHeatExchangerOn;
    public double fractionOfTubesActive;
    public double efficiency;
    public double maxEfficiency;

    public HeatExchangerUpdatePacket() {
    }

    public HeatExchangerUpdatePacket(BlockPos pos, boolean isHeatExchangerOn, double fractionOfTubesActive, double efficiency, double maxEfficiency) {
        this.pos = pos;
        this.isHeatExchangerOn = isHeatExchangerOn;
        this.fractionOfTubesActive = fractionOfTubesActive;
        this.efficiency = efficiency;
        this.maxEfficiency = maxEfficiency;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.isHeatExchangerOn = buf.readBoolean();
        this.fractionOfTubesActive = buf.readDouble();
        this.efficiency = buf.readDouble();
        this.maxEfficiency = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeBoolean(this.isHeatExchangerOn);
        buf.writeDouble(this.fractionOfTubesActive);
        buf.writeDouble(this.efficiency);
        buf.writeDouble(this.maxEfficiency);
    }

    public static class Handler
    extends MultiblockUpdatePacket.Handler<HeatExchanger, IHeatExchangerPart, HeatExchangerUpdatePacket, TileHeatExchangerController, HeatExchangerUpdatePacket> {
        public Handler() {
            super(TileHeatExchangerController.class);
        }

        @Override
        protected void onPacket(HeatExchangerUpdatePacket message, HeatExchanger multiblock) {
            multiblock.onMultiblockUpdatePacket(message);
        }
    }
}

