/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.multiblock;

import java.util.ArrayList;
import java.util.List;
import nc.config.NCConfig;
import nc.recipe.BasicRecipeHandler;

public class PebbleFissionRecipes
extends BasicRecipeHandler {
    public PebbleFissionRecipes() {
        super("pebble_fission", 1, 0, 1, 0);
    }

    @Override
    public void addRecipes() {
        this.addFuelDepleteRecipes(NCConfig.fission_thorium_fuel_time, NCConfig.fission_thorium_heat_generation, NCConfig.fission_thorium_efficiency, NCConfig.fission_thorium_criticality, NCConfig.fission_thorium_decay_factor, NCConfig.fission_thorium_self_priming, NCConfig.fission_thorium_radiation, "TBU");
        this.addFuelDepleteRecipes(NCConfig.fission_uranium_fuel_time, NCConfig.fission_uranium_heat_generation, NCConfig.fission_uranium_efficiency, NCConfig.fission_uranium_criticality, NCConfig.fission_uranium_decay_factor, NCConfig.fission_uranium_self_priming, NCConfig.fission_uranium_radiation, "LEU233", "HEU233", "LEU235", "HEU235");
        this.addFuelDepleteRecipes(NCConfig.fission_neptunium_fuel_time, NCConfig.fission_neptunium_heat_generation, NCConfig.fission_neptunium_efficiency, NCConfig.fission_neptunium_criticality, NCConfig.fission_neptunium_decay_factor, NCConfig.fission_neptunium_self_priming, NCConfig.fission_neptunium_radiation, "LEN236", "HEN236");
        this.addFuelDepleteRecipes(NCConfig.fission_plutonium_fuel_time, NCConfig.fission_plutonium_heat_generation, NCConfig.fission_plutonium_efficiency, NCConfig.fission_plutonium_criticality, NCConfig.fission_plutonium_decay_factor, NCConfig.fission_plutonium_self_priming, NCConfig.fission_plutonium_radiation, "LEP239", "HEP239", "LEP241", "HEP241");
        this.addFuelDepleteRecipes(NCConfig.fission_mixed_fuel_time, NCConfig.fission_mixed_heat_generation, NCConfig.fission_mixed_efficiency, NCConfig.fission_mixed_criticality, NCConfig.fission_mixed_decay_factor, NCConfig.fission_mixed_self_priming, NCConfig.fission_mixed_radiation, "MIX239", "MIX241");
        this.addFuelDepleteRecipes(NCConfig.fission_americium_fuel_time, NCConfig.fission_americium_heat_generation, NCConfig.fission_americium_efficiency, NCConfig.fission_americium_criticality, NCConfig.fission_americium_decay_factor, NCConfig.fission_americium_self_priming, NCConfig.fission_americium_radiation, "LEA242", "HEA242");
        this.addFuelDepleteRecipes(NCConfig.fission_curium_fuel_time, NCConfig.fission_curium_heat_generation, NCConfig.fission_curium_efficiency, NCConfig.fission_curium_criticality, NCConfig.fission_curium_decay_factor, NCConfig.fission_curium_self_priming, NCConfig.fission_curium_radiation, "LECm243", "HECm243", "LECm245", "HECm245", "LECm247", "HECm247");
        this.addFuelDepleteRecipes(NCConfig.fission_berkelium_fuel_time, NCConfig.fission_berkelium_heat_generation, NCConfig.fission_berkelium_efficiency, NCConfig.fission_berkelium_criticality, NCConfig.fission_berkelium_decay_factor, NCConfig.fission_berkelium_self_priming, NCConfig.fission_berkelium_radiation, "LEB248", "HEB248");
        this.addFuelDepleteRecipes(NCConfig.fission_californium_fuel_time, NCConfig.fission_californium_heat_generation, NCConfig.fission_californium_efficiency, NCConfig.fission_californium_criticality, NCConfig.fission_californium_decay_factor, NCConfig.fission_californium_self_priming, NCConfig.fission_californium_radiation, "LECf249", "HECf249", "LECf251", "HECf251");
    }

    public void addFuelDepleteRecipes(int[] time, int[] heat, double[] efficiency, int[] criticality, double[] decayFactor, boolean[] selfPriming, double[] radiation, String ... fuelTypes) {
        int id = 0;
        for (String fuelType : fuelTypes) {
            this.addRecipe("ingot" + fuelType + "TRISO", "ingotDepleted" + fuelType + "TRISO", time[id], heat[id], efficiency[id], criticality[id], decayFactor[id], selfPriming[id], radiation[id]);
            id += 5;
        }
    }

    @Override
    public List<Object> fixExtras(List<Object> extras) {
        ArrayList<Object> fixed = new ArrayList<Object>(7);
        fixed.add(extras.size() > 0 && extras.get(0) instanceof Integer ? (Integer)extras.get(0) : 1);
        fixed.add(extras.size() > 1 && extras.get(1) instanceof Integer ? (Integer)extras.get(1) : 0);
        fixed.add(extras.size() > 2 && extras.get(2) instanceof Double ? (Double)extras.get(2) : 0.0);
        fixed.add(extras.size() > 3 && extras.get(3) instanceof Integer ? (Integer)extras.get(3) : 1);
        fixed.add(extras.size() > 4 && extras.get(4) instanceof Double ? (Double)extras.get(4) : 0.0);
        fixed.add(extras.size() > 5 && extras.get(5) instanceof Boolean ? (Boolean)extras.get(5) : false);
        fixed.add(extras.size() > 6 && extras.get(6) instanceof Double ? (Double)extras.get(6) : 0.0);
        return fixed;
    }
}

