/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.internal.fluid;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class Tank
extends FluidTank {
    private List<String> allowedFluids;

    public Tank(int capacity, List<String> allowedFluids) {
        super(capacity);
        this.allowedFluids = allowedFluids;
    }

    public boolean canFillFluidType(FluidStack fluidIn) {
        return fluidIn != null && this.canFillFluidType(fluidIn.getFluid());
    }

    public boolean canFillFluidType(Fluid fluidIn) {
        return fluidIn != null && (this.allowedFluids == null || this.allowedFluids.contains(fluidIn.getName()));
    }

    public void setAllowedFluids(List<String> allowedFluids) {
        if (allowedFluids == null) {
            this.allowedFluids = null;
        } else {
            if (this.allowedFluids == null) {
                this.allowedFluids = new ArrayList<String>();
            } else {
                this.allowedFluids.clear();
            }
            this.allowedFluids.addAll(allowedFluids);
        }
    }

    public void changeFluidStored(Fluid fluidIn, int amount) {
        if (fluidIn == null || (amount += this.getFluidAmount()) <= 0) {
            this.fluid = null;
            return;
        }
        this.fluid = new FluidStack(fluidIn, amount > this.capacity ? this.capacity : amount);
    }

    public void changeFluidAmount(int amount) {
        if (this.fluid == null || (amount += this.getFluidAmount()) <= 0) {
            this.fluid = null;
            return;
        }
        this.fluid = new FluidStack(this.fluid, amount > this.capacity ? this.capacity : amount);
    }

    public void setFluidStored(FluidStack stack) {
        if (stack == null || stack.amount <= 0) {
            this.fluid = null;
            return;
        }
        if (stack.amount > this.capacity) {
            stack.amount = this.capacity;
        }
        this.fluid = stack;
    }

    public void setFluidAmount(int amount) {
        if (amount <= 0) {
            this.fluid = null;
        }
        if (this.fluid == null) {
            return;
        }
        this.fluid.amount = amount;
    }

    public void setTankCapacity(int newCapacity) {
        this.capacity = Math.max(0, newCapacity);
    }

    public boolean isFull() {
        return this.getFluidAmount() >= this.capacity;
    }

    public boolean isEmpty() {
        return this.getFluidAmount() == 0;
    }

    public void mergeTank(Tank other) {
        if (this.fluid == null) {
            this.fluid = other.fluid;
        } else if (!this.fluid.isFluidEqual(other.getFluid())) {
            return;
        }
        this.setFluidAmount(this.getFluidAmount() + other.getFluidAmount());
        this.setTankCapacity(this.capacity + other.capacity);
        other.setFluid(null);
    }

    public IFluidTankProperties getFluidTankProperties() {
        return new FluidTankPropertiesWrapper((FluidTank)this);
    }

    public String getFluidName() {
        return this.fluid == null ? "null" : this.fluid.getFluid().getName();
    }

    public String getFluidLocalizedName() {
        return this.fluid == null ? "" : this.fluid.getLocalizedName();
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound nbt, String name) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("capacity", this.capacity);
        this.writeToNBT(tag);
        nbt.func_74782_a(name, (NBTBase)tag);
        return nbt;
    }

    public final Tank readFromNBT(NBTTagCompound nbt, String name) {
        if (nbt.func_150297_b(name, 10)) {
            NBTTagCompound tag = nbt.func_74775_l(name);
            this.setCapacity(tag.func_74762_e("capacity"));
            this.readFromNBT(tag);
        }
        return this;
    }

    public void readInfo(TankInfo info) {
        String name = info.name();
        this.setFluid(name.equals("null") ? null : new FluidStack(FluidRegistry.getFluid((String)name), info.amount()));
    }

    public static class TankInfo {
        private final String name;
        private final int amount;

        public TankInfo(Tank tank) {
            this.name = tank.getFluidName();
            this.amount = tank.getFluidAmount();
        }

        private TankInfo(String name, int amount) {
            this.name = name;
            this.amount = amount;
        }

        public String name() {
            return this.name;
        }

        public int amount() {
            return this.amount;
        }

        public static List<TankInfo> infoList(List<Tank> tanks) {
            ArrayList<TankInfo> infoList = new ArrayList<TankInfo>();
            for (Tank tank : tanks) {
                infoList.add(new TankInfo(tank));
            }
            return infoList;
        }

        public static List<TankInfo> readBuf(ByteBuf buf, byte numberOfTanks) {
            ArrayList<TankInfo> infoList = new ArrayList<TankInfo>();
            for (byte i = 0; i < numberOfTanks; i = (byte)(i + 1)) {
                infoList.add(new TankInfo(ByteBufUtils.readUTF8String((ByteBuf)buf), buf.readInt()));
            }
            return infoList;
        }

        public void writeBuf(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
            buf.writeInt(this.amount);
        }
    }
}

