/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import nc.util.CollectionHelper;

public class StringHelper {
    public static final Object2IntMap<String> NUMBER_S2I_MAP = new Object2IntOpenHashMap();
    public static final Int2ObjectMap<String> NUMBER_I2S_MAP = new Int2ObjectOpenHashMap();

    public static String capitalize(String s) {
        return s.isEmpty() ? s : s.substring(0, 1).toUpperCase(Locale.ROOT) + s.substring(1);
    }

    public static String starting(String s, int length) {
        int fixedLength = Math.min(length, s.length());
        return s.substring(0, fixedLength);
    }

    public static String ending(String s, int length) {
        int fixedLength = Math.min(length, s.length());
        return s.substring(s.length() - fixedLength);
    }

    public static String removePrefix(String s, int length) {
        return s.substring(length);
    }

    public static String removeSuffix(String s, int length) {
        return s.substring(0, s.length() - length);
    }

    public static boolean beginsWith(String s, String check) {
        return StringHelper.starting(s, check.length()).equals(check);
    }

    public static String stringListConcat(List<String> list) {
        return String.join((CharSequence)", ", list);
    }

    @SafeVarargs
    public static String stringListConcat(List<String> first, List<String> ... others) {
        return String.join((CharSequence)", ", CollectionHelper.concatenate(first, others));
    }

    public static String charLine(char c, int length) {
        char[] charArray = new char[length];
        Arrays.fill(charArray, c);
        return new String(charArray);
    }

    public static boolean isGlob(String s) {
        return s.contains("*") || s.contains("?") || s.contains(".") || s.contains("\\");
    }

    public static String regex(String glob) {
        StringBuilder out = new StringBuilder("^");
        block6: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    out.append(".*");
                    continue block6;
                }
                case '?': {
                    out.append('.');
                    continue block6;
                }
                case '.': {
                    out.append("\\.");
                    continue block6;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block6;
                }
                default: {
                    out.append(c);
                }
            }
        }
        out.append('$');
        return out.toString();
    }

    static {
        NUMBER_S2I_MAP.put((Object)"zero", 0);
        NUMBER_S2I_MAP.put((Object)"one", 1);
        NUMBER_S2I_MAP.put((Object)"two", 2);
        NUMBER_S2I_MAP.put((Object)"three", 3);
        NUMBER_S2I_MAP.put((Object)"four", 4);
        NUMBER_S2I_MAP.put((Object)"five", 5);
        NUMBER_S2I_MAP.put((Object)"six", 6);
        NUMBER_S2I_MAP.put((Object)"seven", 7);
        NUMBER_S2I_MAP.put((Object)"eight", 8);
        NUMBER_S2I_MAP.put((Object)"nine", 9);
        NUMBER_S2I_MAP.put((Object)"ten", 10);
        for (Object2IntMap.Entry entry : NUMBER_S2I_MAP.object2IntEntrySet()) {
            NUMBER_I2S_MAP.put(entry.getIntValue(), entry.getKey());
        }
        for (int i = 0; i <= 10; ++i) {
            NUMBER_S2I_MAP.put((Object)Integer.toString(i), i);
        }
    }
}

