/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureData;

public class StructureHelper {
    public static final StructureHelper CACHE = new StructureHelper();
    private final Object2BooleanMap<StructureCacheEntry> structureCache = new Object2BooleanOpenHashMap();

    public void clear() {
        this.structureCache.clear();
    }

    public boolean isInStructure(World world, @Nonnull String structure, BlockPos pos) {
        int dimension = world.field_73011_w.getDimension();
        ChunkPos cp = new ChunkPos(pos);
        long cplong = ChunkPos.func_77272_a((int)cp.field_77276_a, (int)cp.field_77275_b);
        StructureCacheEntry entry = new StructureCacheEntry(structure, dimension, cplong);
        if (this.structureCache.containsKey((Object)entry)) {
            return (Boolean)this.structureCache.get((Object)entry);
        }
        MapGenStructureData data = (MapGenStructureData)world.getPerWorldStorage().func_75742_a(MapGenStructureData.class, structure);
        if (data == null) {
            this.structureCache.put((Object)entry, false);
            return false;
        }
        LongSet longs = StructureHelper.parseStructureData(data);
        for (Long l : longs) {
            this.structureCache.put((Object)new StructureCacheEntry(structure, dimension, l), true);
        }
        if (this.structureCache.containsKey((Object)entry)) {
            return true;
        }
        this.structureCache.put((Object)entry, false);
        return false;
    }

    private static LongSet parseStructureData(MapGenStructureData data) {
        LongOpenHashSet chunks = new LongOpenHashSet();
        NBTTagCompound nbttagcompound = data.func_143041_a();
        for (String s : nbttagcompound.func_150296_c()) {
            NBTTagCompound nbt;
            NBTBase nbtbase = nbttagcompound.func_74781_a(s);
            if (nbtbase.func_74732_a() != 10 || !(nbt = (NBTTagCompound)nbtbase).func_74764_b("ChunkX") || !nbt.func_74764_b("ChunkZ")) continue;
            int i = nbt.func_74762_e("ChunkX");
            int j = nbt.func_74762_e("ChunkZ");
            chunks.add(ChunkPos.func_77272_a((int)i, (int)j));
        }
        return chunks;
    }

    public static class StructureCacheEntry {
        @Nonnull
        private final String structure;
        private final int dimension;
        private final long chunkpos;

        public StructureCacheEntry(@Nonnull String structure, int dimension, long chunkpos) {
            this.structure = structure;
            this.dimension = dimension;
            this.chunkpos = chunkpos;
        }

        @Nonnull
        public String getStructure() {
            return this.structure;
        }

        public int getDimension() {
            return this.dimension;
        }

        public long getChunkpos() {
            return this.chunkpos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof StructureCacheEntry)) {
                return false;
            }
            StructureCacheEntry that = (StructureCacheEntry)o;
            if (this.dimension != that.dimension) {
                return false;
            }
            if (this.chunkpos != that.chunkpos) {
                return false;
            }
            return this.structure.equals(that.structure);
        }

        public int hashCode() {
            int result = this.structure.hashCode();
            result = 31 * result + this.dimension;
            result = 31 * result + (int)(this.chunkpos ^ this.chunkpos >>> 32);
            return result;
        }
    }
}

