/*
 * Decompiled with CFR 0.152.
 */
package nc.worldgen.biome;

import java.util.Random;
import nc.entity.EntityFeralGhoul;
import nc.init.NCBlocks;
import nc.worldgen.biome.NCBiome;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeNuclearWasteland
extends NCBiome {
    protected int portalGenChance = 256;

    public BiomeNuclearWasteland() {
        super(new Biome.BiomeProperties("Nuclear Wasteland").func_185398_c(0.12f).func_185400_d(0.02f).func_185410_a(2.0f).func_185402_a(10046464).func_185396_a());
        this.field_76752_A = NCBlocks.wasteland_earth.func_176223_P();
        this.field_76753_B = Blocks.field_150354_m.func_176223_P();
        this.waterBlock = FluidRegistry.getFluid((String)"corium").getBlock().func_176223_P();
        this.frozenBlock = Blocks.field_189877_df.func_176223_P();
        this.setSpawnables();
        this.setFlowers();
    }

    protected void setSpawnables() {
        this.field_76761_J.clear();
        this.field_76762_K.clear();
        this.field_76755_L.clear();
        this.field_82914_M.clear();
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityFeralGhoul.class, Short.MAX_VALUE, 1, 1));
    }

    protected void setFlowers() {
        this.flowers.clear();
        this.addFlower(NCBlocks.glowing_mushroom.func_176223_P(), 10);
    }

    public BiomeDecorator func_76729_a() {
        return this.getModdedBiomeDecorator(new Decorator());
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return field_76757_N;
    }

    public WorldGenerator func_76730_b(Random rand) {
        return new WorldGenTallGrass(BlockTallGrass.EnumType.DEAD_BUSH);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return 10330225;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        return this.getModdedBiomeGrassColor(10046464);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        return this.getModdedBiomeFoliageColor(10046464);
    }

    public static class Decorator
    extends BiomeDecorator {
        protected void func_150513_a(Biome biomeIn, World worldIn, Random random) {
            super.func_150513_a(biomeIn, worldIn, random);
            if (biomeIn instanceof BiomeNuclearWasteland) {
                BiomeNuclearWasteland wasteland = (BiomeNuclearWasteland)biomeIn;
                if (random.nextInt(wasteland.portalGenChance) == 0) {
                    int z;
                    int y;
                    int x = random.nextInt(16) + 8;
                    if (new WorldGenLakes(NCBlocks.wasteland_portal).func_180709_b(worldIn, random, this.field_180294_c.func_177982_a(x, y = random.nextInt(worldIn.func_72800_K()), z = random.nextInt(16) + 8))) {
                        wasteland.portalGenChance = 256;
                    }
                } else {
                    --wasteland.portalGenChance;
                }
            }
        }
    }
}

