/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.init.MPItems;
import stevekung.mods.moreplanets.init.MPPotions;
import stevekung.mods.moreplanets.planets.nibiru.world.gen.biome.BiomeGreenVeinFields;
import stevekung.mods.moreplanets.utils.items.IDungeonKey;
import stevekung.mods.moreplanets.utils.items.IDungeonKeyable;
import stevekung.mods.moreplanets.utils.items.ItemDoorMP;
import stevekung.mods.moreplanets.utils.tileentity.TileEntityTreasureChestMP;
import stevekung.mods.stevekunglib.utils.enums.CachedEnum;

public class GeneralEventHandler {
    private static final List<Block> INFECTED_BLOCK_LIST = new ArrayList<Block>();

    @SubscribeEvent
    public void onFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        Item item = event.getItemStack().func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        if (block == MPBlocks.CHEESE_SPORE_FLOWER || block == MPBlocks.INFECTED_OAK_SAPLING || block == MPBlocks.INFECTED_JUNGLE_SAPLING || block == MPBlocks.INFECTED_SPRUCE_SAPLING || block == MPBlocks.ALIEN_BERRY_OAK_SAPLING || block == MPBlocks.OSCALEA_SAPLING || block == MPBlocks.FROLIA_SAPLING) {
            event.setBurnTime(100);
        } else if (item == MPItems.INFECTED_PURLONITE_SHARD) {
            event.setBurnTime(400);
        } else if (item == MPItems.INFECTED_COAL || item == MPItems.INFECTED_CHARCOAL) {
            event.setBurnTime(1600);
        } else if (ItemStack.func_77970_a((ItemStack)FluidUtil.getFilledBucket((FluidStack)new FluidStack(MPBlocks.INFECTED_PURLONITE_LAVA_FLUID, 1000)), (ItemStack)event.getItemStack())) {
            event.setBurnTime(25000);
        } else if (ItemStack.func_77970_a((ItemStack)FluidUtil.getFilledBucket((FluidStack)new FluidStack(MPBlocks.NUCLEAR_WASTE_FLUID, 1000)), (ItemStack)event.getItemStack())) {
            event.setBurnTime(60000);
        } else if (item instanceof ItemDoorMP) {
            event.setBurnTime(200);
        }
    }

    @SubscribeEvent
    public void onCreateFluidSource(BlockEvent.CreateFluidSourceEvent event) {
        Block block = event.getState().func_177230_c();
        if (block == MPBlocks.INFECTED_PURLONITE_WATER_FLUID_BLOCK || block == MPBlocks.CHEESE_MILK_FLUID_BLOCK || block == MPBlocks.INFECTED_WATER_FLUID_BLOCK) {
            event.setResult(Event.Result.ALLOW);
        }
        if (event.getWorld().func_180494_b(event.getPos()) instanceof BiomeGreenVeinFields && block == MPBlocks.PURIFIED_WATER_FLUID_BLOCK) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        TileEntity tile;
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        ItemStack heldItem = event.getItemStack();
        if (player == null || pos == null || world == null) {
            return;
        }
        if (!heldItem.func_190926_b() && (heldItem.func_77973_b() instanceof ItemSpade || heldItem.func_77973_b().getToolClasses(heldItem) == Collections.singleton("shovel")) && event.getFace() != EnumFacing.DOWN && world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a) {
            if (world.func_180495_p(pos).func_177230_c() == MPBlocks.INFECTED_GRASS_BLOCK) {
                if (!world.field_72995_K) {
                    world.func_184133_a(null, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    world.func_180501_a(pos, MPBlocks.INFECTED_GRASS_PATH.func_176223_P(), 11);
                    heldItem.func_77972_a(1, (EntityLivingBase)player);
                }
                player.func_184609_a(event.getHand());
            } else if (world.func_180495_p(pos).func_177230_c() == MPBlocks.GREEN_VEIN_GRASS_BLOCK) {
                if (!world.field_72995_K) {
                    world.func_184133_a(null, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    world.func_180501_a(pos, MPBlocks.GREEN_VEIN_GRASS_PATH.func_176223_P(), 11);
                    heldItem.func_77972_a(1, (EntityLivingBase)player);
                }
                player.func_184609_a(event.getHand());
            }
        }
        if ((tile = world.func_175625_s(pos)) != null && tile instanceof TileEntityTreasureChestMP && tile instanceof IDungeonKeyable) {
            TileEntityTreasureChestMP chest = (TileEntityTreasureChestMP)tile;
            IDungeonKeyable keyable = (IDungeonKeyable)tile;
            if (chest.locked) {
                if (!heldItem.func_190926_b()) {
                    if (heldItem.func_77973_b() instanceof IDungeonKey) {
                        event.setCanceled(keyable.onActivated(player, keyable.getDungeonKey(), true));
                    } else if (!player.func_70093_af()) {
                        event.setCanceled(keyable.onActivated(player, keyable.getDungeonKey(), false));
                    }
                } else {
                    event.setCanceled(keyable.onActivated(player, keyable.getDungeonKey(), false));
                }
            }
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Block block = event.getState().func_177230_c();
        EntityPlayer player = event.getEntityPlayer();
        if (this.isShears(player) && (block == MPBlocks.RED_CANDY_CANE || block == MPBlocks.GREEN_CANDY_CANE || block == MPBlocks.BLUE_CANDY_CANE || block == MPBlocks.ORANGE_CANDY_CANE || block == MPBlocks.PINK_CANDY_CANE || block == MPBlocks.YELLOW_CANDY_CANE || block == MPBlocks.PURPLE_CANDY_CANE || block == MPBlocks.RAINBOW_CANDY_CANE)) {
            event.setNewSpeed(7.5f);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        IBlockState sourceState = event.getState();
        Block sourceBlock = sourceState.func_177230_c();
        EntityPlayer player = event.getPlayer();
        if (sourceBlock == MPBlocks.INFECTED_FARMLAND && event.getWorld().getBiomeForCoordsBody(event.getPos()) instanceof BiomeGreenVeinFields || player == null) {
            return;
        }
        for (Block block : INFECTED_BLOCK_LIST) {
            if (sourceBlock != block || player.func_70644_a(MPPotions.INFECTED_SPORE_PROTECTION) || player.field_71075_bZ.field_75098_d) continue;
            player.func_70690_d(new PotionEffect(MPPotions.INFECTED_SPORE, 60));
        }
        if (sourceBlock.getRegistryName().toString().startsWith("moreplanets")) {
            String sourceName = sourceBlock.func_149739_a().substring(5);
            if (sourceName.startsWith("infected_purlonite")) {
                return;
            }
            if ((sourceName.contains("infected") || sourceName.contains("nibiru")) && !player.func_70644_a(MPPotions.INFECTED_SPORE_PROTECTION) && !player.field_71075_bZ.field_75098_d) {
                player.func_70690_d(new PotionEffect(MPPotions.INFECTED_SPORE, 60));
            }
        }
        if (this.isShears(player) && (sourceBlock == MPBlocks.RED_CANDY_CANE || sourceBlock == MPBlocks.GREEN_CANDY_CANE || sourceBlock == MPBlocks.BLUE_CANDY_CANE || sourceBlock == MPBlocks.ORANGE_CANDY_CANE || sourceBlock == MPBlocks.PINK_CANDY_CANE || sourceBlock == MPBlocks.YELLOW_CANDY_CANE || sourceBlock == MPBlocks.PURPLE_CANDY_CANE || sourceBlock == MPBlocks.RAINBOW_CANDY_CANE)) {
            player.func_184607_cu().func_77972_a(1, (EntityLivingBase)player);
        }
    }

    @SubscribeEvent
    public void onUseHoe(UseHoeEvent event) {
        if (event.getResult() != Event.Result.DEFAULT || event.isCanceled()) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (world.func_175623_d(pos.func_177984_a())) {
            if (block == MPBlocks.CHEESE_DIRT || block == MPBlocks.CHEESE_COARSE_DIRT || block == MPBlocks.CHEESE_GRASS_BLOCK) {
                this.setFarmland(event, world, pos, state, MPBlocks.CHEESE_COARSE_DIRT, MPBlocks.CHEESE_DIRT, MPBlocks.CHEESE_FARMLAND);
            } else if (block == MPBlocks.INFECTED_DIRT || block == MPBlocks.INFECTED_COARSE_DIRT) {
                this.setFarmland(event, world, pos, state, MPBlocks.INFECTED_COARSE_DIRT, MPBlocks.INFECTED_DIRT, MPBlocks.INFECTED_FARMLAND);
            } else if (block == MPBlocks.INFECTED_GRASS_BLOCK || block == MPBlocks.GREEN_VEIN_GRASS_BLOCK) {
                this.setFarmland(event, world, pos, MPBlocks.INFECTED_FARMLAND);
            } else if (block == MPBlocks.FRONOS_GRASS_BLOCK || block == MPBlocks.FRONOS_DIRT || block == MPBlocks.FRONOS_COARSE_DIRT) {
                this.setFarmland(event, world, pos, state, MPBlocks.FRONOS_COARSE_DIRT, MPBlocks.FRONOS_DIRT, MPBlocks.FRONOS_FARMLAND);
            }
        }
    }

    private void setFarmland(UseHoeEvent event, World world, BlockPos pos, IBlockState state, Block coarse, Block dirt, Block farmland) {
        if (state.func_177230_c() == coarse) {
            world.func_175656_a(pos, dirt.func_176223_P());
        } else {
            world.func_175656_a(pos, farmland.func_176223_P());
        }
        event.setResult(Event.Result.ALLOW);
        world.func_184133_a(null, pos, SoundType.field_185849_b.func_185844_d(), SoundCategory.BLOCKS, (SoundType.field_185849_b.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185849_b.func_185847_b() * 0.8f);
        for (EnumHand hand : CachedEnum.handValues) {
            event.getEntityPlayer().func_184609_a(hand);
        }
    }

    private void setFarmland(UseHoeEvent event, World world, BlockPos pos, Block farmland) {
        world.func_175656_a(pos, farmland.func_176223_P());
        event.setResult(Event.Result.ALLOW);
        world.func_184133_a(null, pos, SoundType.field_185849_b.func_185844_d(), SoundCategory.BLOCKS, (SoundType.field_185849_b.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185849_b.func_185847_b() * 0.8f);
        for (EnumHand hand : CachedEnum.handValues) {
            event.getEntityPlayer().func_184609_a(hand);
        }
    }

    private boolean isShears(EntityPlayer player) {
        return !player.func_184607_cu().func_190926_b() && player.func_184607_cu().func_77973_b() instanceof ItemShears;
    }

    static {
        INFECTED_BLOCK_LIST.add(MPBlocks.PURE_HERB);
        INFECTED_BLOCK_LIST.add(MPBlocks.BATASIA_DANDELION);
        INFECTED_BLOCK_LIST.add(MPBlocks.PYOLONIA);
        INFECTED_BLOCK_LIST.add(MPBlocks.PHILIPY);
        INFECTED_BLOCK_LIST.add(MPBlocks.WHITE_TAIL);
        INFECTED_BLOCK_LIST.add(MPBlocks.VEALIUM_VINES);
        INFECTED_BLOCK_LIST.add(MPBlocks.JUICER_EGG);
        INFECTED_BLOCK_LIST.add(MPBlocks.OIL_ORE);
        INFECTED_BLOCK_LIST.add(MPBlocks.SPORELILY);
    }
}

