/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.nibiru.world.gen.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import stevekung.mods.moreplanets.init.MPBlocks;

public class WorldGenInfectedRoofedTree
extends WorldGenAbstractTree {
    private boolean genLeaves;

    public WorldGenInfectedRoofedTree(boolean genLeaves) {
        super(false);
        this.genLeaves = genLeaves;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int i = rand.nextInt(3) + rand.nextInt(2) + 6;
        int j = pos.func_177958_n();
        int k = pos.func_177956_o();
        int l = pos.func_177952_p();
        if (k >= 1 && k + i + 1 < 256) {
            boolean isSoil;
            BlockPos blockpos = pos.func_177977_b();
            IBlockState state = world.func_180495_p(blockpos);
            Block block = state.func_177230_c();
            boolean bl = isSoil = block == MPBlocks.INFECTED_GRASS_BLOCK || block == MPBlocks.INFECTED_DIRT || block == MPBlocks.INFECTED_COARSE_DIRT || block == MPBlocks.INFECTED_FARMLAND;
            if (!isSoil || pos.func_177956_o() >= world.func_72800_K() - i - 1) {
                return false;
            }
            if (!this.placeTreeOfHeight(world, pos, i)) {
                return false;
            }
            this.onPlantGrow(world, blockpos, pos);
            this.onPlantGrow(world, blockpos.func_177974_f(), pos);
            this.onPlantGrow(world, blockpos.func_177968_d(), pos);
            this.onPlantGrow(world, blockpos.func_177968_d().func_177974_f(), pos);
            EnumFacing enumfacing = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
            int i1 = i - rand.nextInt(4);
            int j1 = 2 - rand.nextInt(3);
            int k1 = j;
            int l1 = l;
            int i2 = k + i - 1;
            for (int j2 = 0; j2 < i; ++j2) {
                int k2;
                BlockPos blockpos1;
                if (j2 >= i1 && j1 > 0) {
                    k1 += enumfacing.func_82601_c();
                    l1 += enumfacing.func_82599_e();
                    --j1;
                }
                if (!(state = world.func_180495_p(blockpos1 = new BlockPos(k1, k2 = k + j2, l1))).func_177230_c().isAir(state, (IBlockAccess)world, blockpos1) && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, blockpos1)) continue;
                this.placeLogAt(world, blockpos1);
                this.placeLogAt(world, blockpos1.func_177974_f());
                this.placeLogAt(world, blockpos1.func_177968_d());
                this.placeLogAt(world, blockpos1.func_177974_f().func_177968_d());
            }
            for (int i3 = -2; i3 <= 0; ++i3) {
                for (int l3 = -2; l3 <= 0; ++l3) {
                    int k4 = -1;
                    this.placeLeafAt(world, k1 + i3, i2 + k4, l1 + l3);
                    this.placeLeafAt(world, 1 + k1 - i3, i2 + k4, l1 + l3);
                    this.placeLeafAt(world, k1 + i3, i2 + k4, 1 + l1 - l3);
                    this.placeLeafAt(world, 1 + k1 - i3, i2 + k4, 1 + l1 - l3);
                    if (i3 <= -2 && l3 <= -1 || i3 == -1 && l3 == -2) continue;
                    k4 = 1;
                    this.placeLeafAt(world, k1 + i3, i2 + k4, l1 + l3);
                    this.placeLeafAt(world, 1 + k1 - i3, i2 + k4, l1 + l3);
                    this.placeLeafAt(world, k1 + i3, i2 + k4, 1 + l1 - l3);
                    this.placeLeafAt(world, 1 + k1 - i3, i2 + k4, 1 + l1 - l3);
                }
            }
            if (rand.nextBoolean()) {
                this.placeLeafAt(world, k1, i2 + 2, l1);
                this.placeLeafAt(world, k1 + 1, i2 + 2, l1);
                this.placeLeafAt(world, k1 + 1, i2 + 2, l1 + 1);
                this.placeLeafAt(world, k1, i2 + 2, l1 + 1);
            }
            for (int j3 = -3; j3 <= 4; ++j3) {
                for (int i4 = -3; i4 <= 4; ++i4) {
                    if (j3 == -3 && i4 == -3 || j3 == -3 && i4 == 4 || j3 == 4 && i4 == -3 || j3 == 4 && i4 == 4 || Math.abs(j3) >= 3 && Math.abs(i4) >= 3) continue;
                    this.placeLeafAt(world, k1 + j3, i2, l1 + i4);
                }
            }
            for (int k3 = -1; k3 <= 2; ++k3) {
                for (int j4 = -1; j4 <= 2; ++j4) {
                    if (k3 >= 0 && k3 <= 1 && j4 >= 0 && j4 <= 1 || rand.nextInt(3) > 0) continue;
                    int l4 = rand.nextInt(3) + 2;
                    for (int i5 = 0; i5 < l4; ++i5) {
                        this.placeLogAt(world, new BlockPos(j + k3, i2 - i5 - 1, l + j4));
                    }
                    for (int j5 = -1; j5 <= 1; ++j5) {
                        for (int l2 = -1; l2 <= 1; ++l2) {
                            this.placeLeafAt(world, k1 + k3 + j5, i2, l1 + j4 + l2);
                        }
                    }
                    for (int k5 = -2; k5 <= 2; ++k5) {
                        for (int l5 = -2; l5 <= 2; ++l5) {
                            if (Math.abs(k5) == 2 && Math.abs(l5) == 2) continue;
                            this.placeLeafAt(world, k1 + k3 + k5, i2 - 1, l1 + j4 + l5);
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean placeTreeOfHeight(World world, BlockPos pos, int height) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int l = 0; l <= height + 1; ++l) {
            int i1 = 1;
            if (l == 0) {
                i1 = 0;
            }
            if (l >= height - 1) {
                i1 = 2;
            }
            for (int j1 = -i1; j1 <= i1; ++j1) {
                for (int k1 = -i1; k1 <= i1; ++k1) {
                    if (this.isReplaceable(world, (BlockPos)mutablePos.func_181079_c(i + j1, j + l, k + k1))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void placeLogAt(World world, BlockPos pos) {
        if (this.func_150523_a(world.func_180495_p(pos).func_177230_c())) {
            this.func_175903_a(world, pos, this.genLeaves ? MPBlocks.INFECTED_OAK_LOG.func_176223_P() : MPBlocks.INFECTED_DEADWOOD_LOG.func_176223_P());
        }
    }

    private void placeLeafAt(World world, int x, int y, int z) {
        if (!this.genLeaves) {
            return;
        }
        BlockPos blockpos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(blockpos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)world, blockpos)) {
            this.func_175903_a(world, blockpos, MPBlocks.INFECTED_OAK_LEAVES.func_176223_P());
        }
    }

    private void onPlantGrow(World world, BlockPos pos, BlockPos source) {
        IBlockState state = world.func_180495_p(pos);
        state.func_177230_c().onPlantGrow(state, world, pos, source);
    }
}

