/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.container;

import ic2.core.block.personal.tile.TileEntityTradeOMat;
import ic2.core.inventory.container.ContainerTileComponent;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.personalBlocks.TradeOMatOpenComp;
import ic2.core.inventory.slots.SlotGhoest;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Resources;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerTradeOMatOpen
extends ContainerTileComponent<TileEntityTradeOMat> {
    public ContainerTradeOMatOpen(InventoryPlayer player, TileEntityTradeOMat trade) {
        super(trade);
        int x;
        int y;
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 2; ++x) {
                this.func_75146_a(new SlotGhoest(trade.display, x + y * 2, 26 + x * 18, 28 + y * 18));
            }
        }
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 2; ++x) {
                this.func_75146_a(new SlotGhoest(trade.display, 8 + x + y * 2, 116 + x * 18, 28 + y * 18));
            }
        }
        this.addPlayerInventory(player, 0, 25);
        this.addComponent(new TradeOMatOpenComp(trade));
        if (trade.state == 0 || trade.state == 2) {
            this.lock();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiLoaded(GuiIC2 gui) {
        gui.setMaxGuiY(191);
        gui.setMCOffset(Ic2GuiComp.tradeOMatMCPos);
    }

    @Override
    public ResourceLocation getTexture() {
        return Ic2Resources.tradeOMatOpen;
    }

    @Override
    public int guiInventorySize() {
        return 16;
    }

    @Nullable
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        Slot slot;
        if (slotId >= 0 && slotId < this.guiInventorySize() && (slot = (Slot)this.field_75151_b.get(slotId)) instanceof SlotGhoest) {
            SlotGhoest ghoestSlot = (SlotGhoest)slot;
            if (!ghoestSlot.isLocked()) {
                ghoestSlot.onClick(dragType, clickTypeIn == ClickType.QUICK_MOVE, player.field_71071_by.func_70445_o());
            }
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public void lock() {
        for (Slot slot : this.field_75151_b) {
            if (!(slot instanceof SlotGhoest)) continue;
            ((SlotGhoest)slot).lock();
        }
    }

    public void unlock() {
        for (Slot slot : this.field_75151_b) {
            if (!(slot instanceof SlotGhoest)) continue;
            ((SlotGhoest)slot).unlock();
        }
    }

    public void unlockAndUpdate() {
        this.unlock();
        for (int i = 0; i < this.guiInventorySize(); ++i) {
            ItemStack itemstack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
            for (int j = 0; j < this.field_75149_d.size(); ++j) {
                ((IContainerListener)this.field_75149_d.get(j)).func_71111_a((Container)this, i, itemstack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void clear() {
        for (int i = 0; i < this.guiInventorySize(); ++i) {
            this.func_75139_a(i).func_75215_d(ItemStack.field_190927_a);
        }
    }

    public void unlockInput() {
        int max = this.guiInventorySize() / 2;
        for (int i = 0; i < max; ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (!(slot instanceof SlotGhoest)) continue;
            ((SlotGhoest)slot).unlock();
        }
    }

    public void lockInput() {
        int max = this.guiInventorySize() / 2;
        for (int i = 0; i < max; ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (!(slot instanceof SlotGhoest)) continue;
            ((SlotGhoest)slot).lock();
        }
    }
}

